/*
 * Decompiled with CFR 0.152.
 */
package it.kamaladafrica.codicefiscale.city.impl;

import it.kamaladafrica.codicefiscale.City;
import it.kamaladafrica.codicefiscale.CodiceFiscale;
import it.kamaladafrica.codicefiscale.city.impl.CsvSupplier;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.function.Function;
import java.util.stream.Stream;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;

public final class EsteriCsvSupplier
extends CsvSupplier {
    private EsteriCsvSupplier(URL resource) {
        super(resource, StandardCharsets.UTF_8, EsteriCsvSupplier.buildFormat(), EsteriCsvSupplier.mapper());
    }

    private static Function<CSVRecord, City> mapper() {
        return record -> City.builder().name(record.get(6).toUpperCase(CodiceFiscale.LOCALE)).prov(record.get(2).toUpperCase(CodiceFiscale.LOCALE)).belfiore(record.get(9).toUpperCase(CodiceFiscale.LOCALE)).build();
    }

    @Override
    protected Stream<CSVRecord> streamRecords(CSVParser parser) {
        return super.streamRecords(parser).filter(record -> record.get(9).startsWith("Z"));
    }

    private static CSVFormat buildFormat() {
        return CSVFormat.DEFAULT.withDelimiter(';').withFirstRecordAsHeader().withTrim();
    }

    public static EsteriCsvSupplier of(URL url) {
        return new EsteriCsvSupplier(url);
    }
}

