/*
 * Decompiled with CFR 0.152.
 */
package it.kamaladafrica.codicefiscale.city.impl;

import it.kamaladafrica.codicefiscale.City;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import lombok.Generated;
import lombok.NonNull;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;

public class CsvSupplier
implements Supplier<Stream<City>> {
    @NonNull
    private final URL csvUrl;
    @NonNull
    private final Charset charset;
    @NonNull
    private final CSVFormat format;
    @NonNull
    private final Function<CSVRecord, City> mapper;

    @Override
    public Stream<City> get() {
        try {
            return this.streamRecords(this.parse()).map(this.mapper);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    protected Stream<CSVRecord> streamRecords(CSVParser parser) {
        return StreamSupport.stream(parser.spliterator(), false);
    }

    protected CSVParser parse() throws IOException {
        return CSVParser.parse((URL)this.csvUrl, (Charset)this.charset, (CSVFormat)this.format);
    }

    @NonNull
    @Generated
    private URL getCsvUrl() {
        return this.csvUrl;
    }

    @NonNull
    @Generated
    private Charset getCharset() {
        return this.charset;
    }

    @NonNull
    @Generated
    private CSVFormat getFormat() {
        return this.format;
    }

    @NonNull
    @Generated
    private Function<CSVRecord, City> getMapper() {
        return this.mapper;
    }

    @Generated
    public CsvSupplier(@NonNull URL csvUrl, @NonNull Charset charset, @NonNull CSVFormat format, @NonNull Function<CSVRecord, City> mapper) {
        if (csvUrl == null) {
            throw new NullPointerException("csvUrl is marked non-null but is null");
        }
        if (charset == null) {
            throw new NullPointerException("charset is marked non-null but is null");
        }
        if (format == null) {
            throw new NullPointerException("format is marked non-null but is null");
        }
        if (mapper == null) {
            throw new NullPointerException("mapper is marked non-null but is null");
        }
        this.csvUrl = csvUrl;
        this.charset = charset;
        this.format = format;
        this.mapper = mapper;
    }
}

