/*
 * Decompiled with CFR 0.152.
 */
package it.kamaladafrica.codicefiscale.city.impl;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import it.kamaladafrica.codicefiscale.City;
import it.kamaladafrica.codicefiscale.CodiceFiscale;
import it.kamaladafrica.codicefiscale.city.CityProvider;
import it.kamaladafrica.codicefiscale.city.impl.EsteriCsvSupplier;
import it.kamaladafrica.codicefiscale.city.impl.ItaliaCsvSupplier;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.text.similarity.JaroWinklerSimilarity;
import org.apache.commons.text.similarity.SimilarityScore;
import org.apache.commons.text.similarity.SimilarityScoreFrom;

public final class CityProviderImpl
implements CityProvider {
    public static final double DEFAULT_MINIMUM_MATCH_SCORE = 0.8;
    public static final double EXACT_MATCH_SCORE = 1.0;
    static final String ITALIA_RESOURCE_PATH = "/italia.csv";
    static final String ESTERI_RESOURCE_PATH = "/esteri.csv";
    private final ImmutableMap<String, City> cityByName;
    private final ImmutableMap<String, City> cityByBelfiore;
    private final double minimumMatchScore;

    private CityProviderImpl(Set<City> cities, double minimumMatchScore) {
        this.minimumMatchScore = minimumMatchScore;
        this.cityByName = (ImmutableMap)cities.stream().collect(ImmutableMap.toImmutableMap(CityProviderImpl::cityName, Function.identity()));
        this.cityByBelfiore = (ImmutableMap)cities.stream().collect(ImmutableMap.toImmutableMap(City::getBelfiore, Function.identity()));
    }

    private static String cityName(City city) {
        return String.format("%s(%s)", city.getName(), city.getProv());
    }

    private static String normalize(String s) {
        return Strings.nullToEmpty((String)s).toUpperCase(CodiceFiscale.LOCALE);
    }

    @Override
    public List<City> findAll() {
        return ImmutableList.sortedCopyOf((a, b) -> a.getName().compareTo(b.getName()), (Iterable)this.cityByName.values());
    }

    @Override
    public City findByName(String name) {
        City result = null;
        String term = CityProviderImpl.normalize(name);
        if (!term.isEmpty()) {
            result = (City)this.cityByName.get((Object)term);
            if (this.minimumMatchScore != 1.0 && result == null) {
                SimilarityScoreFrom score = new SimilarityScoreFrom((SimilarityScore)new JaroWinklerSimilarity(), (CharSequence)term);
                result = this.cityByName.entrySet().stream().map(e -> Pair.of(e.getValue(), (Object)score.apply((CharSequence)e.getKey()))).filter(e -> (Double)e.getValue() >= this.minimumMatchScore).max(Comparator.comparing(Map.Entry::getValue)).map(Map.Entry::getKey).orElse(null);
            }
        }
        if (result == null) {
            throw new IllegalArgumentException("not found: " + term);
        }
        return result;
    }

    @Override
    public City findByBelfiore(String belfiore) {
        String term = CityProviderImpl.normalize(belfiore);
        City result = (City)this.cityByBelfiore.get((Object)term);
        if (result == null) {
            throw new IllegalArgumentException("not found: " + term);
        }
        return result;
    }

    public static CityProviderImpl ofDefault() {
        return CityProviderImpl.of(CityProviderImpl.defaultSupplier(), 0.8);
    }

    public static CityProviderImpl of(Supplier<Set<City>> supplier, double minimumMatchScore) {
        return CityProviderImpl.of(supplier.get(), minimumMatchScore);
    }

    public static CityProviderImpl of(Set<City> cities, double minimumMatchScore) {
        return new CityProviderImpl(cities, minimumMatchScore);
    }

    public static CityProviderImpl of(Supplier<Set<City>> supplier) {
        return CityProviderImpl.of(supplier.get(), 0.8);
    }

    public static CityProviderImpl of(Set<City> cities) {
        return CityProviderImpl.of(cities, 0.8);
    }

    private static Supplier<Set<City>> defaultSupplier() {
        return () -> Stream.concat(ItaliaCsvSupplier.of(CityProviderImpl.class.getResource(ITALIA_RESOURCE_PATH)).get(), EsteriCsvSupplier.of(CityProviderImpl.class.getResource(ESTERI_RESOURCE_PATH)).get()).collect(Collectors.toSet());
    }
}

