/*
 * Decompiled with CFR 0.152.
 */
package it.kamaladafrica.codicefiscale;

import it.kamaladafrica.codicefiscale.Person;
import it.kamaladafrica.codicefiscale.city.CityByBelfiore;
import it.kamaladafrica.codicefiscale.city.CityProvider;
import it.kamaladafrica.codicefiscale.internal.BelfiorePart;
import it.kamaladafrica.codicefiscale.internal.ControlPart;
import it.kamaladafrica.codicefiscale.internal.DatePart;
import it.kamaladafrica.codicefiscale.internal.LastnamePart;
import it.kamaladafrica.codicefiscale.internal.NamePart;
import it.kamaladafrica.codicefiscale.utils.OmocodeUtils;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import lombok.Generated;
import org.apache.commons.lang3.Validate;

public final class CodiceFiscale {
    public static final Locale LOCALE = Locale.ITALY;
    private static final String VALIDATION_PATTERN = "^(?:[A-Z][AEIOU][AEIOUX]|[B-DF-HJ-NP-TV-Z]{2}[A-Z]){2}(?:[\\dLMNP-V]{2}(?:[A-EHLMPR-T](?:[04LQ][1-9MNP-V]|[15MR][\\dLMNP-V]|[26NS][0-8LMNP-U])|[DHPS][37PT][0L]|[ACELMRT][37PT][01LM]|[AC-EHLMPR-T][26NS][9V])|(?:[02468LNQSU][048LQU]|[13579MPRTV][26NS])B[26NS][9V])(?:[A-MZ][1-9MNP-V][\\dLMNP-V]{2}|[A-M][0L](?:[1-9MNP-V][\\dLMNP-V]|[0L][1-9MNP-V]))[A-Z]$";
    private static final int CONTROL_PART_INDEX = 15;
    private static final int LASTNAME_PART_INDEX = 0;
    private static final int FIRSTNAME_PART_INDEX = 3;
    private static final int DATE_PART_INDEX = 6;
    private static final int BELFIORE_PART_INDEX = 11;
    private static final int OMOCODE_LEVEL_DATE_OFFSET = 3;
    private final Person person;
    private final LastnamePart lastname;
    private final NamePart firstname;
    private final DatePart date;
    private final BelfiorePart belfiore;
    private final AtomicReference<Object> control = new AtomicReference();
    private final int omocodeLevel;
    private final AtomicReference<Object> value = new AtomicReference();
    private final AtomicReference<Object> uncheckedValue = new AtomicReference();

    public CodiceFiscale(Person person, LastnamePart lastname, NamePart firstname, DatePart date, BelfiorePart belfiore, int omocodeLevel) {
        this.person = person;
        this.lastname = lastname;
        this.firstname = firstname;
        this.date = date;
        this.belfiore = belfiore;
        this.omocodeLevel = omocodeLevel;
    }

    public CodiceFiscale normalized() {
        return this.toOmocodeLevel(0);
    }

    public boolean isEqual(String other) {
        return this.isEqual(CodiceFiscale.of(other));
    }

    public boolean isEqual(CodiceFiscale other) {
        return this.isEqual(other, true);
    }

    public boolean isEqual(String other, boolean ignoreOmocode) {
        return this.isEqual(CodiceFiscale.of(other), ignoreOmocode);
    }

    public boolean isEqual(CodiceFiscale other, boolean ignoreOmocode) {
        CodiceFiscale self = ignoreOmocode ? this.normalized() : this;
        CodiceFiscale that = ignoreOmocode ? other.normalized() : other;
        return Objects.equals(self.getValue(), that.getValue());
    }

    public CodiceFiscale toOmocodeLevel(int level) {
        Validate.inclusiveBetween((Object)0, (Object)7, (Comparable)Integer.valueOf(level), (String)"invalid omocode level: 0 <= %s <= 7", (Object[])new Object[]{level});
        DatePart datePart = this.getDate().toOmocodeLevel(Math.max(0, level - 3));
        BelfiorePart belfiorePart = this.getBelfiore().toOmocodeLevel(Math.min(3, level));
        return this.getOmocodeLevel() == level ? this : new CodiceFiscale(this.getPerson(), this.getLastname(), this.getFirstname(), datePart, belfiorePart, level);
    }

    public boolean isOmocode() {
        return this.getOmocodeLevel() > 0;
    }

    public boolean isCompatible(Person person) {
        return this.isEqual(CodiceFiscale.of(person));
    }

    private String computeValue() {
        String value = this.getUncheckedValue() + this.getControl().getValue();
        return CodiceFiscale.validate(value);
    }

    private String computeUncheckedValue() {
        return this.getLastname().getValue() + this.getFirstname().getValue() + this.getDate().getValue() + this.getBelfiore().getValue();
    }

    private ControlPart computeControl() {
        return ControlPart.of(this.getUncheckedValue());
    }

    public static CodiceFiscale of(String code) {
        return CodiceFiscale.of(code, CityProvider.ofDefault());
    }

    public static CodiceFiscale of(Person person) {
        NamePart firstname = NamePart.of(person.getFirstname());
        LastnamePart lastname = LastnamePart.of(person.getLastname());
        DatePart date = DatePart.of(person.getBirthDate(), person.isFemale());
        BelfiorePart belfiore = BelfiorePart.of(person.getCity());
        return new CodiceFiscale(person, lastname, firstname, date, belfiore, 0);
    }

    public static CodiceFiscale of(String value, CityByBelfiore provider) {
        CodiceFiscale.validate(value);
        LastnamePart lastname = LastnamePart.from(value.substring(0, 3));
        NamePart firstname = NamePart.from(value.substring(3, 6));
        DatePart date = DatePart.from(value.substring(6, 11));
        BelfiorePart belfiore = BelfiorePart.from(value.substring(11, 15), provider);
        Person person = Person.builder().firstname(firstname.getName()).lastname(lastname.getName()).birthDate(date.getDate()).isFemale(date.isFemale()).city(belfiore.getCity()).build();
        CodiceFiscale result = new CodiceFiscale(person, lastname, firstname, date, belfiore, OmocodeUtils.level(value));
        return result;
    }

    public static boolean isCompatible(String code, Person person) {
        return CodiceFiscale.of(code).isCompatible(person);
    }

    public static boolean isFormatValid(String value) {
        if (Pattern.matches(VALIDATION_PATTERN, value)) {
            ControlPart control = ControlPart.of(value.substring(0, 15));
            char currentControl = value.charAt(15);
            return control.isEqual(currentControl);
        }
        return false;
    }

    public static String validate(String value) {
        Validate.matchesPattern((CharSequence)value, (String)VALIDATION_PATTERN, (String)"invalid value: %s", (Object[])new Object[]{value});
        ControlPart control = ControlPart.of(value.substring(0, 15));
        char currentControl = value.charAt(15);
        Validate.isTrue((boolean)control.isEqual(currentControl), (String)"invalid control char: expected %s, but found %s", (Object[])new Object[]{control.getValue(), Character.valueOf(currentControl)});
        return value;
    }

    @Generated
    public Person getPerson() {
        return this.person;
    }

    @Generated
    public LastnamePart getLastname() {
        return this.lastname;
    }

    @Generated
    public NamePart getFirstname() {
        return this.firstname;
    }

    @Generated
    public DatePart getDate() {
        return this.date;
    }

    @Generated
    public BelfiorePart getBelfiore() {
        return this.belfiore;
    }

    @Generated
    public int getOmocodeLevel() {
        return this.omocodeLevel;
    }

    @Generated
    public String toString() {
        return "CodiceFiscale(person=" + this.getPerson() + ", lastname=" + this.getLastname() + ", firstname=" + this.getFirstname() + ", date=" + this.getDate() + ", belfiore=" + this.getBelfiore() + ", control=" + this.getControl() + ", omocodeLevel=" + this.getOmocodeLevel() + ", value=" + this.getValue() + ", uncheckedValue=" + this.getUncheckedValue() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CodiceFiscale)) {
            return false;
        }
        CodiceFiscale other = (CodiceFiscale)o;
        Person this$person = this.getPerson();
        Person other$person = other.getPerson();
        if (this$person == null ? other$person != null : !((Object)this$person).equals(other$person)) {
            return false;
        }
        LastnamePart this$lastname = this.getLastname();
        LastnamePart other$lastname = other.getLastname();
        if (this$lastname == null ? other$lastname != null : !((Object)this$lastname).equals(other$lastname)) {
            return false;
        }
        NamePart this$firstname = this.getFirstname();
        NamePart other$firstname = other.getFirstname();
        if (this$firstname == null ? other$firstname != null : !((Object)this$firstname).equals(other$firstname)) {
            return false;
        }
        DatePart this$date = this.getDate();
        DatePart other$date = other.getDate();
        if (this$date == null ? other$date != null : !((Object)this$date).equals(other$date)) {
            return false;
        }
        BelfiorePart this$belfiore = this.getBelfiore();
        BelfiorePart other$belfiore = other.getBelfiore();
        if (this$belfiore == null ? other$belfiore != null : !((Object)this$belfiore).equals(other$belfiore)) {
            return false;
        }
        ControlPart this$control = this.getControl();
        ControlPart other$control = other.getControl();
        if (this$control == null ? other$control != null : !((Object)this$control).equals(other$control)) {
            return false;
        }
        if (this.getOmocodeLevel() != other.getOmocodeLevel()) {
            return false;
        }
        String this$value = this.getValue();
        String other$value = other.getValue();
        if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
            return false;
        }
        String this$uncheckedValue = this.getUncheckedValue();
        String other$uncheckedValue = other.getUncheckedValue();
        return !(this$uncheckedValue == null ? other$uncheckedValue != null : !this$uncheckedValue.equals(other$uncheckedValue));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Person $person = this.getPerson();
        result = result * 59 + ($person == null ? 43 : ((Object)$person).hashCode());
        LastnamePart $lastname = this.getLastname();
        result = result * 59 + ($lastname == null ? 43 : ((Object)$lastname).hashCode());
        NamePart $firstname = this.getFirstname();
        result = result * 59 + ($firstname == null ? 43 : ((Object)$firstname).hashCode());
        DatePart $date = this.getDate();
        result = result * 59 + ($date == null ? 43 : ((Object)$date).hashCode());
        BelfiorePart $belfiore = this.getBelfiore();
        result = result * 59 + ($belfiore == null ? 43 : ((Object)$belfiore).hashCode());
        ControlPart $control = this.getControl();
        result = result * 59 + ($control == null ? 43 : ((Object)$control).hashCode());
        result = result * 59 + this.getOmocodeLevel();
        String $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        String $uncheckedValue = this.getUncheckedValue();
        result = result * 59 + ($uncheckedValue == null ? 43 : $uncheckedValue.hashCode());
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Generated
    public ControlPart getControl() {
        Object value = this.control.get();
        if (value == null) {
            AtomicReference<Object> atomicReference = this.control;
            synchronized (atomicReference) {
                value = this.control.get();
                if (value == null) {
                    ControlPart actualValue = this.computeControl();
                    value = actualValue == null ? this.control : actualValue;
                    this.control.set(value);
                }
            }
        }
        return (ControlPart)(value == this.control ? null : value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Generated
    public String getValue() {
        Object value = this.value.get();
        if (value == null) {
            AtomicReference<Object> atomicReference = this.value;
            synchronized (atomicReference) {
                value = this.value.get();
                if (value == null) {
                    String actualValue = this.computeValue();
                    value = actualValue == null ? this.value : actualValue;
                    this.value.set(value);
                }
            }
        }
        return (String)(value == this.value ? null : value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Generated
    private String getUncheckedValue() {
        Object value = this.uncheckedValue.get();
        if (value == null) {
            AtomicReference<Object> atomicReference = this.uncheckedValue;
            synchronized (atomicReference) {
                value = this.uncheckedValue.get();
                if (value == null) {
                    String actualValue = this.computeUncheckedValue();
                    value = actualValue == null ? this.uncheckedValue : actualValue;
                    this.uncheckedValue.set(value);
                }
            }
        }
        return (String)(value == this.uncheckedValue ? null : value);
    }
}

