/*
 * Decompiled with CFR 0.152.
 */
package com.github.dozermapper.springboot.autoconfigure;

import com.github.dozermapper.core.Mapper;
import com.github.dozermapper.spring.DozerBeanMapperFactoryBean;
import com.github.dozermapper.springboot.autoconfigure.DozerProperties;
import java.io.IOException;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(value={DozerBeanMapperFactoryBean.class, Mapper.class})
@ConditionalOnMissingBean(value={Mapper.class})
@EnableConfigurationProperties(value={DozerProperties.class})
public class DozerAutoConfiguration {
    private final DozerProperties properties;

    public DozerAutoConfiguration(DozerProperties properties) {
        this.properties = properties;
    }

    @Bean
    public DozerBeanMapperFactoryBean dozerMapper() throws IOException {
        DozerBeanMapperFactoryBean factoryBean = new DozerBeanMapperFactoryBean();
        factoryBean.setMappingFiles(this.properties.getMappingFiles());
        return factoryBean;
    }
}

