/*
 * Decompiled with CFR 0.152.
 */
package org.dozer.schema;

import java.net.URL;
import org.dozer.schema.SchemaResolver;
import org.dozer.schema.osgi.Activator;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSchemaResolver
implements SchemaResolver {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultSchemaResolver.class);

    @Override
    public URL get(String fileName) {
        LOG.debug("Trying {} class loader for schema/{}", (Object)this.getClass().getCanonicalName(), (Object)fileName);
        URL answer = this.getClass().getClassLoader().getResource("schema/" + fileName);
        if (answer == null) {
            LOG.debug("Trying OSGi bundle context for schema/{}", (Object)fileName);
            Bundle bundle = Activator.getBundle();
            if (bundle != null) {
                answer = bundle.getResource("schema/" + fileName);
            }
        }
        return answer;
    }
}

