/*
 * Decompiled with CFR 0.152.
 */
package com.github.dozermapper.core.loader.api;

import com.github.dozermapper.core.classmap.MappingFileData;
import com.github.dozermapper.core.config.BeanContainer;
import com.github.dozermapper.core.factory.DestBeanCreator;
import com.github.dozermapper.core.loader.DozerBuilder;
import com.github.dozermapper.core.loader.api.FieldDefinition;
import com.github.dozermapper.core.loader.api.TypeDefinition;
import com.github.dozermapper.core.loader.api.TypeMappingBuilder;
import com.github.dozermapper.core.loader.api.TypeMappingOption;
import com.github.dozermapper.core.propertydescriptor.PropertyDescriptorFactory;

public abstract class BeanMappingBuilder {
    private DozerBuilder dozerBuilder;

    public MappingFileData build(BeanContainer beanContainer, DestBeanCreator destBeanCreator, PropertyDescriptorFactory propertyDescriptorFactory) {
        this.dozerBuilder = new DozerBuilder(beanContainer, destBeanCreator, propertyDescriptorFactory);
        this.configure();
        return this.dozerBuilder.build();
    }

    public TypeMappingBuilder mapping(String typeA, String typeB, TypeMappingOption ... typeMappingOption) {
        return this.mapping(new TypeDefinition(typeA), new TypeDefinition(typeB), typeMappingOption);
    }

    public TypeMappingBuilder mapping(TypeDefinition typeA, String typeB, TypeMappingOption ... typeMappingOption) {
        return this.mapping(typeA, new TypeDefinition(typeB), typeMappingOption);
    }

    public TypeMappingBuilder mapping(String typeA, TypeDefinition typeB, TypeMappingOption ... typeMappingOption) {
        return this.mapping(new TypeDefinition(typeA), typeB, typeMappingOption);
    }

    public TypeMappingBuilder mapping(Class<?> typeA, Class<?> typeB, TypeMappingOption ... typeMappingOption) {
        return this.mapping(new TypeDefinition(typeA), new TypeDefinition(typeB), typeMappingOption);
    }

    public TypeMappingBuilder mapping(TypeDefinition typeA, Class<?> typeB, TypeMappingOption ... typeMappingOption) {
        return this.mapping(typeA, new TypeDefinition(typeB), typeMappingOption);
    }

    public TypeMappingBuilder mapping(Class<?> typeA, TypeDefinition typeB, TypeMappingOption ... typeMappingOption) {
        return this.mapping(new TypeDefinition(typeA), typeB, typeMappingOption);
    }

    public TypeMappingBuilder mapping(TypeDefinition typeA, TypeDefinition typeB, TypeMappingOption ... typeMappingOption) {
        DozerBuilder.MappingBuilder mappingBuilder = this.dozerBuilder.mapping();
        DozerBuilder.ClassDefinitionBuilder typeBuilderA = mappingBuilder.classA(typeA.getName());
        DozerBuilder.ClassDefinitionBuilder typeBuilderB = mappingBuilder.classB(typeB.getName());
        typeA.build(typeBuilderA);
        typeB.build(typeBuilderB);
        for (TypeMappingOption option : typeMappingOption) {
            option.apply(mappingBuilder);
        }
        return new TypeMappingBuilder(mappingBuilder);
    }

    public TypeDefinition type(String name) {
        return new TypeDefinition(name);
    }

    public TypeDefinition type(Class<?> type) {
        return new TypeDefinition(type);
    }

    public FieldDefinition field(String name) {
        return new FieldDefinition(name);
    }

    public FieldDefinition this_() {
        return new FieldDefinition("this");
    }

    protected abstract void configure();
}

