/*
 * Decompiled with CFR 0.152.
 */
package com.github.dozermapper.core.converters;

import com.github.dozermapper.core.converters.ConversionException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import org.apache.commons.beanutils.Converter;

public abstract class AbstractJava8DateTimeConverter
implements Converter {
    private final DateTimeFormatter formatter;

    AbstractJava8DateTimeConverter(DateTimeFormatter formatter) {
        this.formatter = formatter;
    }

    public Object convert(Class destClass, Object srcObject) {
        Class<?> srcObjectClass = srcObject.getClass();
        try {
            if (TemporalAccessor.class.isAssignableFrom(srcObjectClass)) {
                Method method = destClass.getDeclaredMethod("from", TemporalAccessor.class);
                return method.invoke(null, (TemporalAccessor)srcObject);
            }
            if (String.class.isAssignableFrom(srcObjectClass) && this.formatter != null) {
                Method method = destClass.getDeclaredMethod("parse", CharSequence.class, DateTimeFormatter.class);
                return method.invoke(null, srcObject, this.formatter);
            }
            throw new ConversionException(String.format("Unsupported source object type: %s", srcObjectClass), null);
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            throw new ConversionException(String.format("Failed to create %s from %s", destClass.getSimpleName(), srcObject.getClass().getSimpleName()), e);
        }
        catch (InvocationTargetException e) {
            throw new ConversionException(String.format("Failed to create %s from %s", destClass.getSimpleName(), srcObject.getClass().getSimpleName()), e.getTargetException());
        }
    }
}

