/*
 * Decompiled with CFR 0.152.
 */
package com.github.dozermapper.core.loader;

import com.github.dozermapper.core.CustomConverter;
import com.github.dozermapper.core.MappingException;
import com.github.dozermapper.core.classmap.ClassMap;
import com.github.dozermapper.core.classmap.Configuration;
import com.github.dozermapper.core.classmap.CopyByReference;
import com.github.dozermapper.core.classmap.DozerClass;
import com.github.dozermapper.core.classmap.MappingDirection;
import com.github.dozermapper.core.classmap.MappingFileData;
import com.github.dozermapper.core.classmap.RelationshipType;
import com.github.dozermapper.core.config.BeanContainer;
import com.github.dozermapper.core.converters.CustomConverterDescription;
import com.github.dozermapper.core.factory.DestBeanCreator;
import com.github.dozermapper.core.fieldmap.CustomGetSetMethodFieldMap;
import com.github.dozermapper.core.fieldmap.DozerField;
import com.github.dozermapper.core.fieldmap.ExcludeFieldMap;
import com.github.dozermapper.core.fieldmap.FieldMap;
import com.github.dozermapper.core.fieldmap.GenericFieldMap;
import com.github.dozermapper.core.fieldmap.HintContainer;
import com.github.dozermapper.core.fieldmap.MapFieldMap;
import com.github.dozermapper.core.propertydescriptor.PropertyDescriptorFactory;
import com.github.dozermapper.core.util.DozerConstants;
import com.github.dozermapper.core.util.MappingUtils;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class DozerBuilder {
    MappingFileData data = new MappingFileData();
    private final List<MappingBuilder> mappingBuilders = new ArrayList<MappingBuilder>();
    private final BeanContainer beanContainer;
    private final DestBeanCreator destBeanCreator;
    private final PropertyDescriptorFactory propertyDescriptorFactory;

    public DozerBuilder(BeanContainer beanContainer, DestBeanCreator destBeanCreator, PropertyDescriptorFactory propertyDescriptorFactory) {
        this.beanContainer = beanContainer;
        this.destBeanCreator = destBeanCreator;
        this.propertyDescriptorFactory = propertyDescriptorFactory;
    }

    public MappingFileData build() {
        for (MappingBuilder builder : this.mappingBuilders) {
            builder.build();
        }
        return this.data;
    }

    public ConfigurationBuilder configuration() {
        Configuration configuration = new Configuration();
        this.data.setConfiguration(configuration);
        return new ConfigurationBuilder(configuration, this.beanContainer);
    }

    public MappingBuilder mapping() {
        Configuration configuration = this.data.getConfiguration();
        ClassMap classMap = new ClassMap(configuration);
        this.data.getClassMaps().add(classMap);
        MappingBuilder mappingDefinitionBuilder = new MappingBuilder(classMap, this.beanContainer, this.destBeanCreator, this.propertyDescriptorFactory);
        this.mappingBuilders.add(mappingDefinitionBuilder);
        return mappingDefinitionBuilder;
    }

    private static DozerField prepareField(String name, String type) {
        if (MappingUtils.isBlankOrNull(name)) {
            throw new MappingException("Field name can not be empty");
        }
        String fieldType = null;
        String fieldName = DozerBuilder.isIndexed(name) ? DozerBuilder.getFieldNameOfIndexedField(name) : name;
        if (StringUtils.isNotEmpty((CharSequence)type)) {
            fieldType = type;
        }
        DozerField field = new DozerField(fieldName, fieldType);
        if (DozerBuilder.isIndexed(name)) {
            field.setIndexed(true);
            field.setIndex(DozerBuilder.getIndexOfIndexedField(name));
        }
        return field;
    }

    private static boolean isIndexed(String fieldName) {
        return fieldName != null && fieldName.matches(".+\\[\\d+\\]");
    }

    static String getFieldNameOfIndexedField(String fieldName) {
        return fieldName == null ? null : fieldName.replaceAll("\\[\\d+\\]$", "");
    }

    private static int getIndexOfIndexedField(String fieldName) {
        return Integer.parseInt(fieldName.replaceAll(".*\\[", "").replaceAll("\\]", ""));
    }

    public static class CustomConverterBuilder {
        private CustomConverterDescription converterDescription;
        private final BeanContainer beanContainer;

        public CustomConverterBuilder(CustomConverterDescription converterDescription, BeanContainer beanContainer) {
            this.converterDescription = converterDescription;
            this.beanContainer = beanContainer;
        }

        public CustomConverterBuilder classA(String type) {
            Class<?> aClass = MappingUtils.loadClass(type, this.beanContainer);
            return this.classA(aClass);
        }

        public CustomConverterBuilder classA(Class type) {
            this.converterDescription.setClassA(type);
            return this;
        }

        public CustomConverterBuilder classB(String type) {
            Class<?> aClass = MappingUtils.loadClass(type, this.beanContainer);
            return this.classB(aClass);
        }

        public CustomConverterBuilder classB(Class type) {
            this.converterDescription.setClassB(type);
            return this;
        }
    }

    public static class ConfigurationBuilder {
        private Configuration configuration;
        private CustomConverterDescription converterDescription;
        private final BeanContainer beanContainer;

        public ConfigurationBuilder(Configuration configuration, BeanContainer beanContainer) {
            this.configuration = configuration;
            this.beanContainer = beanContainer;
        }

        public void stopOnErrors(Boolean value) {
            this.configuration.setStopOnErrors(value);
        }

        public void dateFormat(String format) {
            this.configuration.setDateFormat(format);
        }

        public void wildcard(Boolean value) {
            this.configuration.setWildcard(value);
        }

        public void wildcardCaseInsensitive(Boolean value) {
            this.configuration.setWildcardCaseInsensitive(value);
        }

        public void trimStrings(Boolean value) {
            this.configuration.setTrimStrings(value);
        }

        public void mapNull(Boolean value) {
            this.configuration.setMapNull(value);
        }

        public void mapEmptyString(Boolean value) {
            this.configuration.setMapEmptyString(value);
        }

        public void relationshipType(RelationshipType value) {
            if (value == null) {
                this.configuration.setRelationshipType(DozerConstants.DEFAULT_RELATIONSHIP_TYPE_POLICY);
            } else {
                this.configuration.setRelationshipType(value);
            }
        }

        public void beanFactory(String name) {
            this.configuration.setBeanFactory(name);
        }

        public CustomConverterBuilder customConverter(String type) {
            Class<?> aClass = MappingUtils.loadClass(type, this.beanContainer);
            return this.customConverter(aClass);
        }

        public CustomConverterBuilder customConverter(Class type) {
            this.converterDescription = new CustomConverterDescription();
            this.converterDescription.setType(type);
            this.configuration.getCustomConverters().addConverter(this.converterDescription);
            return new CustomConverterBuilder(this.converterDescription, this.beanContainer);
        }

        public ConfigurationBuilder copyByReference(String typeMask) {
            CopyByReference copyByReference = new CopyByReference(typeMask);
            this.configuration.getCopyByReferences().add(copyByReference);
            return this;
        }

        public ConfigurationBuilder allowedException(String type) {
            Class<?> exceptionType = MappingUtils.loadClass(type, this.beanContainer);
            return this.allowedException(exceptionType);
        }

        public ConfigurationBuilder allowedException(Class type) {
            if (!RuntimeException.class.isAssignableFrom(type)) {
                MappingUtils.throwMappingException("allowed-exception Type must extend java.lang.RuntimeException: " + type.getName());
            }
            this.configuration.getAllowedExceptions().getExceptions().add(type);
            return this;
        }
    }

    public static class ClassDefinitionBuilder {
        private DozerClass definition;

        public ClassDefinitionBuilder(DozerClass definition) {
            this.definition = definition;
        }

        public void mapGetMethod(String name) {
            this.definition.setMapGetMethod(name);
        }

        public void mapSetMethod(String name) {
            this.definition.setMapSetMethod(name);
        }

        public void beanFactory(String beanFactory) {
            this.definition.setBeanFactory(beanFactory);
        }

        public void factoryBeanId(String id) {
            this.definition.setFactoryBeanId(id);
        }

        public void createMethod(String name) {
            this.definition.setCreateMethod(name);
        }

        public void mapNull(Boolean value) {
            this.definition.setMapNull(value);
        }

        public void mapEmptyString(Boolean value) {
            this.definition.setMapEmptyString(value);
        }

        public void isAccessible(Boolean value) {
            this.definition.setAccessible(value);
        }

        public void skipConstructor(Boolean skipConstructor) {
            this.definition.setSkipConstructor(skipConstructor);
        }
    }

    public static class FieldDefinitionBuilder {
        private DozerField field;

        public FieldDefinitionBuilder(DozerField field) {
            this.field = field;
        }

        public void dateFormat(String attribute) {
            this.field.setDateFormat(attribute);
        }

        public void theGetMethod(String attribute) {
            this.field.setTheGetMethod(attribute);
        }

        public void theSetMethod(String attribute) {
            this.field.setTheSetMethod(attribute);
        }

        public void mapGetMethod(String attribute) {
            this.field.setMapGetMethod(attribute);
        }

        public void mapSetMethod(String attribute) {
            this.field.setMapSetMethod(attribute);
        }

        public void key(String attribute) {
            this.field.setKey(attribute);
        }

        public void createMethod(String attribute) {
            this.field.setCreateMethod(attribute);
        }

        public void accessible(Boolean b) {
            this.field.setAccessible(b);
        }

        public void iterate() {
            this.field.setType("iterate");
        }

        public DozerField build() {
            return this.field;
        }
    }

    public static class FieldMappingBuilder
    implements FieldBuider {
        private ClassMap classMap;
        private DozerField srcField;
        private DozerField destField;
        private MappingDirection type;
        private RelationshipType relationshipType;
        private boolean removeOrphans;
        private HintContainer srcHintContainer;
        private HintContainer destHintContainer;
        private HintContainer srcDeepIndexHintContainer;
        private HintContainer destDeepIndexHintContainer;
        private boolean copyByReference;
        private String mapId;
        private String customConverter;
        private String customConverterId;
        private String customConverterParam;
        private boolean copyByReferenceSet;
        private final BeanContainer beanContainer;
        private final DestBeanCreator destBeanCreator;
        private final PropertyDescriptorFactory propertyDescriptorFactory;

        public FieldMappingBuilder(ClassMap classMap, BeanContainer beanContainer, DestBeanCreator destBeanCreator, PropertyDescriptorFactory propertyDescriptorFactory) {
            this.classMap = classMap;
            this.beanContainer = beanContainer;
            this.destBeanCreator = destBeanCreator;
            this.propertyDescriptorFactory = propertyDescriptorFactory;
        }

        public FieldDefinitionBuilder a(String name) {
            return this.a(name, null);
        }

        @Override
        public FieldDefinitionBuilder a(String name, String type) {
            DozerField field;
            this.srcField = field = DozerBuilder.prepareField(name, type);
            return new FieldDefinitionBuilder(field);
        }

        public FieldDefinitionBuilder b(String name) {
            return this.b(name, null);
        }

        @Override
        public FieldDefinitionBuilder b(String name, String type) {
            DozerField field;
            this.destField = field = DozerBuilder.prepareField(name, type);
            return new FieldDefinitionBuilder(field);
        }

        public void type(MappingDirection type) {
            this.type = type;
        }

        public void relationshipType(RelationshipType relationshipType) {
            this.relationshipType = relationshipType;
        }

        public void removeOrphans(boolean value) {
            this.removeOrphans = value;
        }

        public void srcHintContainer(String hint) {
            HintContainer hintContainer = new HintContainer(this.beanContainer);
            hintContainer.setHintName(hint);
            this.srcHintContainer = hintContainer;
        }

        public void destHintContainer(String hint) {
            HintContainer hintContainer = new HintContainer(this.beanContainer);
            hintContainer.setHintName(hint);
            this.destHintContainer = hintContainer;
        }

        public void srcDeepIndexHintContainer(String hint) {
            HintContainer hintContainer = new HintContainer(this.beanContainer);
            hintContainer.setHintName(hint);
            this.srcDeepIndexHintContainer = hintContainer;
        }

        public void destDeepIndexHintContainer(String hint) {
            HintContainer hintContainer = new HintContainer(this.beanContainer);
            hintContainer.setHintName(hint);
            this.destDeepIndexHintContainer = hintContainer;
        }

        public void copyByReference(boolean value) {
            this.copyByReferenceSet = true;
            this.copyByReference = value;
        }

        public void mapId(String attribute) {
            this.mapId = attribute;
        }

        public void customConverter(Class<? extends CustomConverter> type) {
            this.customConverter(type.getName());
        }

        public void customConverter(String typeName) {
            this.customConverter = typeName;
        }

        public void customConverterId(String attribute) {
            this.customConverterId = attribute;
        }

        public void customConverterParam(String attribute) {
            this.customConverterParam = attribute;
        }

        @Override
        public void build() {
            FieldMap result = this.srcField.isMapTypeCustomGetterSetterField() || this.destField.isMapTypeCustomGetterSetterField() || this.classMap.isSrcClassMapTypeCustomGetterSetter() || this.classMap.isDestClassMapTypeCustomGetterSetter() ? new MapFieldMap(this.classMap, this.beanContainer, this.destBeanCreator, this.propertyDescriptorFactory) : (this.srcField.isCustomGetterSetterField() || this.destField.isCustomGetterSetterField() ? new CustomGetSetMethodFieldMap(this.classMap, this.beanContainer, this.destBeanCreator, this.propertyDescriptorFactory) : new GenericFieldMap(this.classMap, this.beanContainer, this.destBeanCreator, this.propertyDescriptorFactory));
            result.setSrcField(this.srcField);
            result.setDestField(this.destField);
            result.setType(this.type);
            result.setRelationshipType(this.relationshipType);
            result.setRemoveOrphans(this.removeOrphans);
            result.setSrcHintContainer(this.srcHintContainer);
            result.setDestHintContainer(this.destHintContainer);
            result.setSrcDeepIndexHintContainer(this.srcDeepIndexHintContainer);
            result.setDestDeepIndexHintContainer(this.destDeepIndexHintContainer);
            if (this.copyByReferenceSet) {
                result.setCopyByReference(this.copyByReference);
            }
            result.setMapId(this.mapId);
            result.setCustomConverter(this.customConverter);
            result.setCustomConverterId(this.customConverterId);
            result.setCustomConverterParam(this.customConverterParam);
            this.classMap.addFieldMapping(result);
        }
    }

    public static class FieldExclusionBuilder
    implements FieldBuider {
        private ExcludeFieldMap fieldMap;

        public FieldExclusionBuilder(ExcludeFieldMap fieldMap) {
            this.fieldMap = fieldMap;
        }

        public void type(MappingDirection type) {
            this.fieldMap.setType(type);
        }

        @Override
        public FieldDefinitionBuilder a(String name, String type) {
            DozerField field = DozerBuilder.prepareField(name, type);
            this.fieldMap.setSrcField(field);
            return new FieldDefinitionBuilder(field);
        }

        @Override
        public FieldDefinitionBuilder b(String name, String type) {
            DozerField field = DozerBuilder.prepareField(name, type);
            this.fieldMap.setDestField(field);
            return new FieldDefinitionBuilder(field);
        }

        @Override
        public void build() {
            ClassMap classMap = this.fieldMap.getClassMap();
            classMap.addFieldMapping(this.fieldMap);
        }
    }

    public static interface FieldBuider {
        public FieldDefinitionBuilder a(String var1, String var2);

        public FieldDefinitionBuilder b(String var1, String var2);

        public void build();
    }

    public static class MappingBuilder {
        private ClassMap classMap;
        private final List<FieldBuider> fieldBuilders = new ArrayList<FieldBuider>();
        private final BeanContainer beanContainer;
        private final DestBeanCreator destBeanCreator;
        private final PropertyDescriptorFactory propertyDescriptorFactory;

        public MappingBuilder(ClassMap classMap, BeanContainer beanContainer, DestBeanCreator destBeanCreator, PropertyDescriptorFactory propertyDescriptorFactory) {
            this.classMap = classMap;
            this.beanContainer = beanContainer;
            this.destBeanCreator = destBeanCreator;
            this.propertyDescriptorFactory = propertyDescriptorFactory;
        }

        public MappingBuilder dateFormat(String dateFormat) {
            this.classMap.setDateFormat(dateFormat);
            return this;
        }

        public MappingBuilder mapNull(boolean value) {
            this.classMap.setMapNull(value);
            return this;
        }

        public MappingBuilder mapEmptyString(boolean value) {
            this.classMap.setMapEmptyString(value);
            return this;
        }

        public MappingBuilder beanFactory(String typeName) {
            this.classMap.setBeanFactory(typeName);
            return this;
        }

        public MappingBuilder relationshipType(RelationshipType type) {
            this.classMap.setRelationshipType(type);
            return this;
        }

        public MappingBuilder wildcard(Boolean value) {
            this.classMap.setWildcard(value);
            return this;
        }

        public MappingBuilder wildcardCaseInsensitive(Boolean value) {
            this.classMap.setWildcardCaseInsensitive(value);
            return this;
        }

        public MappingBuilder trimStrings(Boolean value) {
            this.classMap.setTrimStrings(value);
            return this;
        }

        public MappingBuilder stopOnErrors(Boolean value) {
            this.classMap.setStopOnErrors(value);
            return this;
        }

        public MappingBuilder mapId(String id) {
            this.classMap.setMapId(id);
            return this;
        }

        public MappingBuilder type(MappingDirection type) {
            this.classMap.setType(type);
            return this;
        }

        public ClassDefinitionBuilder classA(String typeName) {
            Class<?> type = MappingUtils.loadClass(typeName, this.beanContainer);
            return this.classA(type);
        }

        public ClassDefinitionBuilder classA(Class type) {
            DozerClass classDefinition = new DozerClass(this.beanContainer);
            classDefinition.setName(type.getName());
            this.classMap.setSrcClass(classDefinition);
            return new ClassDefinitionBuilder(classDefinition);
        }

        public ClassDefinitionBuilder classB(String typeName) {
            Class<?> type = MappingUtils.loadClass(typeName, this.beanContainer);
            return this.classB(type);
        }

        public ClassDefinitionBuilder classB(Class type) {
            DozerClass classDefinition = new DozerClass(this.beanContainer);
            classDefinition.setName(type.getName());
            this.classMap.setDestClass(classDefinition);
            return new ClassDefinitionBuilder(classDefinition);
        }

        public FieldExclusionBuilder fieldExclude() {
            ExcludeFieldMap excludeFieldMap = new ExcludeFieldMap(this.classMap, this.beanContainer, this.destBeanCreator, this.propertyDescriptorFactory);
            FieldExclusionBuilder builder = new FieldExclusionBuilder(excludeFieldMap);
            this.fieldBuilders.add(builder);
            return builder;
        }

        public FieldMappingBuilder field() {
            FieldMappingBuilder builder = new FieldMappingBuilder(this.classMap, this.beanContainer, this.destBeanCreator, this.propertyDescriptorFactory);
            this.fieldBuilders.add(builder);
            return builder;
        }

        public void build() {
            for (FieldBuider builder : this.fieldBuilders) {
                builder.build();
            }
        }
    }
}

