/*
 * Decompiled with CFR 0.152.
 */
package org.dozer.config.resolvers;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.dozer.config.resolvers.SettingsResolver;
import org.dozer.util.DozerClassLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YAMLSettingsResolver
implements SettingsResolver {
    private static final Logger LOG = LoggerFactory.getLogger(YAMLSettingsResolver.class);
    private static final String ROOT_PARENT = "dozer";
    private static final String CACHE_PARENT = "cache";
    private static final String BEANS_PARENT = "beans";
    private static final String ENABLED_PROPERTY = "enabled";
    private static final String CONVERTER_BY_DEST_TYPE_CACHE_MAX_SIZE_PROPERTY = "converter-by-dest-type-maxsize";
    private static final String SUPER_TYPE_CHECK_CACHE_MAX_SIZE_PROPERTY = "super-type-maxsize";
    private static final String CLASS_LOADER_BEAN_PROPERTY = "class-loader-bean";
    private static final String PROXY_RESOLVER_BEAN_PROPERTY = "proxy-resolver";
    private final DozerClassLoader classLoader;
    private final String configFile;
    private Map<String, Object> properties = new HashMap<String, Object>();

    public YAMLSettingsResolver(DozerClassLoader classLoader, String configFile) {
        this.classLoader = classLoader;
        this.configFile = configFile;
    }

    @Override
    public void init() {
        Map<String, Map> settings = this.processFile();
        this.processSettingsMap(settings);
    }

    private Map<String, Map> processFile() {
        Map answer = new HashMap<String, Map>();
        String extension = FilenameUtils.getExtension((String)this.configFile);
        if (!extension.equalsIgnoreCase("yaml") && !extension.equalsIgnoreCase("yml")) {
            LOG.info("Ignoring, as file extension is not correct for: {}", (Object)this.configFile);
        } else {
            LOG.info("Trying to find Dozer configuration file: {}", (Object)this.configFile);
            URL url = this.classLoader.loadResource(this.configFile);
            if (url == null) {
                LOG.info("Failed to find {} via {}.", (Object)this.configFile, (Object)this.getClass().getName());
            } else {
                LOG.info("Using URL [{}] for Dozer settings", (Object)url);
                try (InputStream inputStream = url.openStream();){
                    ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory());
                    answer = (Map)mapper.readValue(inputStream, Map.class);
                }
                catch (IOException ex) {
                    LOG.error("Failed to load: {} because: {}", (Object)this.configFile, (Object)ex.getMessage());
                    LOG.debug("Exception: ", (Throwable)ex);
                }
            }
        }
        return answer;
    }

    private void processSettingsMap(Map<String, Map> settings) {
        if (settings.containsKey(ROOT_PARENT)) {
            Map root = settings.get(ROOT_PARENT);
            if (root.containsKey(CACHE_PARENT)) {
                Map cache = (Map)root.get(CACHE_PARENT);
                if (cache.containsKey(CONVERTER_BY_DEST_TYPE_CACHE_MAX_SIZE_PROPERTY)) {
                    this.properties.put("dozer.cache.converter-by-dest-type-maxsize", cache.get(CONVERTER_BY_DEST_TYPE_CACHE_MAX_SIZE_PROPERTY));
                }
                if (cache.containsKey(SUPER_TYPE_CHECK_CACHE_MAX_SIZE_PROPERTY)) {
                    this.properties.put("dozer.cache.super-type-maxsize", cache.get(SUPER_TYPE_CHECK_CACHE_MAX_SIZE_PROPERTY));
                }
            }
            if (root.containsKey(BEANS_PARENT)) {
                Map classes = (Map)root.get(BEANS_PARENT);
                if (classes.containsKey(CLASS_LOADER_BEAN_PROPERTY)) {
                    this.properties.put("dozer.beans.class-loader-bean", classes.get(CLASS_LOADER_BEAN_PROPERTY));
                }
                if (classes.containsKey(PROXY_RESOLVER_BEAN_PROPERTY)) {
                    this.properties.put("dozer.beans.proxy-resolver-bean", classes.get(PROXY_RESOLVER_BEAN_PROPERTY));
                }
            }
        }
    }

    @Override
    public Object get(String key, Object defaultValue) {
        return this.properties.getOrDefault(key, defaultValue);
    }
}

