/*
 * Decompiled with CFR 0.152.
 */
package org.dozer.builder.xml;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.Charset;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.dozer.MappingException;
import org.dozer.builder.xml.InputStreamLSInput;
import org.dozer.config.BeanContainer;
import org.dozer.osgi.Activator;
import org.dozer.util.DozerClassLoader;
import org.dozer.util.MappingUtils;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;

public class SchemaLSResourceResolver
implements LSResourceResolver {
    private static final Logger LOG = LoggerFactory.getLogger(SchemaLSResourceResolver.class);
    private static final String VERSION_5_XSD = "http://dozer.sourceforge.net/schema/beanmapping.xsd";
    private static final String VERSION_6_XSD = "https://dozermapper.github.io/schema/bean-mapping.xsd";
    private final BeanContainer beanContainer;

    public SchemaLSResourceResolver(BeanContainer beanContainer) {
        this.beanContainer = beanContainer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LSInput resolveResource(String type, String namespaceURI, String publicId, String systemId, String baseURI) {
        LOG.info("Trying to resolve XML entity with public ID [{}] and system ID [{}]", (Object)publicId, (Object)systemId);
        this.isValidSystemID(systemId);
        InputStream source = null;
        try {
            source = this.resolveFromClassPath(systemId);
        }
        catch (IOException exClasspath) {
            LOG.error("{}", (Object)exClasspath.getMessage());
            LOG.debug("Exception: {}", (Throwable)exClasspath);
            try {
                source = this.resolveFromURL(systemId);
            }
            catch (IOException exURL) {
                MappingUtils.throwMappingException(exURL);
            }
        }
        InputStreamLSInput lsInput = null;
        try {
            lsInput = new InputStreamLSInput(publicId, systemId, baseURI, new StringReader(IOUtils.toString((InputStream)source, (Charset)Charset.forName("UTF-8"))));
            LOG.info("Resolved public ID [{}] and system ID [{}]", (Object)publicId, (Object)systemId);
        }
        catch (IOException ex) {
            MappingUtils.throwMappingException("Could not resolve bean-mapping XML Schema [" + systemId + "]", ex);
        }
        finally {
            IOUtils.closeQuietly((InputStream)source);
        }
        return lsInput;
    }

    private void isValidSystemID(String systemId) throws MappingException {
        if (StringUtils.isBlank((CharSequence)systemId)) {
            MappingUtils.throwMappingException("System ID is empty. Expected: https://dozermapper.github.io/schema/bean-mapping.xsd'. Please see migration guide @ https://dozermapper.github.io/gitbook");
        }
        if (VERSION_5_XSD.equalsIgnoreCase(systemId)) {
            MappingUtils.throwMappingException("Dozer >= v6.0.0 uses a new XSD location. Your current config needs to be upgraded. Found v5 XSD: 'http://dozer.sourceforge.net/schema/beanmapping.xsd'. Expected v6 XSD: 'https://dozermapper.github.io/schema/bean-mapping.xsd'. Please see migration guide @ https://dozermapper.github.io/gitbook");
        }
    }

    private InputStream resolveFromClassPath(String systemId) throws IOException {
        InputStream source;
        Bundle bundle;
        String xsdPath = systemId.substring(systemId.indexOf("/", "http://".length()) + 1);
        ClassLoader localClassLoader = this.getClass().getClassLoader();
        LOG.debug("Trying to locate [{}] via ClassLoader [{}]", (Object)xsdPath, (Object)localClassLoader.getClass().getSimpleName());
        URL url = localClassLoader.getResource(xsdPath);
        if (url == null) {
            DozerClassLoader dozerClassLoader = this.beanContainer.getClassLoader();
            LOG.debug("Trying to locate [{}] via DozerClassLoader [{}]", (Object)xsdPath, (Object)dozerClassLoader.getClass().getSimpleName());
            url = dozerClassLoader.loadResource(xsdPath);
        }
        if (url == null && (bundle = Activator.getBundle()) != null) {
            LOG.debug("Trying to locate [{}] via Bundle [{}]", (Object)xsdPath, (Object)bundle.getClass().getSimpleName());
            url = bundle.getResource("schema/" + xsdPath);
        }
        if (url == null) {
            throw new IOException("Could not resolve bean-mapping XML Schema [" + systemId + "]: not found in classpath; " + xsdPath);
        }
        try {
            source = url.openStream();
        }
        catch (IOException ex) {
            throw new IOException("Could not resolve bean-mapping XML Schema [" + systemId + "]: not found in classpath; " + xsdPath, ex);
        }
        LOG.debug("Found bean-mapping XML Schema [{}] in classpath @ [{}]", (Object)systemId, (Object)url.toString());
        return source;
    }

    private InputStream resolveFromURL(String systemId) throws IOException {
        LOG.debug("Trying to download [{}]", (Object)systemId);
        URL obj = new URL(systemId);
        HttpURLConnection conn = (HttpURLConnection)obj.openConnection();
        int status = conn.getResponseCode();
        if (status != 200 && (status == 302 || status == 301 || status == 303)) {
            LOG.debug("Received status of {}, attempting to follow Location header", (Object)status);
            String newUrl = conn.getHeaderField("Location");
            conn = (HttpURLConnection)new URL(newUrl).openConnection();
        }
        return conn.getInputStream();
    }
}

