/*
 * Decompiled with CFR 0.152.
 */
package org.dozer.builder.xml;

import java.io.IOException;
import java.io.StringReader;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.dozer.builder.xml.JAXBModelParser;
import org.dozer.builder.xml.SchemaLSResourceResolver;
import org.dozer.config.BeanContainer;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.SAXException;

public class DefaultJAXBModelParser<T>
implements JAXBModelParser<T> {
    private static final String JAXB_CONTEXT_PACKAGES = "org.dozer.builder.model.jaxb";
    private final LSResourceResolver resourceResolver;
    private JAXBContext jaxbContext;

    public DefaultJAXBModelParser(BeanContainer beanContainer) {
        this.resourceResolver = new SchemaLSResourceResolver(beanContainer);
    }

    private JAXBContext getOrCreateJAXBContext() throws JAXBException {
        if (this.jaxbContext == null) {
            this.jaxbContext = JAXBContext.newInstance((String)JAXB_CONTEXT_PACKAGES, (ClassLoader)this.getClass().getClassLoader());
        }
        return this.jaxbContext;
    }

    private Schema newSchema() throws SAXException {
        SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        factory.setResourceResolver(this.resourceResolver);
        return factory.newSchema();
    }

    private Validator newValidator(Schema schema) {
        Validator validator = schema.newValidator();
        validator.setResourceResolver(this.resourceResolver);
        return validator;
    }

    @Override
    public void validateXML(String xmlContent) throws IOException, SAXException {
        try (StringReader stringReader = new StringReader(xmlContent);){
            StreamSource streamSource = new StreamSource(stringReader);
            Validator validator = this.newValidator(this.newSchema());
            validator.validate(streamSource);
        }
    }

    @Override
    public T readXML(String xmlContent, Class<T> type) throws IOException, SAXException {
        JAXBElement answer;
        try (StringReader stringReader = new StringReader(xmlContent);){
            StreamSource streamSource = new StreamSource(stringReader);
            JAXBContext jaxbContext = this.getOrCreateJAXBContext();
            Unmarshaller jaxbUnmarshaller = jaxbContext.createUnmarshaller();
            answer = jaxbUnmarshaller.unmarshal((Source)streamSource, type);
        }
        catch (JAXBException ex) {
            throw new SAXException((Exception)((Object)ex));
        }
        return (T)answer.getValue();
    }
}

