/*
 * Decompiled with CFR 0.152.
 */
package org.dozer;

import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.JAXBElement;
import org.apache.commons.lang3.StringUtils;
import org.dozer.BeanBuilder;
import org.dozer.ConfigurableCustomConverter;
import org.dozer.CustomConverter;
import org.dozer.CustomFieldMapper;
import org.dozer.MappedFieldsTracker;
import org.dozer.Mapper;
import org.dozer.MapperAware;
import org.dozer.MappingException;
import org.dozer.builder.BuilderUtil;
import org.dozer.builder.DestBeanBuilderCreator;
import org.dozer.cache.Cache;
import org.dozer.cache.CacheKeyFactory;
import org.dozer.cache.CacheManager;
import org.dozer.cache.DozerCacheType;
import org.dozer.classmap.ClassMap;
import org.dozer.classmap.ClassMapBuilder;
import org.dozer.classmap.ClassMappings;
import org.dozer.classmap.Configuration;
import org.dozer.classmap.CopyByReferenceContainer;
import org.dozer.classmap.MappingDirection;
import org.dozer.classmap.RelationshipType;
import org.dozer.classmap.generator.BeanMappingGenerator;
import org.dozer.config.BeanContainer;
import org.dozer.converters.DateFormatContainer;
import org.dozer.converters.PrimitiveOrWrapperConverter;
import org.dozer.event.DozerEvent;
import org.dozer.event.DozerEventManager;
import org.dozer.event.DozerEventType;
import org.dozer.event.EventManager;
import org.dozer.factory.BeanCreationDirective;
import org.dozer.factory.DestBeanCreator;
import org.dozer.fieldmap.CustomGetSetMethodFieldMap;
import org.dozer.fieldmap.ExcludeFieldMap;
import org.dozer.fieldmap.FieldMap;
import org.dozer.fieldmap.HintContainer;
import org.dozer.fieldmap.MapFieldMap;
import org.dozer.propertydescriptor.PropertyDescriptorFactory;
import org.dozer.util.CollectionUtils;
import org.dozer.util.DozerConstants;
import org.dozer.util.IteratorUtils;
import org.dozer.util.LogMsgFactory;
import org.dozer.util.MappingUtils;
import org.dozer.util.MappingValidator;
import org.dozer.util.ReflectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MappingProcessor
implements Mapper {
    private final Logger log = LoggerFactory.getLogger(MappingProcessor.class);
    private final ClassMappings classMappings;
    private final Configuration globalConfiguration;
    private final List<CustomConverter> customConverterObjects;
    private final Map<String, CustomConverter> customConverterObjectsWithId;
    private final EventManager eventMgr;
    private final CustomFieldMapper customFieldMapper;
    private final MappedFieldsTracker mappedFields = new MappedFieldsTracker();
    private final Cache converterByDestTypeCache;
    private final Cache superTypeCache;
    private final PrimitiveOrWrapperConverter primitiveConverter;
    private final LogMsgFactory logMsgFactory = new LogMsgFactory();
    private final BeanContainer beanContainer;
    private final ClassMapBuilder classMapBuilder;
    private final DestBeanCreator destBeanCreator;
    private final DestBeanBuilderCreator destBeanBuilderCreator;

    protected MappingProcessor(ClassMappings classMappings, Configuration globalConfiguration, CacheManager cacheMgr, List<CustomConverter> customConverterObjects, DozerEventManager eventManager, CustomFieldMapper customFieldMapper, Map<String, CustomConverter> customConverterObjectsWithId, BeanContainer beanContainer, DestBeanCreator destBeanCreator, DestBeanBuilderCreator destBeanBuilderCreator, BeanMappingGenerator beanMappingGenerator, PropertyDescriptorFactory propertyDescriptorFactory) {
        this.classMappings = classMappings;
        this.globalConfiguration = globalConfiguration;
        this.customConverterObjects = customConverterObjects;
        this.eventMgr = eventManager;
        this.customFieldMapper = customFieldMapper;
        this.converterByDestTypeCache = cacheMgr.getCache(DozerCacheType.CONVERTER_BY_DEST_TYPE.name());
        this.superTypeCache = cacheMgr.getCache(DozerCacheType.SUPER_TYPE_CHECK.name());
        this.customConverterObjectsWithId = customConverterObjectsWithId;
        this.beanContainer = beanContainer;
        this.destBeanBuilderCreator = destBeanBuilderCreator;
        this.classMapBuilder = new ClassMapBuilder(beanContainer, destBeanCreator, beanMappingGenerator, propertyDescriptorFactory);
        this.primitiveConverter = new PrimitiveOrWrapperConverter(beanContainer);
        this.destBeanCreator = destBeanCreator;
    }

    @Override
    public <T> T map(Object srcObj, Class<T> destClass) {
        return this.map(srcObj, destClass, null);
    }

    @Override
    public <T> T map(Object srcObj, Class<T> destClass, String mapId) {
        MappingValidator.validateMappingRequest(srcObj, destClass);
        return this.mapGeneral(srcObj, destClass, null, mapId);
    }

    @Override
    public void map(Object srcObj, Object destObj) {
        this.map(srcObj, destObj, null);
    }

    @Override
    public void map(Object srcObj, Object destObj, String mapId) {
        MappingValidator.validateMappingRequest(srcObj, destObj);
        this.mapGeneral(srcObj, null, destObj, mapId);
    }

    private <T> T mapGeneral(Object srcObj, Class<T> destClass, T destObj, String mapId) {
        Object result;
        Class<Object> destType;
        srcObj = MappingUtils.deProxy(srcObj, this.beanContainer);
        if (destClass == null) {
            destType = destObj.getClass();
            result = destObj;
        } else {
            destType = destClass;
            result = null;
        }
        ClassMap classMap = null;
        try {
            Object alreadyMappedValue;
            classMap = this.getClassMap(srcObj.getClass(), destType, mapId);
            this.eventMgr.fireEvent(new DozerEvent(DozerEventType.MAPPING_STARTED, classMap, null, srcObj, result, null));
            Class<?> converterClass = MappingUtils.findCustomConverter(this.converterByDestTypeCache, classMap.getCustomConverters(), srcObj.getClass(), destType);
            if (destObj == null && (alreadyMappedValue = this.mappedFields.getMappedValue(srcObj, destType, mapId)) != null) {
                return (T)alreadyMappedValue;
            }
            if (converterClass != null) {
                return (T)this.mapUsingCustomConverter(converterClass, srcObj.getClass(), srcObj, destType, result, null, true);
            }
            BeanCreationDirective creationDirective = new BeanCreationDirective(srcObj, classMap.getSrcClassToMap(), classMap.getDestClassToMap(), destType, classMap.getDestClassBeanFactory(), classMap.getDestClassBeanFactoryId(), classMap.getDestClassCreateMethod(), classMap.getDestClass().isSkipConstructor());
            result = this.createByCreationDirectiveAndMap(creationDirective, classMap, srcObj, result, false, null);
        }
        catch (Throwable e) {
            MappingUtils.throwMappingException(e);
        }
        this.eventMgr.fireEvent(new DozerEvent(DozerEventType.MAPPING_FINISHED, classMap, null, srcObj, result, null));
        return result;
    }

    private <T> T createByCreationDirectiveAndMap(BeanCreationDirective creationDirective, ClassMap classMap, Object srcObj, T result, boolean bypassSuperMappings, String mapId) {
        if (result == null) {
            BeanBuilder beanBuilder = this.destBeanBuilderCreator.create(creationDirective);
            if (beanBuilder == null) {
                result = this.destBeanCreator.create(creationDirective);
                this.mapToDestObject(classMap, srcObj, result, bypassSuperMappings, mapId);
            } else {
                this.mapToDestObject(classMap, srcObj, beanBuilder, bypassSuperMappings, mapId);
                result = beanBuilder.build();
            }
        } else {
            this.mapToDestObject(classMap, srcObj, result, bypassSuperMappings, mapId);
        }
        return result;
    }

    private void mapToDestObject(ClassMap classMap, Object srcObj, Object destObj, boolean bypassSuperMappings, String mapId) {
        Object result = destObj;
        if (JAXBElement.class.isAssignableFrom(destObj.getClass())) {
            classMap = this.getClassMap(srcObj.getClass(), ((JAXBElement)JAXBElement.class.cast(destObj)).getDeclaredType(), mapId);
            result = ((JAXBElement)JAXBElement.class.cast(destObj)).getValue();
        }
        this.map(classMap, srcObj, result, bypassSuperMappings, new ArrayList<String>(), mapId);
    }

    private void map(ClassMap classMap, Object srcObj, Object destObj, boolean bypassSuperMappings, List<String> mappedParentFields, String mapId) {
        srcObj = MappingUtils.deProxy(srcObj, this.beanContainer);
        this.mappedFields.put(srcObj, destObj, mapId);
        if (classMap == null) {
            classMap = this.getClassMap(srcObj.getClass(), destObj.getClass(), mapId);
        }
        Class<?> srcClass = srcObj.getClass();
        Class<?> destClass = destObj.getClass();
        Class<?> converterClass = MappingUtils.findCustomConverter(this.converterByDestTypeCache, classMap.getCustomConverters(), srcClass, destClass);
        if (converterClass != null) {
            destObj = this.mapUsingCustomConverter(converterClass, srcClass, srcObj, destClass, destObj, null, true);
            return;
        }
        if (!bypassSuperMappings) {
            ArrayList<ClassMap> superMappings = new ArrayList<ClassMap>();
            Collection<ClassMap> superClasses = this.checkForSuperTypeMapping(srcClass, destClass);
            superMappings.addAll(superClasses);
            if (!superMappings.isEmpty()) {
                this.processSuperTypeMapping(superMappings, srcObj, destObj, mappedParentFields, mapId);
            }
        }
        for (FieldMap fieldMapping : classMap.getFieldMaps()) {
            String key = MappingUtils.getMappedParentFieldKey(destObj, fieldMapping);
            if (mappedParentFields != null && mappedParentFields.contains(key)) continue;
            this.mapField(fieldMapping, srcObj, destObj);
        }
    }

    private void mapField(FieldMap fieldMapping, Object srcObj, Object destObj) {
        block8: {
            if (fieldMapping instanceof ExcludeFieldMap) {
                return;
            }
            Object srcFieldValue = null;
            try {
                srcFieldValue = fieldMapping.getSrcFieldValue(srcObj);
                boolean fieldMapped = false;
                if (this.customFieldMapper != null) {
                    fieldMapped = this.customFieldMapper.mapField(srcObj, destObj, srcFieldValue, fieldMapping.getClassMap(), fieldMapping);
                }
                if (!fieldMapped) {
                    if (fieldMapping.getDestFieldType() != null && "iterate".equals(fieldMapping.getDestFieldType())) {
                        this.mapFromIterateMethodFieldMap(srcObj, destObj, srcFieldValue, fieldMapping);
                    } else {
                        this.mapFromFieldMap(srcObj, destObj, srcFieldValue, fieldMapping);
                    }
                }
            }
            catch (Throwable e) {
                this.log.error(this.logMsgFactory.createFieldMappingErrorMsg(srcObj, fieldMapping, srcFieldValue, destObj), e);
                if (fieldMapping.isStopOnErrors()) {
                    MappingUtils.throwMappingException(e);
                }
                if (fieldMapping.getClassMap().getAllowedExceptions().isEmpty() || !(e.getCause() instanceof InvocationTargetException)) break block8;
                Throwable thrownType = ((InvocationTargetException)e.getCause()).getTargetException();
                Class<?> exceptionClass = thrownType.getClass();
                if (!fieldMapping.getClassMap().getAllowedExceptions().contains(exceptionClass)) break block8;
                throw (RuntimeException)thrownType;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void mapFromFieldMap(Object srcObj, Object destObj, Object srcFieldValue, FieldMap fieldMapping) {
        Object destFieldValue;
        Class<?> destFieldType;
        if (fieldMapping instanceof CustomGetSetMethodFieldMap) {
            try {
                destFieldType = fieldMapping.getDestFieldWriteMethodParameter(destObj.getClass());
            }
            catch (Throwable e) {
                destFieldType = fieldMapping.getDestFieldType(BuilderUtil.unwrapDestClassFromBuilder(destObj));
            }
        } else {
            destFieldType = fieldMapping.getDestFieldType(BuilderUtil.unwrapDestClassFromBuilder(destObj));
        }
        if (!MappingUtils.isBlankOrNull(fieldMapping.getCustomConverterId())) {
            if (this.customConverterObjectsWithId == null || !this.customConverterObjectsWithId.containsKey(fieldMapping.getCustomConverterId())) throw new MappingException("CustomConverter instance not found with id:" + fieldMapping.getCustomConverterId());
            Class<?> srcFieldClass = srcFieldValue != null ? srcFieldValue.getClass() : fieldMapping.getSrcFieldType(srcObj.getClass());
            destFieldValue = this.mapUsingCustomConverterInstance(this.customConverterObjectsWithId.get(fieldMapping.getCustomConverterId()), srcFieldClass, srcFieldValue, destFieldType, destObj, fieldMapping, false);
        } else if (MappingUtils.isBlankOrNull(fieldMapping.getCustomConverter())) {
            destFieldValue = this.mapOrRecurseObject(srcObj, srcFieldValue, destFieldType, fieldMapping, destObj);
        } else {
            Class<?> srcFieldClass = srcFieldValue != null ? srcFieldValue.getClass() : fieldMapping.getSrcFieldType(srcObj.getClass());
            destFieldValue = this.mapUsingCustomConverter(MappingUtils.loadClass(fieldMapping.getCustomConverter(), this.beanContainer), srcFieldClass, srcFieldValue, destFieldType, destObj, fieldMapping, false);
        }
        this.writeDestinationValue(destObj, destFieldValue, fieldMapping, srcObj);
        if (!this.log.isDebugEnabled()) return;
        this.log.debug(this.logMsgFactory.createFieldMappingSuccessMsg(srcObj.getClass(), destObj.getClass(), fieldMapping.getSrcFieldName(), fieldMapping.getDestFieldName(), srcFieldValue, destFieldValue, fieldMapping.getClassMap().getMapId()));
    }

    private Object mapOrRecurseObject(Object srcObj, Object srcFieldValue, Class<?> destFieldType, FieldMap fieldMap, Object destObj) {
        Object alreadyMappedValue;
        Class<?> srcFieldClass = srcFieldValue != null ? srcFieldValue.getClass() : fieldMap.getSrcFieldType(srcObj.getClass());
        Class<?> converterClass = MappingUtils.determineCustomConverter(fieldMap, this.converterByDestTypeCache, fieldMap.getClassMap().getCustomConverters(), srcFieldClass, destFieldType);
        if (converterClass != null) {
            return this.mapUsingCustomConverter(converterClass, srcFieldClass, srcFieldValue, destFieldType, destObj, fieldMap, false);
        }
        if (srcFieldValue == null) {
            return null;
        }
        String srcFieldName = fieldMap.getSrcFieldName();
        String destFieldName = fieldMap.getDestFieldName();
        if (!("this".equals(srcFieldName) && "this".equals(destFieldName) || (alreadyMappedValue = this.mappedFields.getMappedValue(srcFieldValue, destFieldType, fieldMap.getMapId())) == null)) {
            return alreadyMappedValue;
        }
        if (fieldMap.isCopyByReference()) {
            return srcFieldValue;
        }
        boolean isSrcFieldClassSupportedMap = MappingUtils.isSupportedMap(srcFieldClass);
        boolean isDestFieldTypeSupportedMap = MappingUtils.isSupportedMap(destFieldType);
        if (isSrcFieldClassSupportedMap && isDestFieldTypeSupportedMap) {
            return this.mapMap(srcObj, (Map)srcFieldValue, fieldMap, destObj);
        }
        if (fieldMap instanceof MapFieldMap && destFieldType.equals(Object.class)) {
            Class<?> clazz = destFieldType = fieldMap.getDestHintContainer() != null ? fieldMap.getDestHintContainer().getHint() : srcFieldClass;
        }
        if (this.primitiveConverter.accepts(srcFieldClass) || this.primitiveConverter.accepts(destFieldType)) {
            Class<?> destHintType;
            if (fieldMap.getDestHintContainer() != null && (destHintType = fieldMap.getDestHintType(srcFieldValue.getClass())) != null) {
                destFieldType = destHintType;
            }
            Object convertSrcFieldValue = srcFieldValue;
            if (fieldMap.isTrimStrings() && srcFieldValue.getClass().equals(String.class)) {
                convertSrcFieldValue = ((String)srcFieldValue).trim();
            }
            DateFormatContainer dfContainer = new DateFormatContainer(fieldMap.getDateFormat());
            if (fieldMap instanceof MapFieldMap && !this.primitiveConverter.accepts(destFieldType)) {
                return this.primitiveConverter.convert(convertSrcFieldValue, convertSrcFieldValue.getClass(), dfContainer);
            }
            return this.primitiveConverter.convert(convertSrcFieldValue, destFieldType, dfContainer, destFieldName, destObj);
        }
        if (MappingUtils.isSupportedCollection(srcFieldClass) && MappingUtils.isSupportedCollection(destFieldType)) {
            return this.mapCollection(srcObj, srcFieldValue, fieldMap, destObj);
        }
        if (MappingUtils.isEnumType(srcFieldClass, destFieldType)) {
            return this.mapEnum((Enum)srcFieldValue, destFieldType);
        }
        if (fieldMap.getDestDeepIndexHintContainer() != null) {
            destFieldType = fieldMap.getDestDeepIndexHintContainer().getHint();
        }
        return this.mapCustomObject(fieldMap, destObj, destFieldType, destFieldName, srcFieldValue);
    }

    private <T extends Enum<T>> T mapEnum(Enum<T> srcFieldValue, Class<T> destFieldType) {
        String name = srcFieldValue.name();
        return Enum.valueOf(this.getSerializableEnumClass(destFieldType), name);
    }

    private <T extends Enum<T>> Class<T> getSerializableEnumClass(Class<T> enumClass) {
        if (this.checkIfOverriddenEnum(enumClass)) {
            Class<T> castedSuperclass = enumClass.getSuperclass();
            return castedSuperclass;
        }
        return enumClass;
    }

    private <T extends Enum<T>> boolean checkIfOverriddenEnum(Class<T> enumClass) {
        return !Enum.class.equals(enumClass.getSuperclass());
    }

    private Object mapCustomObject(FieldMap fieldMap, Object destObj, Class<?> destFieldType, String destFieldName, Object srcFieldValue) {
        srcFieldValue = MappingUtils.deProxy(srcFieldValue, this.beanContainer);
        Object result = null;
        if (!"iterate".equals(fieldMap.getDestFieldType())) {
            result = MappingProcessor.getExistingValue(fieldMap, destObj, destFieldType);
        }
        if (result == null) {
            Class<?> destHintType;
            if (fieldMap.getDestHintContainer() != null && (destHintType = fieldMap.getDestHintType(srcFieldValue.getClass())) != null) {
                destFieldType = destHintType;
            }
            String mapId = fieldMap.getMapId();
            Class<?> targetClass = fieldMap.getDestHintContainer() != null && fieldMap.getDestHintContainer().getHint() != null ? fieldMap.getDestHintContainer().getHint() : destFieldType;
            ClassMap classMap = this.getClassMap(srcFieldValue.getClass(), targetClass, mapId);
            BeanCreationDirective creationDirective = new BeanCreationDirective(srcFieldValue, classMap.getSrcClassToMap(), classMap.getDestClassToMap(), destFieldType, classMap.getDestClassBeanFactory(), classMap.getDestClassBeanFactoryId(), fieldMap.getDestFieldCreateMethod() != null ? fieldMap.getDestFieldCreateMethod() : classMap.getDestClassCreateMethod(), classMap.getDestClass().isSkipConstructor(), destObj, destFieldName);
            result = this.createByCreationDirectiveAndMap(creationDirective, classMap, srcFieldValue, null, false, fieldMap.getMapId());
        } else {
            this.mapToDestObject(null, srcFieldValue, result, false, fieldMap.getMapId());
        }
        return result;
    }

    private Object mapCollection(Object srcObj, Object srcCollectionValue, FieldMap fieldMap, Object destObj) {
        Class<?> genericType;
        if (fieldMap.getDestHintContainer() == null && (genericType = fieldMap.getGenericType(BuilderUtil.unwrapDestClassFromBuilder(destObj))) != null) {
            HintContainer destHintContainer = new HintContainer(this.beanContainer);
            destHintContainer.setHintName(genericType.getName());
            FieldMap cloneFieldMap = (FieldMap)fieldMap.clone();
            cloneFieldMap.setDestHintContainer(destHintContainer);
            fieldMap = cloneFieldMap;
        }
        if (srcCollectionValue instanceof Iterator) {
            srcCollectionValue = IteratorUtils.toList((Iterator)((Object)srcCollectionValue));
        }
        Class<Object> destCollectionType = fieldMap.getDestFieldType(BuilderUtil.unwrapDestClassFromBuilder(destObj));
        Class<?> srcFieldType = srcCollectionValue.getClass();
        Collection<?> result = null;
        if (destCollectionType.getName().equals(Collection.class.getName())) {
            destCollectionType = List.class;
            if (Set.class.isAssignableFrom(srcFieldType)) {
                destCollectionType = Set.class;
            }
        }
        if (CollectionUtils.isArray(srcFieldType) && CollectionUtils.isArray(destCollectionType)) {
            result = this.mapArrayToArray(srcObj, srcCollectionValue, fieldMap, destObj);
        } else if (CollectionUtils.isArray(srcFieldType) && CollectionUtils.isList(destCollectionType)) {
            result = this.mapArrayToList(srcObj, srcCollectionValue, fieldMap, destObj);
        } else if (CollectionUtils.isList(srcFieldType) && CollectionUtils.isArray(destCollectionType)) {
            result = this.mapListToArray(srcObj, srcCollectionValue, fieldMap, destObj);
        } else if (CollectionUtils.isSet(srcFieldType) && CollectionUtils.isArray(destCollectionType)) {
            result = this.mapSetToArray(srcObj, (Set)((Object)srcCollectionValue), fieldMap, destObj);
        } else if (CollectionUtils.isArray(srcFieldType) && CollectionUtils.isSet(destCollectionType)) {
            result = this.addToSet(srcObj, fieldMap, Arrays.asList((Object[])srcCollectionValue), destObj);
        } else if (CollectionUtils.isCollection(srcFieldType) && CollectionUtils.isSet(destCollectionType)) {
            result = this.addToSet(srcObj, fieldMap, srcCollectionValue, destObj);
        } else if (CollectionUtils.isCollection(srcFieldType) && MappingUtils.isSupportedMap(destCollectionType)) {
            result = this.mapListToList(srcObj, srcCollectionValue, fieldMap, destObj);
        } else if (CollectionUtils.isCollection(srcFieldType) && CollectionUtils.isList(destCollectionType)) {
            result = this.mapListToList(srcObj, srcCollectionValue, fieldMap, destObj);
        }
        return result;
    }

    private Object mapMap(Object srcObj, Map srcMapValue, FieldMap fieldMap, Object destObj) {
        Map result;
        Map destinationMap = (Map)fieldMap.getDestValue(destObj);
        if (destinationMap == null) {
            result = (Map)this.destBeanCreator.create(srcMapValue.getClass());
        } else {
            result = destinationMap;
            if (fieldMap.isRemoveOrphans()) {
                result.clear();
            }
        }
        for (Map.Entry srcEntry : srcMapValue.entrySet()) {
            Object srcEntryValue = srcEntry.getValue();
            if (srcEntryValue == null) {
                result.put(srcEntry.getKey(), null);
                continue;
            }
            Object destEntryValue = this.mapOrRecurseObject(srcObj, srcEntryValue, srcEntryValue.getClass(), fieldMap, destObj);
            Object obj = result.get(srcEntry.getKey());
            if (obj != null && obj.equals(destEntryValue) && fieldMap.isNonCumulativeRelationship()) {
                this.mapToDestObject(null, srcEntryValue, obj, false, null);
                continue;
            }
            result.put(srcEntry.getKey(), destEntryValue);
        }
        return result;
    }

    private Object mapArrayToArray(Object srcObj, Object srcCollectionValue, FieldMap fieldMap, Object destObj) {
        Class<?> destEntryType = fieldMap.getDestFieldType(destObj.getClass()).getComponentType();
        Class<?> srcEntryType = srcCollectionValue.getClass().getComponentType();
        int size = Array.getLength(srcCollectionValue);
        CopyByReferenceContainer copyByReferences = this.globalConfiguration.getCopyByReferences();
        boolean isPrimitiveArray = CollectionUtils.isPrimitiveArray(srcCollectionValue.getClass());
        boolean isFinal = Modifier.isFinal(srcEntryType.getModifiers());
        boolean isCopyByReference = copyByReferences.contains(srcEntryType);
        if (destEntryType.isAssignableFrom(srcEntryType) && isFinal && (isPrimitiveArray || isCopyByReference)) {
            return this.addArrayContentCopy(fieldMap, size, srcCollectionValue, destObj, destEntryType);
        }
        if (isPrimitiveArray) {
            return this.addToPrimitiveArray(srcObj, fieldMap, size, srcCollectionValue, destObj, destEntryType);
        }
        List<Object> list = Arrays.asList((Object[])srcCollectionValue);
        List<?> returnList = !destEntryType.getName().equals(DozerConstants.BASE_CLASS) ? this.addOrUpdateToList(srcObj, fieldMap, list, destObj, destEntryType) : this.addOrUpdateToList(srcObj, fieldMap, list, destObj, null);
        return CollectionUtils.convertListToArray(returnList, destEntryType);
    }

    private void mapFromIterateMethodFieldMap(Object srcObj, Object destObj, Object srcFieldValue, FieldMap fieldMapping) {
        if (srcFieldValue instanceof Iterator) {
            srcFieldValue = IteratorUtils.toList((Iterator)((Object)srcFieldValue));
        }
        if (srcFieldValue != null) {
            for (int i = 0; i < CollectionUtils.getLengthOfCollection(srcFieldValue); ++i) {
                Object value = CollectionUtils.getValueFromCollection(srcFieldValue, i);
                if (fieldMapping.getDestHintContainer() == null) {
                    MappingUtils.throwMappingException("<field type=\"iterate\"> must have a source or destination type hint");
                }
                Class<?> destinationHint = fieldMapping.getDestHintType(value.getClass());
                Object result = this.mapOrRecurseObject(srcObj, value, destinationHint, fieldMapping, destObj);
                if (value == null) continue;
                this.writeDestinationValue(destObj, result, fieldMapping, srcObj);
            }
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug(this.logMsgFactory.createFieldMappingSuccessMsg(srcObj.getClass(), destObj.getClass(), fieldMapping.getSrcFieldName(), fieldMapping.getDestFieldName(), srcFieldValue, null, fieldMapping.getClassMap().getMapId()));
        }
    }

    private Object addArrayContentCopy(FieldMap fieldMap, int size, Object srcCollectionValue, Object destObj, Class destEntryType) {
        Object result;
        Object field = fieldMap.getDestValue(destObj);
        int arraySize = 0;
        if (field == null) {
            result = Array.newInstance(destEntryType, size);
        } else {
            result = Array.newInstance(destEntryType, size + Array.getLength(field));
            arraySize = Array.getLength(field);
            System.arraycopy(field, 0, result, 0, arraySize);
        }
        System.arraycopy(srcCollectionValue, 0, result, arraySize, size);
        return result;
    }

    private Object addToPrimitiveArray(Object srcObj, FieldMap fieldMap, int size, Object srcCollectionValue, Object destObj, Class<?> destEntryType) {
        Object result;
        Object field = fieldMap.getDestValue(destObj);
        int arraySize = 0;
        if (field == null) {
            result = Array.newInstance(destEntryType, size);
        } else {
            result = Array.newInstance(destEntryType, size + Array.getLength(field));
            arraySize = Array.getLength(field);
            System.arraycopy(field, 0, result, 0, arraySize);
        }
        for (int i = 0; i < size; ++i) {
            CopyByReferenceContainer copyByReferences = this.globalConfiguration.getCopyByReferences();
            Object toValue = srcCollectionValue != null && copyByReferences.contains(srcCollectionValue.getClass()) ? srcCollectionValue : this.mapOrRecurseObject(srcObj, Array.get(srcCollectionValue, i), destEntryType, fieldMap, destObj);
            Array.set(result, arraySize, toValue);
            ++arraySize;
        }
        return result;
    }

    private Object mapListToArray(Object srcObj, Collection<?> srcCollectionValue, FieldMap fieldMap, Object destObj) {
        Class<?> destEntryType = fieldMap.getDestFieldType(destObj.getClass()).getComponentType();
        List<?> list = !destEntryType.getName().equals(DozerConstants.BASE_CLASS) ? this.addOrUpdateToList(srcObj, fieldMap, srcCollectionValue, destObj, destEntryType) : this.addOrUpdateToList(srcObj, fieldMap, srcCollectionValue, destObj);
        return CollectionUtils.convertListToArray(list, destEntryType);
    }

    private List<?> mapListToList(Object srcObj, Collection<?> srcCollectionValue, FieldMap fieldMap, Object destObj) {
        return this.addOrUpdateToList(srcObj, fieldMap, srcCollectionValue, destObj);
    }

    private Set<?> addToSet(Object srcObj, FieldMap fieldMap, Collection<?> srcCollectionValue, Object destObj) {
        HashSet<Object> mappedElements = new HashSet<Object>();
        LinkedHashSet<Object> result = new LinkedHashSet<Object>();
        Object field = fieldMap.getDestValue(destObj);
        if (field != null) {
            result.addAll((Collection)field);
        }
        Class<?> destEntryType = null;
        Class<?> prevDestEntryType = null;
        for (Object srcValue : srcCollectionValue) {
            if (destEntryType == null || fieldMap.getDestHintContainer() != null && fieldMap.getDestHintContainer().hasMoreThanOneHint()) {
                destEntryType = this.determineCollectionItemType(fieldMap, destObj, srcValue, prevDestEntryType);
            }
            CopyByReferenceContainer copyByReferences = this.globalConfiguration.getCopyByReferences();
            Object destValue = srcValue != null && copyByReferences.contains(srcValue.getClass()) ? srcValue : this.mapOrRecurseObject(srcObj, srcValue, destEntryType, fieldMap, destObj);
            prevDestEntryType = destEntryType;
            if (RelationshipType.NON_CUMULATIVE.equals(fieldMap.getRelationshipType()) && result.contains(destValue)) {
                ArrayList resultAsList = new ArrayList(result);
                int index = resultAsList.indexOf(destValue);
                Object obj = resultAsList.get(index);
                if (obj.getClass().isAssignableFrom(String.class)) continue;
                this.mapToDestObject(null, srcValue, obj, false, fieldMap.getMapId());
                mappedElements.add(obj);
                continue;
            }
            if (destValue != null || fieldMap.isDestMapNull()) {
                result.add(destValue);
            }
            mappedElements.add(destValue);
        }
        if (fieldMap.isRemoveOrphans()) {
            result.clear();
            result.addAll(mappedElements);
        }
        if (field == null) {
            Class<?> destSetType = fieldMap.getDestFieldType(destObj.getClass());
            return CollectionUtils.createNewSet(destSetType, result);
        }
        ((Set)field).clear();
        ((Set)field).addAll(result);
        return (Set)field;
    }

    private List<?> addOrUpdateToList(Object srcObj, FieldMap fieldMap, Collection<?> srcCollectionValue, Object destObj, Class<?> destEntryType) {
        ArrayList<Object> mappedElements = new ArrayList<Object>();
        Object field = fieldMap.getDestValue(destObj);
        List<Object> result = MappingProcessor.prepareDestinationList(srcCollectionValue, field);
        Class<?> prevDestEntryType = null;
        for (Object srcValue : srcCollectionValue) {
            if (destEntryType == null || fieldMap.getDestHintContainer() != null && fieldMap.getDestHintContainer().hasMoreThanOneHint()) {
                destEntryType = this.determineCollectionItemType(fieldMap, destObj, srcValue, prevDestEntryType);
            }
            CopyByReferenceContainer copyByReferences = this.globalConfiguration.getCopyByReferences();
            Object destValue = srcValue != null && copyByReferences.contains(srcValue.getClass()) ? srcValue : this.mapOrRecurseObject(srcObj, srcValue, destEntryType, fieldMap, destObj);
            prevDestEntryType = destEntryType;
            if (RelationshipType.NON_CUMULATIVE.equals(fieldMap.getRelationshipType()) && result.contains(destValue)) {
                int index = result.indexOf(destValue);
                Object obj = result.get(index);
                if (obj == null || obj.getClass().isAssignableFrom(String.class)) continue;
                this.mapToDestObject(null, srcValue, obj, false, fieldMap.getMapId());
                mappedElements.add(obj);
                continue;
            }
            if (destValue != null || fieldMap.isDestMapNull()) {
                result.add(destValue);
            }
            mappedElements.add(destValue);
        }
        if (fieldMap.isRemoveOrphans()) {
            MappingProcessor.removeOrphans(mappedElements, result);
        }
        return result;
    }

    private Class<?> determineCollectionItemType(FieldMap fieldMap, Object destObj, Object srcValue, Class<?> prevDestEntryType) {
        if (srcValue == null && fieldMap.getDestHintType(destObj.getClass()) != null) {
            return fieldMap.getDestHintType(destObj.getClass());
        }
        if (srcValue == null && prevDestEntryType != null) {
            return prevDestEntryType;
        }
        if (srcValue != null) {
            return fieldMap.getDestHintType(srcValue.getClass());
        }
        throw new MappingException("Unable to determine type for value '" + srcValue + "'. Use hints or generic collections.");
    }

    static void removeOrphans(Collection<?> mappedElements, List<Object> result) {
        Iterator<Object> iterator = result.iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            if (mappedElements.contains(object)) continue;
            iterator.remove();
        }
        for (Object object : mappedElements) {
            if (result.contains(object)) continue;
            result.add(object);
        }
    }

    static List<?> prepareDestinationList(Collection<?> srcCollectionValue, Object field) {
        if (field == null) {
            return new ArrayList(srcCollectionValue.size());
        }
        if (CollectionUtils.isList(field.getClass())) {
            return (List)field;
        }
        if (CollectionUtils.isArray(field.getClass())) {
            return new ArrayList<Object>(Arrays.asList((Object[])field));
        }
        return new ArrayList(srcCollectionValue.size());
    }

    private List<?> addOrUpdateToList(Object srcObj, FieldMap fieldMap, Collection<?> srcCollectionValue, Object destObj) {
        return this.addOrUpdateToList(srcObj, fieldMap, srcCollectionValue, destObj, null);
    }

    private Object mapSetToArray(Object srcObj, Collection<?> srcCollectionValue, FieldMap fieldMap, Object destObj) {
        return this.mapListToArray(srcObj, srcCollectionValue, fieldMap, destObj);
    }

    private List<?> mapArrayToList(Object srcObj, Object srcCollectionValue, FieldMap fieldMap, Object destObj) {
        Class<?> destEntryType = fieldMap.getDestHintContainer() != null ? fieldMap.getDestHintContainer().getHint() : srcCollectionValue.getClass().getComponentType();
        List<Object> srcValueList = CollectionUtils.isPrimitiveArray(srcCollectionValue.getClass()) ? CollectionUtils.convertPrimitiveArrayToList(srcCollectionValue) : Arrays.asList((Object[])srcCollectionValue);
        return this.addOrUpdateToList(srcObj, fieldMap, srcValueList, destObj, destEntryType);
    }

    private void writeDestinationValue(Object destObj, Object destFieldValue, FieldMap fieldMap, Object srcObj) {
        boolean bypass = false;
        if (destFieldValue == null && !fieldMap.isDestMapNull()) {
            bypass = true;
        }
        if (destFieldValue != null && !fieldMap.isDestMapEmptyString() && destFieldValue.getClass().equals(String.class) && StringUtils.isEmpty((CharSequence)((String)destFieldValue))) {
            bypass = true;
        }
        if (destFieldValue != null && fieldMap.isTrimStrings() && destFieldValue.getClass().equals(String.class)) {
            destFieldValue = ((String)destFieldValue).trim();
        }
        if (!bypass) {
            this.eventMgr.fireEvent(new DozerEvent(DozerEventType.MAPPING_PRE_WRITING_DEST_VALUE, fieldMap.getClassMap(), fieldMap, srcObj, destObj, destFieldValue));
            fieldMap.writeDestValue(destObj, destFieldValue);
            this.eventMgr.fireEvent(new DozerEvent(DozerEventType.MAPPING_POST_WRITING_DEST_VALUE, fieldMap.getClassMap(), fieldMap, srcObj, destObj, destFieldValue));
        }
    }

    private Object mapUsingCustomConverterInstance(CustomConverter converterInstance, Class<?> srcFieldClass, Object srcFieldValue, Class<?> destFieldClass, Object existingDestFieldValue, FieldMap fieldMap, boolean topLevel) {
        Object result;
        if (srcFieldValue == null && !fieldMap.isDestMapNull()) {
            return null;
        }
        if (converterInstance instanceof MapperAware) {
            ((MapperAware)((Object)converterInstance)).setMapper(this);
        }
        if (converterInstance instanceof ConfigurableCustomConverter) {
            ConfigurableCustomConverter theConverter = (ConfigurableCustomConverter)converterInstance;
            if (fieldMap != null) {
                String param = fieldMap.getCustomConverterParam();
                theConverter.setParameter(param);
            }
            if (topLevel) {
                result = theConverter.convert(existingDestFieldValue, srcFieldValue, destFieldClass, srcFieldClass);
            } else {
                Object existingValue = MappingProcessor.getExistingValue(fieldMap, existingDestFieldValue, destFieldClass);
                result = theConverter.convert(existingValue, srcFieldValue, destFieldClass, srcFieldClass);
            }
        } else if (topLevel) {
            result = converterInstance.convert(existingDestFieldValue, srcFieldValue, destFieldClass, srcFieldClass);
        } else {
            Object existingValue = MappingProcessor.getExistingValue(fieldMap, existingDestFieldValue, destFieldClass);
            result = converterInstance.convert(existingValue, srcFieldValue, destFieldClass, srcFieldClass);
        }
        return result;
    }

    private Object mapUsingCustomConverter(Class<?> customConverterClass, Class<?> srcFieldClass, Object srcFieldValue, Class<?> destFieldClass, Object existingDestFieldValue, FieldMap fieldMap, boolean topLevel) {
        CustomConverter converterInstance = null;
        if (this.customConverterObjects != null) {
            for (CustomConverter customConverterObject : this.customConverterObjects) {
                if (!customConverterClass.isInstance(customConverterObject)) continue;
                converterInstance = customConverterObject;
            }
        }
        if (converterInstance == null) {
            converterInstance = (CustomConverter)ReflectionUtils.newInstance(customConverterClass);
        }
        return this.mapUsingCustomConverterInstance(converterInstance, srcFieldClass, srcFieldValue, destFieldClass, existingDestFieldValue, fieldMap, topLevel);
    }

    private Collection<ClassMap> checkForSuperTypeMapping(Class<?> srcClass, Class<?> destClass) {
        Object cacheKey = CacheKeyFactory.createKey(destClass, srcClass);
        Collection cachedResult = (Collection)this.superTypeCache.get(cacheKey);
        if (cachedResult != null) {
            return cachedResult;
        }
        ArrayList<ClassMap> superClasses = new ArrayList<ClassMap>();
        List<Class<?>> superSrcClasses = MappingUtils.getSuperClassesAndInterfaces(srcClass, this.beanContainer);
        List<Class<?>> superDestClasses = MappingUtils.getSuperClassesAndInterfaces(destClass, this.beanContainer);
        superSrcClasses.add(0, srcClass);
        superDestClasses.add(0, destClass);
        for (Class<?> superSrcClass : superSrcClasses) {
            for (Class<?> superDestClass : superDestClasses) {
                if (superSrcClass.equals(srcClass) && superDestClass.equals(destClass)) continue;
                this.checkForClassMapping(superSrcClass, superClasses, superDestClass);
            }
        }
        Collections.reverse(superClasses);
        this.superTypeCache.put(cacheKey, superClasses);
        return superClasses;
    }

    private void checkForClassMapping(Class<?> srcClass, List<ClassMap> superClasses, Class<?> superDestClass) {
        ClassMap srcClassMap = this.classMappings.find(srcClass, superDestClass);
        if (srcClassMap != null) {
            superClasses.add(srcClassMap);
        }
    }

    private void processSuperTypeMapping(Collection<ClassMap> superClasses, Object srcObj, Object destObj, List<String> mappedParentFields, String mapId) {
        for (ClassMap map : superClasses) {
            this.map(map, srcObj, destObj, true, mappedParentFields, mapId);
            for (FieldMap fieldMapping : map.getFieldMaps()) {
                String key = MappingUtils.getMappedParentFieldKey(destObj, fieldMapping);
                mappedParentFields.add(key);
            }
        }
    }

    private static Object getExistingValue(FieldMap fieldMap, Object destObj, Class<?> destFieldType) {
        if (destObj == null) {
            return null;
        }
        Object result = fieldMap.getDestValue(destObj);
        if (result != null && (CollectionUtils.isList(result.getClass()) || CollectionUtils.isArray(result.getClass()) || CollectionUtils.isSet(result.getClass()) || MappingUtils.isSupportedMap(result.getClass())) && !CollectionUtils.isList(destFieldType) && !CollectionUtils.isArray(destFieldType) && !CollectionUtils.isSet(destFieldType) && !MappingUtils.isSupportedMap(destFieldType)) {
            result = null;
        }
        return result;
    }

    private ClassMap getClassMap(Class<?> srcClass, Class<?> destClass, String mapId) {
        ClassMap mapping = this.classMappings.find(srcClass, destClass, mapId);
        if (mapping == null) {
            mapping = this.classMappings.find(destClass, srcClass, null);
            if (mapping != null && MappingDirection.ONE_WAY == mapping.getType()) {
                mapping = this.classMapBuilder.createDefaultClassMap(this.globalConfiguration, srcClass, destClass, false);
                this.classMappings.addDefault(srcClass, destClass, mapping);
            } else {
                mapping = this.classMapBuilder.createDefaultClassMap(this.globalConfiguration, srcClass, destClass);
                this.classMappings.addDefault(srcClass, destClass, mapping);
            }
        }
        return mapping;
    }
}

