/*
 * Decompiled with CFR 0.152.
 */
package org.dozer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dozer.CustomConverter;
import org.dozer.CustomFieldMapper;
import org.dozer.DozerEventListener;
import org.dozer.DozerInitializer;
import org.dozer.Mapper;
import org.dozer.MappingException;
import org.dozer.MappingProcessor;
import org.dozer.builder.DestBeanBuilderCreator;
import org.dozer.cache.CacheManager;
import org.dozer.cache.DozerCacheManager;
import org.dozer.cache.DozerCacheType;
import org.dozer.classmap.ClassMappings;
import org.dozer.classmap.Configuration;
import org.dozer.classmap.MappingFileData;
import org.dozer.classmap.generator.BeanMappingGenerator;
import org.dozer.config.BeanContainer;
import org.dozer.config.Settings;
import org.dozer.event.DozerEventManager;
import org.dozer.factory.DestBeanCreator;
import org.dozer.metadata.DozerMappingMetadata;
import org.dozer.metadata.MappingMetadata;
import org.dozer.propertydescriptor.PropertyDescriptorFactory;

public class DozerBeanMapper
implements Mapper {
    private final Settings settings;
    private final DozerInitializer dozerInitializer;
    private final BeanContainer beanContainer;
    private final DestBeanCreator destBeanCreator;
    private final DestBeanBuilderCreator destBeanBuilderCreator;
    private final BeanMappingGenerator beanMappingGenerator;
    private final PropertyDescriptorFactory propertyDescriptorFactory;
    private final ClassMappings customMappings;
    private final Configuration globalConfiguration;
    private final List<String> mappingFiles;
    private final List<CustomConverter> customConverters;
    private final List<MappingFileData> mappingsFileData;
    private final List<DozerEventListener> eventListeners;
    private final Map<String, CustomConverter> customConvertersWithId;
    private CustomFieldMapper customFieldMapper;
    private final CacheManager cacheManager;
    private DozerEventManager eventManager;

    DozerBeanMapper(List<String> mappingFiles, Settings settings, DozerInitializer dozerInitializer, BeanContainer beanContainer, DestBeanCreator destBeanCreator, DestBeanBuilderCreator destBeanBuilderCreator, BeanMappingGenerator beanMappingGenerator, PropertyDescriptorFactory propertyDescriptorFactory, List<CustomConverter> customConverters, List<MappingFileData> mappingsFileData, List<DozerEventListener> eventListeners, CustomFieldMapper customFieldMapper, Map<String, CustomConverter> customConvertersWithId, ClassMappings customMappings, Configuration globalConfiguration) {
        this.settings = settings;
        this.cacheManager = new DozerCacheManager();
        this.dozerInitializer = dozerInitializer;
        this.beanContainer = beanContainer;
        this.destBeanCreator = destBeanCreator;
        this.destBeanBuilderCreator = destBeanBuilderCreator;
        this.beanMappingGenerator = beanMappingGenerator;
        this.propertyDescriptorFactory = propertyDescriptorFactory;
        this.customConverters = new ArrayList<CustomConverter>(customConverters);
        this.mappingsFileData = new ArrayList<MappingFileData>(mappingsFileData);
        this.eventListeners = new ArrayList<DozerEventListener>(eventListeners);
        this.mappingFiles = new ArrayList<String>(mappingFiles);
        this.customFieldMapper = customFieldMapper;
        this.customConvertersWithId = new HashMap<String, CustomConverter>(customConvertersWithId);
        this.eventManager = new DozerEventManager(eventListeners);
        this.customMappings = customMappings;
        this.globalConfiguration = globalConfiguration;
        this.init();
    }

    @Override
    public void map(Object source, Object destination, String mapId) throws MappingException {
        this.getMappingProcessor().map(source, destination, mapId);
    }

    @Override
    public <T> T map(Object source, Class<T> destinationClass, String mapId) throws MappingException {
        return this.getMappingProcessor().map(source, destinationClass, mapId);
    }

    @Override
    public <T> T map(Object source, Class<T> destinationClass) throws MappingException {
        return this.getMappingProcessor().map(source, destinationClass);
    }

    @Override
    public void map(Object source, Object destination) throws MappingException {
        this.getMappingProcessor().map(source, destination);
    }

    private void init() {
        this.cacheManager.addCache(DozerCacheType.CONVERTER_BY_DEST_TYPE.name(), this.settings.getConverterByDestTypeCacheMaxSize());
        this.cacheManager.addCache(DozerCacheType.SUPER_TYPE_CHECK.name(), this.settings.getSuperTypesCacheMaxSize());
    }

    public void destroy() {
        this.dozerInitializer.destroy(this.settings);
    }

    protected Mapper getMappingProcessor() {
        MappingProcessor processor = new MappingProcessor(this.customMappings, this.globalConfiguration, this.cacheManager, this.customConverters, this.eventManager, this.customFieldMapper, this.customConvertersWithId, this.beanContainer, this.destBeanCreator, this.destBeanBuilderCreator, this.beanMappingGenerator, this.propertyDescriptorFactory);
        return processor;
    }

    @Deprecated
    public List<String> getMappingFiles() {
        return Collections.unmodifiableList(this.mappingFiles);
    }

    @Deprecated
    public List<CustomConverter> getCustomConverters() {
        return Collections.unmodifiableList(this.customConverters);
    }

    @Deprecated
    public Map<String, CustomConverter> getCustomConvertersWithId() {
        return Collections.unmodifiableMap(this.customConvertersWithId);
    }

    @Deprecated
    public List<? extends DozerEventListener> getEventListeners() {
        return Collections.unmodifiableList(this.eventListeners);
    }

    @Deprecated
    public CustomFieldMapper getCustomFieldMapper() {
        return this.customFieldMapper;
    }

    @Override
    public MappingMetadata getMappingMetadata() {
        return new DozerMappingMetadata(this.customMappings);
    }
}

