/*
 * Decompiled with CFR 0.152.
 */
package org.dozer.util;

import java.lang.reflect.Method;

public final class BridgedMethodFinder {
    private BridgedMethodFinder() {
    }

    public static Method findMethod(Method bridgeMethod, Class<?> targetClass) {
        Method[] methods;
        if (bridgeMethod == null || targetClass == null) {
            return bridgeMethod;
        }
        if (!bridgeMethod.isBridge()) {
            return bridgeMethod;
        }
        for (Method method : methods = bridgeMethod.getDeclaringClass().getDeclaredMethods()) {
            if (method.isBridge() || !BridgedMethodFinder.isAssignable(method, bridgeMethod)) continue;
            return method;
        }
        return bridgeMethod;
    }

    private static boolean isAssignable(Method candidate, Method method) {
        if (!method.getName().equals(candidate.getName())) {
            return false;
        }
        if (method.getParameterTypes().length != candidate.getParameterTypes().length) {
            return false;
        }
        if (!BridgedMethodFinder.isAssignable(method.getReturnType(), candidate.getReturnType())) {
            return false;
        }
        return BridgedMethodFinder.isAssignable(method.getParameterTypes(), candidate.getParameterTypes());
    }

    private static boolean isAssignable(Class<?>[] as, Class<?>[] bs) {
        if (as == null && bs == null) {
            return true;
        }
        if (as == null || bs == null) {
            return false;
        }
        if (as.length != bs.length) {
            return false;
        }
        for (int i = 0; i < as.length; ++i) {
            if (BridgedMethodFinder.isAssignable(as[i], bs[i])) continue;
            return false;
        }
        return true;
    }

    private static boolean isAssignable(Class<?> a, Class<?> b) {
        if (a == null && b == null) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        return a.isAssignableFrom(b);
    }
}

