/*
 * Decompiled with CFR 0.152.
 */
package org.dozer;

import java.io.InputStream;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import org.dozer.BeanFactory;
import org.dozer.CustomConverter;
import org.dozer.CustomFieldMapper;
import org.dozer.DozerBeanMapperBuilder;
import org.dozer.DozerEventListener;
import org.dozer.DozerInitializer;
import org.dozer.Mapper;
import org.dozer.MappingException;
import org.dozer.MappingProcessor;
import org.dozer.builder.DestBeanBuilderCreator;
import org.dozer.cache.CacheManager;
import org.dozer.cache.DozerCacheManager;
import org.dozer.cache.DozerCacheType;
import org.dozer.classmap.ClassMapBuilder;
import org.dozer.classmap.ClassMappings;
import org.dozer.classmap.Configuration;
import org.dozer.classmap.MappingFileData;
import org.dozer.classmap.generator.BeanMappingGenerator;
import org.dozer.config.BeanContainer;
import org.dozer.config.GlobalSettings;
import org.dozer.event.DozerEventManager;
import org.dozer.factory.DestBeanCreator;
import org.dozer.loader.CustomMappingsLoader;
import org.dozer.loader.LoadMappingsResult;
import org.dozer.loader.MappingsParser;
import org.dozer.loader.api.BeanMappingBuilder;
import org.dozer.loader.xml.MappingFileReader;
import org.dozer.loader.xml.MappingStreamReader;
import org.dozer.loader.xml.XMLParser;
import org.dozer.loader.xml.XMLParserFactory;
import org.dozer.metadata.DozerMappingMetadata;
import org.dozer.metadata.MappingMetadata;
import org.dozer.osgi.Activator;
import org.dozer.osgi.OSGiClassLoader;
import org.dozer.propertydescriptor.PropertyDescriptorFactory;
import org.dozer.stats.StatisticType;
import org.dozer.stats.StatisticsInterceptor;
import org.dozer.stats.StatisticsManager;
import org.dozer.stats.StatisticsManagerImpl;
import org.dozer.util.DefaultClassLoader;
import org.dozer.util.DozerClassLoader;
import org.dozer.util.MappingValidator;
import org.dozer.util.RuntimeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DozerBeanMapper
implements Mapper {
    private final Logger log = LoggerFactory.getLogger(DozerBeanMapper.class);
    private final AtomicBoolean initializing = new AtomicBoolean(false);
    private final CountDownLatch ready = new CountDownLatch(1);
    private final StatisticsManager statsMgr;
    private final GlobalSettings globalSettings;
    private final CustomMappingsLoader customMappingsLoader;
    private final XMLParserFactory xmlParserFactory;
    private final DozerInitializer dozerInitializer;
    private final BeanContainer beanContainer;
    private final XMLParser xmlParser;
    private final DestBeanCreator destBeanCreator;
    private final DestBeanBuilderCreator destBeanBuilderCreator;
    private final BeanMappingGenerator beanMappingGenerator;
    private final PropertyDescriptorFactory propertyDescriptorFactory;
    private final List<String> mappingFiles;
    private final List<CustomConverter> customConverters;
    private final List<MappingFileData> mappingsFileData;
    private final List<DozerEventListener> eventListeners;
    private final Map<String, CustomConverter> customConvertersWithId;
    private CustomFieldMapper customFieldMapper;
    private ClassMappings customMappings;
    private Configuration globalConfiguration;
    private final CacheManager cacheManager;
    private DozerEventManager eventManager;

    @Deprecated
    public DozerBeanMapper() {
        this(Collections.emptyList());
    }

    @Deprecated
    public DozerBeanMapper(List<String> mappingFiles) {
        DozerClassLoader classLoader = RuntimeUtils.isOSGi() ? new OSGiClassLoader(Activator.getBundle().getBundleContext()) : new DefaultClassLoader(DozerBeanMapperBuilder.class.getClassLoader());
        this.globalSettings = new GlobalSettings(classLoader);
        this.beanContainer = new BeanContainer();
        this.destBeanCreator = new DestBeanCreator(this.beanContainer);
        this.propertyDescriptorFactory = new PropertyDescriptorFactory();
        this.beanMappingGenerator = new BeanMappingGenerator(this.beanContainer, this.destBeanCreator, this.propertyDescriptorFactory);
        ClassMapBuilder classMapBuilder = new ClassMapBuilder(this.beanContainer, this.destBeanCreator, this.beanMappingGenerator, this.propertyDescriptorFactory);
        this.customMappingsLoader = new CustomMappingsLoader(new MappingsParser(this.beanContainer, this.destBeanCreator, this.propertyDescriptorFactory), classMapBuilder, this.beanContainer);
        this.xmlParserFactory = new XMLParserFactory(this.beanContainer);
        this.statsMgr = new StatisticsManagerImpl(this.globalSettings);
        this.dozerInitializer = new DozerInitializer();
        this.xmlParser = new XMLParser(this.beanContainer, this.destBeanCreator, this.propertyDescriptorFactory);
        this.destBeanBuilderCreator = new DestBeanBuilderCreator();
        this.cacheManager = new DozerCacheManager(this.statsMgr);
        this.mappingFiles = new ArrayList<String>(mappingFiles);
        this.customConverters = new ArrayList<CustomConverter>();
        this.mappingsFileData = new ArrayList<MappingFileData>();
        this.eventListeners = new ArrayList<DozerEventListener>();
        this.customConvertersWithId = new HashMap<String, CustomConverter>();
        this.init();
    }

    DozerBeanMapper(List<String> mappingFiles, GlobalSettings globalSettings, CustomMappingsLoader customMappingsLoader, XMLParserFactory xmlParserFactory, StatisticsManager statsMgr, DozerInitializer dozerInitializer, BeanContainer beanContainer, XMLParser xmlParser, DestBeanCreator destBeanCreator, DestBeanBuilderCreator destBeanBuilderCreator, BeanMappingGenerator beanMappingGenerator, PropertyDescriptorFactory propertyDescriptorFactory, List<CustomConverter> customConverters, List<MappingFileData> mappingsFileData, List<DozerEventListener> eventListeners, CustomFieldMapper customFieldMapper, Map<String, CustomConverter> customConvertersWithId) {
        this.globalSettings = globalSettings;
        this.customMappingsLoader = customMappingsLoader;
        this.xmlParserFactory = xmlParserFactory;
        this.statsMgr = statsMgr;
        this.cacheManager = new DozerCacheManager(statsMgr);
        this.dozerInitializer = dozerInitializer;
        this.beanContainer = beanContainer;
        this.xmlParser = xmlParser;
        this.destBeanCreator = destBeanCreator;
        this.destBeanBuilderCreator = destBeanBuilderCreator;
        this.beanMappingGenerator = beanMappingGenerator;
        this.propertyDescriptorFactory = propertyDescriptorFactory;
        this.customConverters = new ArrayList<CustomConverter>(customConverters);
        this.mappingsFileData = new ArrayList<MappingFileData>(mappingsFileData);
        this.eventListeners = new ArrayList<DozerEventListener>(eventListeners);
        this.mappingFiles = new ArrayList<String>(mappingFiles);
        this.customFieldMapper = customFieldMapper;
        this.customConvertersWithId = new HashMap<String, CustomConverter>(customConvertersWithId);
        this.init();
    }

    @Override
    public void map(Object source, Object destination, String mapId) throws MappingException {
        this.getMappingProcessor().map(source, destination, mapId);
    }

    @Override
    public <T> T map(Object source, Class<T> destinationClass, String mapId) throws MappingException {
        return this.getMappingProcessor().map(source, destinationClass, mapId);
    }

    @Override
    public <T> T map(Object source, Class<T> destinationClass) throws MappingException {
        return this.getMappingProcessor().map(source, destinationClass);
    }

    @Override
    public void map(Object source, Object destination) throws MappingException {
        this.getMappingProcessor().map(source, destination);
    }

    @Deprecated
    public List<String> getMappingFiles() {
        return Collections.unmodifiableList(this.mappingFiles);
    }

    @Deprecated
    public void setMappingFiles(List<String> mappingFileUrls) {
        this.checkIfInitialized();
        this.mappingFiles.clear();
        this.mappingFiles.addAll(mappingFileUrls);
    }

    @Deprecated
    public void setFactories(Map<String, BeanFactory> factories) {
        this.checkIfInitialized();
        this.destBeanCreator.setStoredFactories(factories);
    }

    @Deprecated
    public void setCustomConverters(List<CustomConverter> customConverters) {
        this.checkIfInitialized();
        this.customConverters.clear();
        this.customConverters.addAll(customConverters);
    }

    @Deprecated
    public List<CustomConverter> getCustomConverters() {
        return Collections.unmodifiableList(this.customConverters);
    }

    @Deprecated
    public Map<String, CustomConverter> getCustomConvertersWithId() {
        return Collections.unmodifiableMap(this.customConvertersWithId);
    }

    private void init() {
        this.dozerInitializer.init(this.globalSettings, this.statsMgr, this.beanContainer, this.destBeanBuilderCreator, this.beanMappingGenerator, this.propertyDescriptorFactory, this.destBeanCreator);
        this.log.info("Initializing a new instance of dozer bean mapper.");
        this.cacheManager.addCache(DozerCacheType.CONVERTER_BY_DEST_TYPE.name(), this.globalSettings.getConverterByDestTypeCacheMaxSize());
        this.cacheManager.addCache(DozerCacheType.SUPER_TYPE_CHECK.name(), this.globalSettings.getSuperTypesCacheMaxSize());
        this.statsMgr.increment(StatisticType.MAPPER_INSTANCES_COUNT);
    }

    public void destroy() {
        this.dozerInitializer.destroy(this.globalSettings);
    }

    protected Mapper getMappingProcessor() {
        this.initMappings();
        Mapper processor = new MappingProcessor(this.customMappings, this.globalConfiguration, this.cacheManager, this.statsMgr, this.customConverters, this.eventManager, this.customFieldMapper, this.customConvertersWithId, this.beanContainer, this.destBeanCreator, this.destBeanBuilderCreator, this.beanMappingGenerator, this.propertyDescriptorFactory);
        if (this.statsMgr.isStatisticsEnabled()) {
            processor = (Mapper)Proxy.newProxyInstance(processor.getClass().getClassLoader(), processor.getClass().getInterfaces(), (InvocationHandler)new StatisticsInterceptor(processor, this.statsMgr));
        }
        return processor;
    }

    void loadCustomMappings() {
        List<MappingFileData> xmlMappings = this.loadFromFiles(this.mappingFiles);
        ArrayList<MappingFileData> allMappings = new ArrayList<MappingFileData>();
        allMappings.addAll(xmlMappings);
        allMappings.addAll(this.mappingsFileData);
        LoadMappingsResult loadMappingsResult = this.customMappingsLoader.load(allMappings);
        this.customMappings = loadMappingsResult.getCustomMappings();
        this.globalConfiguration = loadMappingsResult.getGlobalConfiguration();
    }

    private List<MappingFileData> loadFromFiles(List<String> mappingFiles) {
        MappingFileReader mappingFileReader = new MappingFileReader(this.xmlParserFactory, this.xmlParser, this.beanContainer);
        ArrayList<MappingFileData> mappingFileDataList = new ArrayList<MappingFileData>();
        if (mappingFiles != null && mappingFiles.size() > 0) {
            this.log.info("Using the following xml files to load custom mappings for the bean mapper instance: {}", mappingFiles);
            for (String mappingFileName : mappingFiles) {
                this.log.info("Trying to find xml mapping file: {}", (Object)mappingFileName);
                URL url = MappingValidator.validateURL(mappingFileName, this.beanContainer);
                this.log.info("Using URL [" + url + "] to load custom xml mappings");
                MappingFileData mappingFileData = mappingFileReader.read(url);
                this.log.info("Successfully loaded custom xml mappings from URL: [{}]", (Object)url);
                mappingFileDataList.add(mappingFileData);
            }
        }
        return mappingFileDataList;
    }

    @Deprecated
    public void addMapping(InputStream xmlStream) {
        this.checkIfInitialized();
        MappingStreamReader fileReader = new MappingStreamReader(this.xmlParserFactory, this.xmlParser);
        MappingFileData mappingFileData = fileReader.read(xmlStream);
        this.mappingsFileData.add(mappingFileData);
    }

    @Deprecated
    public void addMapping(BeanMappingBuilder mappingBuilder) {
        this.checkIfInitialized();
        MappingFileData mappingFileData = mappingBuilder.build(this.beanContainer, this.destBeanCreator, this.propertyDescriptorFactory);
        this.mappingsFileData.add(mappingFileData);
    }

    @Deprecated
    public List<? extends DozerEventListener> getEventListeners() {
        return Collections.unmodifiableList(this.eventListeners);
    }

    @Deprecated
    public void setEventListeners(List<? extends DozerEventListener> eventListeners) {
        this.checkIfInitialized();
        this.eventListeners.clear();
        this.eventListeners.addAll(eventListeners);
    }

    @Deprecated
    public CustomFieldMapper getCustomFieldMapper() {
        return this.customFieldMapper;
    }

    @Deprecated
    public void setCustomFieldMapper(CustomFieldMapper customFieldMapper) {
        this.checkIfInitialized();
        this.customFieldMapper = customFieldMapper;
    }

    @Override
    public MappingMetadata getMappingMetadata() {
        this.initMappings();
        return new DozerMappingMetadata(this.customMappings);
    }

    @Deprecated
    public void setCustomConvertersWithId(Map<String, CustomConverter> customConvertersWithId) {
        this.checkIfInitialized();
        this.customConvertersWithId.clear();
        this.customConvertersWithId.putAll(customConvertersWithId);
    }

    private void checkIfInitialized() {
        if (this.ready.getCount() == 0L) {
            throw new MappingException("Dozer Bean Mapper is already initialized! Modify settings before calling map()");
        }
    }

    private void initMappings() {
        if (this.initializing.compareAndSet(false, true)) {
            try {
                this.loadCustomMappings();
                this.eventManager = new DozerEventManager(this.eventListeners);
            }
            catch (RuntimeException e) {
                this.initializing.set(false);
                throw e;
            }
            finally {
                this.ready.countDown();
            }
        }
        try {
            this.ready.await();
        }
        catch (InterruptedException e) {
            this.log.error("Thread interrupted: ", (Throwable)e);
            Thread.currentThread().interrupt();
        }
    }
}

