/*
 * Decompiled with CFR 0.152.
 */
package org.dozer.converters;

import java.lang.reflect.Method;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.commons.beanutils.Converter;
import org.apache.commons.lang3.StringUtils;
import org.dozer.converters.CalendarConverter;
import org.dozer.converters.DateConverter;
import org.dozer.converters.XMLGregorianCalendarConverter;
import org.dozer.util.MappingUtils;
import org.dozer.util.ReflectionUtils;

public class JAXBElementConverter
implements Converter {
    private static Object objectFactory;
    private static Class<?> objectFactoryClass;
    private String destObjClass;
    private String destFieldName;
    private DateFormat dateFormat;

    public JAXBElementConverter(String destObjClass, String destFieldName, DateFormat dateFormat) {
        this.destObjClass = destObjClass;
        this.destFieldName = destFieldName;
        this.dateFormat = dateFormat;
    }

    private static Object objectFactory(String destObjClass) {
        String objectFactoryClassName = destObjClass.substring(0, destObjClass.lastIndexOf(".")) + ".ObjectFactory";
        if (objectFactory == null || objectFactoryClass == null || !objectFactoryClass.getCanonicalName().equals(objectFactoryClassName)) {
            objectFactoryClass = MappingUtils.loadClass(objectFactoryClassName);
            objectFactory = ReflectionUtils.newInstance(objectFactoryClass);
        }
        return objectFactory;
    }

    public Object convert(Class type, Object value) {
        Object converter;
        Object factory = JAXBElementConverter.objectFactory(this.destObjClass);
        Class<?> factoryClass = factory.getClass();
        Class<?> destClass = value.getClass();
        Class<?> valueClass = value.getClass();
        String methodName = "create" + this.destObjClass.substring(this.destObjClass.lastIndexOf(".") + 1) + StringUtils.capitalize((String)this.destFieldName);
        Method method = null;
        try {
            Class<?>[] parameterTypes;
            method = ReflectionUtils.findAMethod(factoryClass, methodName);
            for (Class<?> parameterClass : parameterTypes = method.getParameterTypes()) {
                if (valueClass.equals(parameterClass)) continue;
                destClass = parameterClass;
                break;
            }
            Class[] paramTypes = new Class[]{destClass};
            method = ReflectionUtils.getMethod(factoryClass, methodName, paramTypes);
        }
        catch (NoSuchMethodException e) {
            MappingUtils.throwMappingException(e);
        }
        Object param = value;
        if (Date.class.isAssignableFrom(valueClass) && !destClass.equals(XMLGregorianCalendar.class)) {
            converter = new DateConverter(this.dateFormat);
            param = converter.convert(destClass, param);
        } else if (Calendar.class.isAssignableFrom(valueClass) && !destClass.equals(XMLGregorianCalendar.class)) {
            converter = new CalendarConverter(this.dateFormat);
            param = converter.convert(destClass, param);
        } else if (XMLGregorianCalendar.class.isAssignableFrom(valueClass) || XMLGregorianCalendar.class.isAssignableFrom(destClass)) {
            converter = new XMLGregorianCalendarConverter(this.dateFormat);
            param = converter.convert(destClass, param);
        }
        Object[] paramValues = new Object[]{param};
        Object result = ReflectionUtils.invoke(method, factory, paramValues);
        return result;
    }

    public String getBeanId() {
        Class<?> factoryClass = JAXBElementConverter.objectFactory(this.destObjClass).getClass();
        Class<?> destClass = null;
        String methodName = "create" + this.destObjClass.substring(this.destObjClass.lastIndexOf(".") + 1) + StringUtils.capitalize((String)this.destFieldName);
        try {
            Class<?>[] parameterTypes;
            Method method = ReflectionUtils.findAMethod(factoryClass, methodName);
            Class<?>[] classArray = parameterTypes = method.getParameterTypes();
            int n = classArray.length;
            int n2 = 0;
            if (n2 < n) {
                Class<?> parameterClass;
                destClass = parameterClass = classArray[n2];
            }
        }
        catch (NoSuchMethodException e) {
            MappingUtils.throwMappingException(e);
        }
        return destClass != null ? destClass.getCanonicalName() : null;
    }
}

