/*
 * Decompiled with CFR 0.152.
 */
package io.github.douglasjunior.androidSimpleTooltip;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.RectF;
import android.graphics.Xfermode;
import android.view.View;
import io.github.douglasjunior.androidSimpleTooltip.R;
import io.github.douglasjunior.androidSimpleTooltip.SimpleTooltipUtils;

@SuppressLint(value={"ViewConstructor"})
public class OverlayView
extends View {
    public static final int HIGHLIGHT_SHAPE_OVAL = 0;
    public static final int HIGHLIGHT_SHAPE_RECTANGULAR = 1;
    private static final int mDefaultOverlayAlphaRes = R.integer.simpletooltip_overlay_alpha;
    private View mAnchorView;
    private Bitmap bitmap;
    private boolean invalidated = true;
    private final int highlightShape;
    private final float mOffset;
    private final int overlayWindowBackground;

    OverlayView(Context context, View anchorView, int highlightShape, float offset, int overlayWindowBackground) {
        super(context);
        this.mAnchorView = anchorView;
        this.mOffset = offset;
        this.highlightShape = highlightShape;
        this.overlayWindowBackground = overlayWindowBackground;
    }

    protected void dispatchDraw(Canvas canvas) {
        if (this.invalidated || this.bitmap == null || this.bitmap.isRecycled()) {
            this.createWindowFrame();
        }
        if (this.bitmap != null && !this.bitmap.isRecycled()) {
            canvas.drawBitmap(this.bitmap, 0.0f, 0.0f, null);
        }
    }

    private void createWindowFrame() {
        int width = this.getMeasuredWidth();
        int height = this.getMeasuredHeight();
        if (width <= 0 || height <= 0) {
            return;
        }
        if (this.bitmap != null && !this.bitmap.isRecycled()) {
            this.bitmap.recycle();
        }
        this.bitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas osCanvas = new Canvas(this.bitmap);
        RectF outerRectangle = new RectF(0.0f, 0.0f, (float)width, (float)height);
        Paint paint = new Paint(1);
        paint.setColor(this.overlayWindowBackground);
        paint.setAntiAlias(true);
        paint.setAlpha(this.getResources().getInteger(mDefaultOverlayAlphaRes));
        osCanvas.drawRect(outerRectangle, paint);
        paint.setColor(0);
        paint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.SRC_OUT));
        RectF anchorRecr = SimpleTooltipUtils.calculeRectInWindow(this.mAnchorView);
        RectF overlayRecr = SimpleTooltipUtils.calculeRectInWindow(this);
        float left = anchorRecr.left - overlayRecr.left;
        float top = anchorRecr.top - overlayRecr.top;
        RectF rect = new RectF(left - this.mOffset, top - this.mOffset, left + (float)this.mAnchorView.getMeasuredWidth() + this.mOffset, top + (float)this.mAnchorView.getMeasuredHeight() + this.mOffset);
        if (this.highlightShape == 1) {
            osCanvas.drawRect(rect, paint);
        } else {
            osCanvas.drawOval(rect, paint);
        }
        this.invalidated = false;
    }

    public boolean isInEditMode() {
        return true;
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        super.onLayout(changed, l, t, r, b);
        this.invalidated = true;
    }

    public View getAnchorView() {
        return this.mAnchorView;
    }

    public void setAnchorView(View anchorView) {
        this.mAnchorView = anchorView;
        this.invalidate();
    }
}

