/*
 * Decompiled with CFR 0.152.
 */
package io.github.douglasjunior.androidSimpleTooltip;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.widget.FrameLayout;
import android.widget.TextView;
import androidx.annotation.ColorRes;
import androidx.annotation.DrawableRes;
import androidx.annotation.StyleRes;

public final class SimpleTooltipUtils {
    private SimpleTooltipUtils() {
    }

    public static RectF calculeRectOnScreen(View view) {
        int[] location = new int[2];
        view.getLocationOnScreen(location);
        return new RectF((float)location[0], (float)location[1], (float)(location[0] + view.getMeasuredWidth()), (float)(location[1] + view.getMeasuredHeight()));
    }

    public static RectF calculeRectInWindow(View view) {
        int[] location = new int[2];
        view.getLocationInWindow(location);
        return new RectF((float)location[0], (float)location[1], (float)(location[0] + view.getMeasuredWidth()), (float)(location[1] + view.getMeasuredHeight()));
    }

    public static float dpFromPx(float px) {
        return px / Resources.getSystem().getDisplayMetrics().density;
    }

    public static float pxFromDp(float dp) {
        return dp * Resources.getSystem().getDisplayMetrics().density;
    }

    public static void setWidth(View view, float width) {
        ViewGroup.LayoutParams params = view.getLayoutParams();
        if (params == null) {
            params = new ViewGroup.LayoutParams((int)width, view.getHeight());
        } else {
            params.width = (int)width;
        }
        view.setLayoutParams(params);
    }

    public static int tooltipGravityToArrowDirection(int tooltipGravity) {
        switch (tooltipGravity) {
            case 0x800003: {
                return 2;
            }
            case 0x800005: {
                return 0;
            }
            case 48: {
                return 3;
            }
            case 80: {
                return 1;
            }
            case 17: {
                return 1;
            }
        }
        throw new IllegalArgumentException("Gravity must have be CENTER, START, END, TOP or BOTTOM.");
    }

    public static void setX(View view, int x) {
        if (Build.VERSION.SDK_INT >= 11) {
            view.setX((float)x);
        } else {
            ViewGroup.MarginLayoutParams marginParams = SimpleTooltipUtils.getOrCreateMarginLayoutParams(view);
            marginParams.leftMargin = x - view.getLeft();
            view.setLayoutParams((ViewGroup.LayoutParams)marginParams);
        }
    }

    public static void setY(View view, int y) {
        if (Build.VERSION.SDK_INT >= 11) {
            view.setY((float)y);
        } else {
            ViewGroup.MarginLayoutParams marginParams = SimpleTooltipUtils.getOrCreateMarginLayoutParams(view);
            marginParams.topMargin = y - view.getTop();
            view.setLayoutParams((ViewGroup.LayoutParams)marginParams);
        }
    }

    private static ViewGroup.MarginLayoutParams getOrCreateMarginLayoutParams(View view) {
        ViewGroup.LayoutParams lp = view.getLayoutParams();
        if (lp != null) {
            if (lp instanceof ViewGroup.MarginLayoutParams) {
                return (ViewGroup.MarginLayoutParams)lp;
            }
            return new ViewGroup.MarginLayoutParams(lp);
        }
        return new ViewGroup.MarginLayoutParams(view.getWidth(), view.getHeight());
    }

    public static void removeOnGlobalLayoutListener(View view, ViewTreeObserver.OnGlobalLayoutListener listener) {
        if (Build.VERSION.SDK_INT >= 16) {
            view.getViewTreeObserver().removeOnGlobalLayoutListener(listener);
        } else {
            view.getViewTreeObserver().removeGlobalOnLayoutListener(listener);
        }
    }

    public static void setTextAppearance(TextView tv, @StyleRes int textAppearanceRes) {
        if (Build.VERSION.SDK_INT >= 23) {
            tv.setTextAppearance(textAppearanceRes);
        } else {
            tv.setTextAppearance(tv.getContext(), textAppearanceRes);
        }
    }

    public static int getColor(Context context, @ColorRes int colorRes) {
        if (Build.VERSION.SDK_INT >= 23) {
            return context.getColor(colorRes);
        }
        return context.getResources().getColor(colorRes);
    }

    public static Drawable getDrawable(Context context, @DrawableRes int drawableRes) {
        if (Build.VERSION.SDK_INT >= 23) {
            return context.getDrawable(drawableRes);
        }
        return context.getResources().getDrawable(drawableRes);
    }

    public static ViewGroup findFrameLayout(View anchorView) {
        ViewGroup rootView = (ViewGroup)anchorView.getRootView();
        if (rootView.getChildCount() == 1 && rootView.getChildAt(0) instanceof FrameLayout) {
            rootView = (ViewGroup)rootView.getChildAt(0);
        }
        return rootView;
    }
}

