/*
 * Decompiled with CFR 0.152.
 */
package io.github.douglasjunior.androidSimpleTooltip;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.PointF;
import android.graphics.RectF;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.support.annotation.ColorInt;
import android.support.annotation.DimenRes;
import android.support.annotation.DrawableRes;
import android.support.annotation.IdRes;
import android.support.annotation.LayoutRes;
import android.support.v4.content.ContextCompat;
import android.support.v7.widget.AppCompatPopupWindow;
import android.support.v7.widget.LinearLayoutCompat;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.widget.ImageView;
import android.widget.PopupWindow;
import android.widget.TextView;
import io.github.douglasjunior.androidSimpleTooltip.ArrowDrawable;
import io.github.douglasjunior.androidSimpleTooltip.OverlayView;
import io.github.douglasjunior.androidSimpleTooltip.R;
import io.github.douglasjunior.androidSimpleTooltip.SimpleTooltipUtils;

public class SimpleTooltip
implements PopupWindow.OnDismissListener {
    private static final int mDefaultPopupWindowStyleRes = 16842870;
    private static final int mDefaultTextAppearanceRes = R.style.simpletooltip_default;
    private static final int mDefaultBackgroundColorRes = R.color.simpletooltip_background;
    private static final int mDefaultTextColorRes = R.color.simpletooltip_text;
    private static final int mDefaultArrowColorRes = R.color.simpletooltip_arrow;
    private static final int mDefaultMarginRes = R.dimen.simpletooltip_margin;
    private static final int mDefaultPaddingRes = R.dimen.simpletooltip_padding;
    private static final int mDefaultAnimationPaddingRes = R.dimen.simpletooltip_animation_padding;
    private static final int mDefaultAnimationDurationRes = R.integer.simpletooltip_animation_duration;
    private static final int mDefaultArrowWidthRes = R.dimen.simpletooltip_arrow_width;
    private static final int mDefaultArrowHeightRes = R.dimen.simpletooltip_arrow_height;
    private final Context mContext;
    private final OnDismissListener mOnDismissListener;
    private final OnShowListener mOnShowListener;
    private AppCompatPopupWindow mPopupWindow;
    private final int mGravity;
    private final boolean mDismissOnInsideTouch;
    private final boolean mDismissOnOutsideTouch;
    private final boolean mModal;
    private View mContentView;
    private View mContentLayout;
    @IdRes
    private final int mTextViewId;
    private final String mText;
    private final View mAnchorView;
    private final boolean mTransparentOverlay;
    private final float mMaxWidth;
    private View mOverlay;
    private final boolean mShowArrow;
    private ImageView mArrowView;
    private Drawable mArrowDrawable;
    private final boolean mAnimated;
    private AnimatorSet mAnimator;
    private final int mMargin;
    private final int mPadding;
    private final int mAnimationPadding;
    private final long mAnimationDuration;
    private final float mArrowWidth;
    private final float mArrowHeight;
    private View.OnTouchListener mPopupWindowsTouchListener = new View.OnTouchListener(){

        public boolean onTouch(View v, MotionEvent event) {
            if (event.getX() > 0.0f && event.getX() < (float)v.getWidth() && event.getY() > 0.0f && event.getY() < (float)v.getHeight()) {
                System.out.println("DENTRO: " + event.toString());
                if (SimpleTooltip.this.mDismissOnInsideTouch) {
                    SimpleTooltip.this.dismiss();
                    return SimpleTooltip.this.mModal;
                }
                return false;
            }
            System.out.println("FORA: " + event.toString());
            return SimpleTooltip.this.mModal;
        }
    };
    private View.OnTouchListener mOverlayTouchListener = new View.OnTouchListener(){

        public boolean onTouch(View v, MotionEvent event) {
            System.out.println("OVERLAY");
            if (SimpleTooltip.this.mDismissOnOutsideTouch) {
                SimpleTooltip.this.dismiss();
            }
            return SimpleTooltip.this.mModal;
        }
    };
    private ViewTreeObserver.OnGlobalLayoutListener mLocationLayoutListener = new ViewTreeObserver.OnGlobalLayoutListener(){

        public void onGlobalLayout() {
            if (SimpleTooltip.this.mMaxWidth > 0.0f && (float)SimpleTooltip.this.mContentView.getWidth() > SimpleTooltip.this.mMaxWidth) {
                SimpleTooltipUtils.setWidth(SimpleTooltip.this.mContentView, SimpleTooltip.this.mMaxWidth);
                SimpleTooltip.this.mPopupWindow.update(-2, -2);
                return;
            }
            SimpleTooltipUtils.removeOnGlobalLayoutListener(SimpleTooltip.this.mPopupWindow.getContentView(), this);
            SimpleTooltip.this.mPopupWindow.getContentView().getViewTreeObserver().addOnGlobalLayoutListener(SimpleTooltip.this.mArrowLayoutListener);
            PointF location = SimpleTooltip.this.calculePopupLocation();
            SimpleTooltip.this.mPopupWindow.setClippingEnabled(true);
            SimpleTooltip.this.mPopupWindow.update((int)location.x, (int)location.y, SimpleTooltip.this.mPopupWindow.getWidth(), SimpleTooltip.this.mPopupWindow.getHeight());
            SimpleTooltip.this.mPopupWindow.getContentView().requestLayout();
        }
    };
    private ViewTreeObserver.OnGlobalLayoutListener mShowLayoutListener = new ViewTreeObserver.OnGlobalLayoutListener(){

        public void onGlobalLayout() {
            SimpleTooltipUtils.removeOnGlobalLayoutListener(SimpleTooltip.this.mPopupWindow.getContentView(), this);
            if (SimpleTooltip.this.mOnShowListener != null) {
                SimpleTooltip.this.mOnShowListener.onShow(SimpleTooltip.this);
            }
        }
    };
    private ViewTreeObserver.OnGlobalLayoutListener mArrowLayoutListener = new ViewTreeObserver.OnGlobalLayoutListener(){

        public void onGlobalLayout() {
            SimpleTooltipUtils.removeOnGlobalLayoutListener(SimpleTooltip.this.mPopupWindow.getContentView(), this);
            SimpleTooltip.this.mPopupWindow.getContentView().getViewTreeObserver().addOnGlobalLayoutListener(SimpleTooltip.this.mAnimationLayoutListener);
            SimpleTooltip.this.mPopupWindow.getContentView().getViewTreeObserver().addOnGlobalLayoutListener(SimpleTooltip.this.mShowLayoutListener);
            if (SimpleTooltip.this.mShowArrow) {
                float y;
                float x;
                RectF achorRect = SimpleTooltip.this.calculeAnchorRect();
                RectF contentViewRect = SimpleTooltipUtils.calculeRectOnScreen(SimpleTooltip.this.mContentLayout);
                if (SimpleTooltip.this.mGravity == 80 || SimpleTooltip.this.mGravity == 48) {
                    x = (float)SimpleTooltip.this.mContentLayout.getPaddingLeft() + SimpleTooltipUtils.pxFromDp(2.0f);
                    float centerX = contentViewRect.width() / 2.0f - (float)SimpleTooltip.this.mArrowView.getWidth() / 2.0f;
                    float newX = centerX - (contentViewRect.centerX() - achorRect.centerX());
                    if (newX > x) {
                        x = newX + (float)SimpleTooltip.this.mArrowView.getWidth() + x > contentViewRect.width() ? contentViewRect.width() - (float)SimpleTooltip.this.mArrowView.getWidth() - x : newX;
                    }
                    y = SimpleTooltip.this.mArrowView.getTop();
                    y += (float)(SimpleTooltip.this.mGravity == 48 ? -1 : 1);
                } else {
                    y = (float)SimpleTooltip.this.mContentLayout.getPaddingTop() + SimpleTooltipUtils.pxFromDp(2.0f);
                    float centerY = contentViewRect.height() / 2.0f - (float)SimpleTooltip.this.mArrowView.getHeight() / 2.0f;
                    float newY = centerY - (contentViewRect.centerY() - achorRect.centerY());
                    if (newY > y) {
                        y = newY + (float)SimpleTooltip.this.mArrowView.getHeight() + y > contentViewRect.height() ? contentViewRect.height() - (float)SimpleTooltip.this.mArrowView.getHeight() - y : newY;
                    }
                    x = SimpleTooltip.this.mArrowView.getLeft();
                    x += (float)(SimpleTooltip.this.mGravity == 3 ? -1 : 1);
                }
                SimpleTooltipUtils.setX((View)SimpleTooltip.this.mArrowView, (int)x);
                SimpleTooltipUtils.setY((View)SimpleTooltip.this.mArrowView, (int)y);
            }
            SimpleTooltip.this.mPopupWindow.getContentView().requestLayout();
        }
    };
    private ViewTreeObserver.OnGlobalLayoutListener mAnimationLayoutListener = new ViewTreeObserver.OnGlobalLayoutListener(){

        public void onGlobalLayout() {
            SimpleTooltipUtils.removeOnGlobalLayoutListener(SimpleTooltip.this.mPopupWindow.getContentView(), this);
            if (SimpleTooltip.this.mAnimated) {
                SimpleTooltip.this.startFloatingAnimation();
            }
            SimpleTooltip.this.mPopupWindow.getContentView().requestLayout();
        }
    };

    private SimpleTooltip(Builder builder) {
        this.mContext = builder.context;
        this.mGravity = builder.gravity;
        this.mDismissOnInsideTouch = builder.dismissOnInsideTouch;
        this.mDismissOnOutsideTouch = builder.dismissOnOutsideTouch;
        this.mModal = builder.modal;
        this.mContentView = builder.contentView;
        this.mTextViewId = builder.textViewId;
        this.mText = builder.text;
        this.mAnchorView = builder.anchorView;
        this.mTransparentOverlay = builder.transparentOverlay;
        this.mMaxWidth = builder.maxWidth;
        this.mShowArrow = builder.showArrow;
        this.mArrowWidth = builder.arrowWidth;
        this.mArrowHeight = builder.arrowHeight;
        this.mArrowDrawable = builder.arrowDrawable;
        this.mAnimated = builder.animated;
        this.mMargin = builder.margin;
        this.mPadding = builder.padding;
        this.mAnimationPadding = builder.animationPadding;
        this.mAnimationDuration = builder.animationDuration;
        this.mOnDismissListener = builder.onDismissListener;
        this.mOnShowListener = builder.onShowListener;
        this.init();
    }

    private void init() {
        this.configPopupWindow();
        this.configContentView();
    }

    private void configPopupWindow() {
        this.mPopupWindow = new AppCompatPopupWindow(this.mContext, null, 16842870);
        this.mPopupWindow.setWidth(-2);
        this.mPopupWindow.setHeight(-2);
        this.mPopupWindow.setBackgroundDrawable((Drawable)new ColorDrawable(0));
        this.mPopupWindow.setClippingEnabled(false);
        this.mPopupWindow.setOnDismissListener((PopupWindow.OnDismissListener)this);
        if (this.mDismissOnInsideTouch || this.mDismissOnOutsideTouch) {
            this.mPopupWindow.setTouchInterceptor(this.mPopupWindowsTouchListener);
        }
    }

    public void show() {
        final ViewGroup rootView = (ViewGroup)this.mAnchorView.getRootView();
        this.createOverlay(rootView);
        this.mContentLayout.getViewTreeObserver().addOnGlobalLayoutListener(this.mLocationLayoutListener);
        rootView.post(new Runnable(){

            @Override
            public void run() {
                SimpleTooltip.this.mPopupWindow.showAtLocation((View)rootView, 0, rootView.getWidth(), rootView.getHeight());
            }
        });
    }

    private void createOverlay(ViewGroup rootView) {
        this.mOverlay = this.mTransparentOverlay ? new View(this.mContext) : new OverlayView(this.mContext, this.mAnchorView);
        this.mOverlay.setLayoutParams(new ViewGroup.LayoutParams(-1, -1));
        this.mOverlay.setOnTouchListener(this.mOverlayTouchListener);
        rootView.addView(this.mOverlay);
    }

    private RectF calculeAnchorRect() {
        return SimpleTooltipUtils.calculeRectOnScreen(this.mAnchorView);
    }

    private PointF calculePopupLocation() {
        PointF location = new PointF();
        RectF anchorRect = this.calculeAnchorRect();
        PointF anchorCenter = new PointF(anchorRect.centerX(), anchorRect.centerY());
        switch (this.mGravity) {
            case 3: {
                location.x = anchorRect.left - (float)this.mPopupWindow.getContentView().getWidth() - (float)this.mMargin;
                location.y = anchorCenter.y - (float)this.mPopupWindow.getContentView().getHeight() / 2.0f;
                break;
            }
            case 5: {
                location.x = anchorRect.right + (float)this.mMargin;
                location.y = anchorCenter.y - (float)this.mPopupWindow.getContentView().getHeight() / 2.0f;
                break;
            }
            case 48: {
                location.x = anchorCenter.x - (float)this.mPopupWindow.getContentView().getWidth() / 2.0f;
                location.y = anchorRect.top - (float)this.mPopupWindow.getContentView().getHeight() - (float)this.mMargin;
                break;
            }
            case 80: {
                location.x = anchorCenter.x - (float)this.mPopupWindow.getContentView().getWidth() / 2.0f;
                location.y = anchorRect.bottom + (float)this.mMargin;
                break;
            }
            default: {
                throw new IllegalArgumentException("SimpleTooltip gravity must have be LEFT, RIGHT, TOP or BOTTOM.");
            }
        }
        return location;
    }

    private void configContentView() {
        TextView tv = this.mContentView instanceof TextView ? (TextView)this.mContentView : (TextView)this.mContentView.findViewById(this.mTextViewId);
        tv.setText((CharSequence)this.mText);
        this.mContentView.setPadding(this.mPadding, this.mPadding, this.mPadding, this.mPadding);
        if (this.mShowArrow) {
            this.mArrowView = new ImageView(this.mContext);
            this.mArrowView.setImageDrawable(this.mArrowDrawable);
            LinearLayoutCompat.LayoutParams arrowLayoutParams = this.mGravity == 48 || this.mGravity == 80 ? new LinearLayoutCompat.LayoutParams((int)this.mArrowWidth, (int)this.mArrowHeight, 0.0f) : new LinearLayoutCompat.LayoutParams((int)this.mArrowHeight, (int)this.mArrowWidth, 0.0f);
            this.mArrowView.setLayoutParams((ViewGroup.LayoutParams)arrowLayoutParams);
            LinearLayoutCompat linearLayout = new LinearLayoutCompat(this.mContext);
            linearLayout.setLayoutParams(new ViewGroup.LayoutParams(-2, -2));
            linearLayout.setOrientation(this.mGravity == 3 || this.mGravity == 5 ? 0 : 1);
            int padding = this.mAnimated ? this.mAnimationPadding : (int)SimpleTooltipUtils.pxFromDp(4.0f);
            linearLayout.setPadding(padding, padding, padding, padding);
            if (this.mGravity == 48 || this.mGravity == 3) {
                linearLayout.addView(this.mContentView);
                linearLayout.addView((View)this.mArrowView);
            } else {
                linearLayout.addView((View)this.mArrowView);
                linearLayout.addView(this.mContentView);
            }
            LinearLayoutCompat.LayoutParams contentViewParams = new LinearLayoutCompat.LayoutParams(-2, -2, 0.0f);
            contentViewParams.gravity = 17;
            this.mContentView.setLayoutParams((ViewGroup.LayoutParams)contentViewParams);
            this.mContentLayout = linearLayout;
        } else {
            this.mContentLayout = this.mContentView;
            this.mContentView.setLayoutParams(new ViewGroup.LayoutParams(-2, -2));
        }
        this.mPopupWindow.setContentView(this.mContentLayout);
    }

    public void dismiss() {
        if (this.mPopupWindow != null) {
            this.mPopupWindow.dismiss();
        }
        this.mPopupWindow = null;
    }

    public boolean isShowing() {
        return this.mPopupWindow != null && this.mPopupWindow.isShowing();
    }

    public <T extends View> T findViewById(int id) {
        return (T)this.mContentLayout.findViewById(id);
    }

    public void onDismiss() {
        if (Build.VERSION.SDK_INT >= 11 && this.mAnimator != null) {
            this.mAnimator.cancel();
        }
        if (this.mOverlay != null) {
            ((ViewGroup)this.mOverlay.getRootView()).removeView(this.mOverlay);
        }
        if (this.mOnDismissListener != null) {
            this.mOnDismissListener.onDismiss(this);
        }
    }

    @TargetApi(value=11)
    private synchronized void startFloatingAnimation() {
        String property = this.mGravity == 48 || this.mGravity == 80 ? "translationY" : "translationX";
        ObjectAnimator anim1 = ObjectAnimator.ofFloat((Object)this.mContentLayout, (String)property, (float[])new float[]{-this.mAnimationPadding, this.mAnimationPadding});
        anim1.setDuration(this.mAnimationDuration);
        anim1.setInterpolator((TimeInterpolator)new AccelerateDecelerateInterpolator());
        ObjectAnimator anim2 = ObjectAnimator.ofFloat((Object)this.mContentLayout, (String)property, (float[])new float[]{this.mAnimationPadding, -this.mAnimationPadding});
        anim2.setDuration(this.mAnimationDuration);
        anim2.setInterpolator((TimeInterpolator)new AccelerateDecelerateInterpolator());
        AnimatorSet set = new AnimatorSet();
        set.playSequentially(new Animator[]{anim1, anim2});
        set.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                if (SimpleTooltip.this.isShowing()) {
                    animation.start();
                }
            }
        });
        this.mAnimator = set;
        this.mAnimator.start();
    }

    public static class Builder {
        private Context context;
        private boolean dismissOnInsideTouch = true;
        private boolean dismissOnOutsideTouch = true;
        private boolean modal = false;
        private View contentView;
        @IdRes
        private int textViewId = 16908308;
        private String text = "";
        private View anchorView;
        private int gravity = 80;
        private boolean transparentOverlay = true;
        private float maxWidth;
        private boolean showArrow = true;
        private Drawable arrowDrawable;
        private boolean animated = false;
        private int margin;
        private int padding;
        private int animationPadding;
        private OnDismissListener onDismissListener;
        private OnShowListener onShowListener;
        private long animationDuration;
        private int backgroundColor;
        private int textColor;
        private int arrowColor;
        private float arrowHeight;
        private float arrowWidth;

        public Builder(Context context) {
            this.context = context;
        }

        public SimpleTooltip build() {
            this.validateArguments();
            if (this.backgroundColor == 0) {
                this.backgroundColor = ContextCompat.getColor((Context)this.context, (int)mDefaultBackgroundColorRes);
            }
            if (this.textColor == 0) {
                this.textColor = ContextCompat.getColor((Context)this.context, (int)mDefaultTextColorRes);
            }
            if (this.contentView == null) {
                TextView tv = new TextView(this.context);
                SimpleTooltipUtils.setTextAppearance(tv, mDefaultTextAppearanceRes);
                tv.setBackgroundColor(this.backgroundColor);
                tv.setTextColor(this.textColor);
                this.contentView = tv;
            }
            if (this.arrowColor == 0) {
                this.arrowColor = ContextCompat.getColor((Context)this.context, (int)mDefaultArrowColorRes);
            }
            if (this.arrowDrawable == null) {
                int arrowDirection = SimpleTooltipUtils.tooltipGravityToArrowDirection(this.gravity);
                this.arrowDrawable = new ArrowDrawable(this.arrowColor, arrowDirection);
            }
            if (this.margin == 0) {
                this.margin = this.context.getResources().getDimensionPixelSize(mDefaultMarginRes);
            }
            if (this.padding == 0) {
                this.padding = this.context.getResources().getDimensionPixelSize(mDefaultPaddingRes);
            }
            if (this.animationPadding == 0) {
                this.animationPadding = this.context.getResources().getDimensionPixelSize(mDefaultAnimationPaddingRes);
            }
            if (this.animationDuration == 0L) {
                this.animationDuration = this.context.getResources().getInteger(mDefaultAnimationDurationRes);
            }
            if (Build.VERSION.SDK_INT < 11) {
                this.animated = false;
            }
            if (this.showArrow) {
                if (this.arrowWidth == 0.0f) {
                    this.arrowWidth = this.context.getResources().getDimension(mDefaultArrowWidthRes);
                }
                if (this.arrowHeight == 0.0f) {
                    this.arrowHeight = this.context.getResources().getDimension(mDefaultArrowHeightRes);
                }
            }
            return new SimpleTooltip(this);
        }

        private void validateArguments() {
            if (this.context == null) {
                throw new IllegalArgumentException("Context not specified.");
            }
            if (this.anchorView == null) {
                throw new IllegalArgumentException("Anchor view not specified.");
            }
        }

        public Builder contentView(TextView textView) {
            this.contentView = textView;
            this.textViewId = 0;
            return this;
        }

        public Builder contentView(View contentView, @IdRes int textViewId) {
            this.contentView = contentView;
            this.textViewId = textViewId;
            return this;
        }

        public Builder contentView(@LayoutRes int contentViewId, @IdRes int textViewId) {
            LayoutInflater inflater = (LayoutInflater)this.context.getSystemService("layout_inflater");
            this.contentView = inflater.inflate(contentViewId, null, false);
            this.textViewId = textViewId;
            return this;
        }

        public Builder context(Context context) {
            this.context = context;
            return this;
        }

        public Builder dismissOnInsideTouch(boolean dismissOnInsideTouch) {
            this.dismissOnInsideTouch = dismissOnInsideTouch;
            return this;
        }

        public Builder dismissOnOutsideTouch(boolean dismissOnOutsideTouch) {
            this.dismissOnOutsideTouch = dismissOnOutsideTouch;
            return this;
        }

        public Builder modal(boolean modal) {
            this.modal = modal;
            return this;
        }

        public Builder text(String text) {
            this.text = text;
            return this;
        }

        public Builder anchorView(View anchorView) {
            this.anchorView = anchorView;
            return this;
        }

        public Builder gravity(int gravity) {
            this.gravity = gravity;
            return this;
        }

        public Builder transparentOverlay(boolean transparentOverlay) {
            this.transparentOverlay = transparentOverlay;
            return this;
        }

        public Builder maxWidth(@DimenRes int maxWidthRes) {
            this.maxWidth = this.context.getResources().getDimension(maxWidthRes);
            return this;
        }

        public Builder maxWidth(float maxWidth) {
            this.maxWidth = maxWidth;
            return this;
        }

        public Builder showArrow(boolean showArrow) {
            this.showArrow = showArrow;
            return this;
        }

        @TargetApi(value=11)
        public Builder animated(boolean animated) {
            this.animated = animated;
            return this;
        }

        @TargetApi(value=11)
        public Builder animationPadding(int animationPadding) {
            this.animationPadding = animationPadding;
            return this;
        }

        @TargetApi(value=11)
        public Builder animationDuration(long animationDuration) {
            this.animationDuration = animationDuration;
            return this;
        }

        public Builder arrowDrawable(Drawable arrowDrawable) {
            this.arrowDrawable = arrowDrawable;
            return this;
        }

        public Builder arrowDrawable(@DrawableRes int drawableRes) {
            this.arrowDrawable = ContextCompat.getDrawable((Context)this.context, (int)drawableRes);
            return this;
        }

        public Builder padding(int padding) {
            this.padding = padding;
            return this;
        }

        public Builder margin(int margin) {
            this.margin = margin;
            return this;
        }

        public Builder arrowColor(@ColorInt int arrowColor) {
            this.arrowColor = arrowColor;
            return this;
        }

        public Builder backgroundColor(@ColorInt int backgroundColor) {
            this.backgroundColor = backgroundColor;
            return this;
        }

        public Builder onDismissListener(OnDismissListener onDismissListener) {
            this.onDismissListener = onDismissListener;
            return this;
        }

        public Builder onShowListener(OnShowListener onShowListener) {
            this.onShowListener = onShowListener;
            return this;
        }

        public Builder textColor(int textColor) {
            this.textColor = textColor;
            return this;
        }

        public Builder arrowHeight(float arrowHeight) {
            this.arrowHeight = arrowHeight;
            return this;
        }

        public Builder arrowWidth(float arrowWidth) {
            this.arrowWidth = arrowWidth;
            return this;
        }
    }

    public static interface OnShowListener {
        public void onShow(SimpleTooltip var1);
    }

    public static interface OnDismissListener {
        public void onDismiss(SimpleTooltip var1);
    }
}

