/*
 * Decompiled with CFR 0.152.
 */
package io.github.douglasjunior.androidSimpleTooltip;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.RectF;
import android.graphics.Xfermode;
import android.view.View;
import io.github.douglasjunior.androidSimpleTooltip.R;
import io.github.douglasjunior.androidSimpleTooltip.SimpleTooltipUtils;

public class OverlayView
extends View {
    private static final int mDefaultOverlayCircleOffsetRes = R.dimen.simpletooltip_overlay_circle_offset;
    private static final int mDefaultOverlayAlphaRes = R.integer.simpletooltip_overlay_alpha;
    private View mAnchorView;
    private Bitmap bitmap;

    OverlayView(Context context, View anchorView) {
        super(context);
        this.mAnchorView = anchorView;
    }

    protected void dispatchDraw(Canvas canvas) {
        super.dispatchDraw(canvas);
        if (this.bitmap == null) {
            this.createWindowFrame();
        }
        canvas.drawBitmap(this.bitmap, 0.0f, 0.0f, null);
    }

    private void createWindowFrame() {
        this.bitmap = Bitmap.createBitmap((int)this.getWidth(), (int)this.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas osCanvas = new Canvas(this.bitmap);
        RectF outerRectangle = new RectF(0.0f, 0.0f, (float)this.getWidth(), (float)this.getHeight());
        Paint paint = new Paint(1);
        paint.setColor(-16777216);
        paint.setAntiAlias(true);
        paint.setAlpha(this.getResources().getInteger(mDefaultOverlayAlphaRes));
        osCanvas.drawRect(outerRectangle, paint);
        paint.setColor(0);
        paint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.SRC_OUT));
        RectF rect = SimpleTooltipUtils.calculeRectOnScreen(this.mAnchorView);
        float offset = this.getResources().getDimensionPixelSize(mDefaultOverlayCircleOffsetRes);
        rect.set(rect.left - offset, rect.top - offset, rect.right + offset, rect.bottom + offset);
        osCanvas.drawOval(rect, paint);
    }

    public boolean isInEditMode() {
        return true;
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        super.onLayout(changed, l, t, r, b);
        if (this.bitmap != null && !this.bitmap.isRecycled()) {
            this.bitmap.recycle();
        }
        this.bitmap = null;
    }

    public View getAnchorView() {
        return this.mAnchorView;
    }

    public void setAnchorView(View anchorView) {
        this.mAnchorView = anchorView;
        this.invalidate();
    }
}

