/*
 * Decompiled with CFR 0.152.
 */
package com.doublesymmetry.kotlinaudio.players;

import android.content.Context;
import com.doublesymmetry.kotlinaudio.models.AudioItem;
import com.doublesymmetry.kotlinaudio.models.AudioItemHolder;
import com.doublesymmetry.kotlinaudio.models.BufferConfig;
import com.doublesymmetry.kotlinaudio.models.CacheConfig;
import com.doublesymmetry.kotlinaudio.models.DefaultQueuedPlayerOptions;
import com.doublesymmetry.kotlinaudio.models.PlayerConfig;
import com.doublesymmetry.kotlinaudio.players.BaseAudioPlayer;
import com.doublesymmetry.kotlinaudio.players.components.MediaItemExtKt;
import com.google.android.exoplayer2.IllegalSeekPositionException;
import com.google.android.exoplayer2.MediaItem;
import com.google.android.exoplayer2.source.MediaSource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0011\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nJ\u000e\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020\u0010J\u0016\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020\u00102\u0006\u0010.\u001a\u00020/J\u0014\u0010+\u001a\u00020,2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00100\u0014J\u001c\u0010+\u001a\u00020,2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00100\u00142\u0006\u0010.\u001a\u00020/J\u001c\u0010+\u001a\u00020,2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00100\u00142\u0006\u00100\u001a\u00020\fJ\b\u00101\u001a\u00020,H\u0016J\b\u00102\u001a\u00020,H\u0016J\u000e\u00103\u001a\u00020,2\u0006\u00104\u001a\u00020\fJ\u0016\u00103\u001a\u00020,2\u0006\u00104\u001a\u00020\f2\u0006\u0010.\u001a\u00020/J\u0010\u00105\u001a\u00020,2\u0006\u0010-\u001a\u00020\u0010H\u0016J\u0018\u00105\u001a\u00020,2\u0006\u0010-\u001a\u00020\u00102\u0006\u0010.\u001a\u00020/H\u0016J\u0016\u00106\u001a\u00020,2\u0006\u00107\u001a\u00020\f2\u0006\u00108\u001a\u00020\fJ\u0006\u00109\u001a\u00020,J\u0006\u0010:\u001a\u00020,J\u000e\u0010;\u001a\u00020,2\u0006\u00104\u001a\u00020\fJ\u0014\u0010;\u001a\u00020,2\f\u0010<\u001a\b\u0012\u0004\u0012\u00020\f0\u0014J\u0006\u0010=\u001a\u00020,J\u0006\u0010>\u001a\u00020,J\u0016\u0010?\u001a\u00020,2\u0006\u00104\u001a\u00020\f2\u0006\u0010-\u001a\u00020\u0010R\u0011\u0010\u000b\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0016\u0010\u000f\u001a\u0004\u0018\u00010\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0017\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00100\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0013\u0010\u0017\u001a\u0004\u0018\u00010\f8F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0013\u0010\u001a\u001a\u0004\u0018\u00010\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u0012R\u0017\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00100\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u0016R\u0014\u0010\u001e\u001a\u00020\u001fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0013\u0010\"\u001a\u0004\u0018\u00010\f8F\u00a2\u0006\u0006\u001a\u0004\b#\u0010\u0019R\u0013\u0010$\u001a\u0004\u0018\u00010\u00108F\u00a2\u0006\u0006\u001a\u0004\b%\u0010\u0012R\u0017\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00100\u00148F\u00a2\u0006\u0006\u001a\u0004\b'\u0010\u0016R\u0014\u0010(\u001a\b\u0012\u0004\u0012\u00020*0)X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006@"}, d2={"Lcom/doublesymmetry/kotlinaudio/players/QueuedAudioPlayer;", "Lcom/doublesymmetry/kotlinaudio/players/BaseAudioPlayer;", "context", "Landroid/content/Context;", "playerConfig", "Lcom/doublesymmetry/kotlinaudio/models/PlayerConfig;", "bufferConfig", "Lcom/doublesymmetry/kotlinaudio/models/BufferConfig;", "cacheConfig", "Lcom/doublesymmetry/kotlinaudio/models/CacheConfig;", "(Landroid/content/Context;Lcom/doublesymmetry/kotlinaudio/models/PlayerConfig;Lcom/doublesymmetry/kotlinaudio/models/BufferConfig;Lcom/doublesymmetry/kotlinaudio/models/CacheConfig;)V", "currentIndex", "", "getCurrentIndex", "()I", "currentItem", "Lcom/doublesymmetry/kotlinaudio/models/AudioItem;", "getCurrentItem", "()Lcom/doublesymmetry/kotlinaudio/models/AudioItem;", "items", "", "getItems", "()Ljava/util/List;", "nextIndex", "getNextIndex", "()Ljava/lang/Integer;", "nextItem", "getNextItem", "nextItems", "getNextItems", "playerOptions", "Lcom/doublesymmetry/kotlinaudio/models/DefaultQueuedPlayerOptions;", "getPlayerOptions", "()Lcom/doublesymmetry/kotlinaudio/models/DefaultQueuedPlayerOptions;", "previousIndex", "getPreviousIndex", "previousItem", "getPreviousItem", "previousItems", "getPreviousItems", "queue", "Ljava/util/LinkedList;", "Lcom/google/android/exoplayer2/source/MediaSource;", "add", "", "item", "playWhenReady", "", "atIndex", "clear", "destroy", "jumpToItem", "index", "load", "move", "fromIndex", "toIndex", "next", "previous", "remove", "indexes", "removePreviousItems", "removeUpcomingItems", "replaceItem", "kotlin-audio_release"})
public final class QueuedAudioPlayer
extends BaseAudioPlayer {
    @NotNull
    private final LinkedList<MediaSource> queue;
    @NotNull
    private final DefaultQueuedPlayerOptions playerOptions;

    public QueuedAudioPlayer(@NotNull Context context, @NotNull PlayerConfig playerConfig, @Nullable BufferConfig bufferConfig, @Nullable CacheConfig cacheConfig) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)playerConfig, (String)"playerConfig");
        super(context, playerConfig, bufferConfig, cacheConfig);
        this.queue = new LinkedList();
        this.playerOptions = new DefaultQueuedPlayerOptions(this.getExoPlayer(), false, 2, null);
    }

    public /* synthetic */ QueuedAudioPlayer(Context context, PlayerConfig playerConfig, BufferConfig bufferConfig, CacheConfig cacheConfig, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            playerConfig = new PlayerConfig(false, false, false, null, null, 31, null);
        }
        if ((n & 4) != 0) {
            bufferConfig = null;
        }
        if ((n & 8) != 0) {
            cacheConfig = null;
        }
        this(context, playerConfig, bufferConfig, cacheConfig);
    }

    @Override
    @NotNull
    public DefaultQueuedPlayerOptions getPlayerOptions() {
        return this.playerOptions;
    }

    public final int getCurrentIndex() {
        return this.getExoPlayer().getCurrentMediaItemIndex();
    }

    @Override
    @Nullable
    public AudioItem getCurrentItem() {
        Object object = (MediaSource)CollectionsKt.getOrNull((List)this.queue, (int)this.getCurrentIndex());
        return object != null && (object = object.getMediaItem()) != null && (object = MediaItemExtKt.getAudioItemHolder((MediaItem)object)) != null ? ((AudioItemHolder)object).getAudioItem() : null;
    }

    @Nullable
    public final Integer getNextIndex() {
        return this.getExoPlayer().getNextMediaItemIndex() == -1 ? null : Integer.valueOf(this.getExoPlayer().getNextMediaItemIndex());
    }

    @Nullable
    public final Integer getPreviousIndex() {
        return this.getExoPlayer().getPreviousMediaItemIndex() == -1 ? null : Integer.valueOf(this.getExoPlayer().getPreviousMediaItemIndex());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<AudioItem> getItems() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.queue;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            MediaSource mediaSource = (MediaSource)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            MediaItem mediaItem = it.getMediaItem();
            Intrinsics.checkNotNullExpressionValue((Object)mediaItem, (String)"it.mediaItem");
            collection.add(MediaItemExtKt.getAudioItemHolder(mediaItem).getAudioItem());
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<AudioItem> getPreviousItems() {
        List list;
        if (this.queue.isEmpty()) {
            list = CollectionsKt.emptyList();
        } else {
            void $this$mapTo$iv$iv;
            List list2 = this.queue.subList(0, this.getExoPlayer().getCurrentMediaItemIndex());
            Intrinsics.checkNotNullExpressionValue(list2, (String)"queue\n                .s\u2026er.currentMediaItemIndex)");
            Iterable $this$map$iv = list2;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                MediaSource mediaSource = (MediaSource)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                MediaItem mediaItem = it.getMediaItem();
                Intrinsics.checkNotNullExpressionValue((Object)mediaItem, (String)"it.mediaItem");
                collection.add(MediaItemExtKt.getAudioItemHolder(mediaItem).getAudioItem());
            }
            list = (List)destination$iv$iv;
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<AudioItem> getNextItems() {
        List list;
        if (this.queue.isEmpty()) {
            list = CollectionsKt.emptyList();
        } else {
            void $this$mapTo$iv$iv;
            List list2 = this.queue.subList(this.getExoPlayer().getCurrentMediaItemIndex(), CollectionsKt.getLastIndex((List)this.queue));
            Intrinsics.checkNotNullExpressionValue(list2, (String)"queue\n                .s\u2026emIndex, queue.lastIndex)");
            Iterable $this$map$iv = list2;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                MediaSource mediaSource = (MediaSource)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                MediaItem mediaItem = it.getMediaItem();
                Intrinsics.checkNotNullExpressionValue((Object)mediaItem, (String)"it.mediaItem");
                collection.add(MediaItemExtKt.getAudioItemHolder(mediaItem).getAudioItem());
            }
            list = (List)destination$iv$iv;
        }
        return list;
    }

    @Nullable
    public final AudioItem getNextItem() {
        return (AudioItem)CollectionsKt.getOrNull(this.getItems(), (int)(this.getCurrentIndex() + 1));
    }

    @Nullable
    public final AudioItem getPreviousItem() {
        return (AudioItem)CollectionsKt.getOrNull(this.getItems(), (int)(this.getCurrentIndex() - 1));
    }

    @Override
    public void load(@NotNull AudioItem item, boolean playWhenReady) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        this.load(item);
        this.getExoPlayer().setPlayWhenReady(playWhenReady);
    }

    @Override
    public void load(@NotNull AudioItem item) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        if (this.queue.isEmpty()) {
            this.add(item);
        } else {
            MediaSource mediaSource = this.getMediaSourceFromAudioItem(item);
            this.queue.set(this.getCurrentIndex(), mediaSource);
            this.getExoPlayer().addMediaSource(this.getCurrentIndex() + 1, mediaSource);
            this.getExoPlayer().removeMediaItem(this.getCurrentIndex());
            this.getExoPlayer().seekTo(this.getCurrentIndex(), -9223372036854775807L);
            this.getExoPlayer().prepare();
        }
    }

    public final void add(@NotNull AudioItem item, boolean playWhenReady) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        this.getExoPlayer().setPlayWhenReady(playWhenReady);
        this.add(item);
    }

    public final void add(@NotNull AudioItem item) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        MediaSource mediaSource = this.getMediaSourceFromAudioItem(item);
        this.queue.add(mediaSource);
        this.getExoPlayer().addMediaSource(mediaSource);
        this.getExoPlayer().prepare();
    }

    public final void add(@NotNull List<? extends AudioItem> items, boolean playWhenReady) {
        Intrinsics.checkNotNullParameter(items, (String)"items");
        this.getExoPlayer().setPlayWhenReady(playWhenReady);
        this.add(items);
    }

    /*
     * WARNING - void declaration
     */
    public final void add(@NotNull List<? extends AudioItem> items) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(items, (String)"items");
        Iterable $this$map$iv = items;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            AudioItem audioItem = (AudioItem)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.getMediaSourceFromAudioItem((AudioItem)it));
        }
        List mediaSources = (List)destination$iv$iv;
        this.queue.addAll(mediaSources);
        this.getExoPlayer().addMediaSources(mediaSources);
        this.getExoPlayer().prepare();
    }

    /*
     * WARNING - void declaration
     */
    public final void add(@NotNull List<? extends AudioItem> items, int atIndex) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(items, (String)"items");
        Iterable $this$map$iv = items;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            AudioItem audioItem = (AudioItem)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.getMediaSourceFromAudioItem((AudioItem)it));
        }
        List mediaSources = (List)destination$iv$iv;
        this.queue.addAll(atIndex, mediaSources);
        this.getExoPlayer().addMediaSources(atIndex, mediaSources);
        this.getExoPlayer().prepare();
    }

    public final void remove(int index) {
        this.queue.remove(index);
        this.getExoPlayer().removeMediaItem(index);
    }

    public final void remove(@NotNull List<Integer> indexes) {
        Intrinsics.checkNotNullParameter(indexes, (String)"indexes");
        List sorted = CollectionsKt.toMutableList((Collection)indexes);
        CollectionsKt.sortDescending((List)sorted);
        Iterable $this$forEach$iv = sorted;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            int it = ((Number)element$iv).intValue();
            boolean bl = false;
            this.remove(it);
        }
    }

    public final void next() {
        this.getExoPlayer().seekToNextMediaItem();
        this.getExoPlayer().prepare();
    }

    public final void previous() {
        this.getExoPlayer().seekToPreviousMediaItem();
        this.getExoPlayer().prepare();
    }

    public final void move(int fromIndex, int toIndex) {
        this.getExoPlayer().moveMediaItem(fromIndex, toIndex);
        MediaSource mediaSource = this.queue.get(fromIndex);
        Intrinsics.checkNotNullExpressionValue((Object)mediaSource, (String)"queue[fromIndex]");
        MediaSource item = mediaSource;
        this.queue.remove(fromIndex);
        this.queue.add(Math.max(0, Math.min(this.getItems().size(), toIndex > fromIndex ? toIndex : toIndex - 1)), item);
    }

    public final void jumpToItem(int index, boolean playWhenReady) {
        this.getExoPlayer().setPlayWhenReady(playWhenReady);
        this.jumpToItem(index);
    }

    public final void jumpToItem(int index) {
        try {
            this.getExoPlayer().seekTo(index, -9223372036854775807L);
            this.getExoPlayer().prepare();
        }
        catch (IllegalSeekPositionException e) {
            throw new Error("This item index " + index + " does not exist. The size of the queue is " + this.queue.size() + " items.");
        }
    }

    public final void replaceItem(int index, @NotNull AudioItem item) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        MediaSource mediaSource = this.getMediaSourceFromAudioItem(item);
        this.queue.set(index, mediaSource);
        if (index == this.getCurrentIndex()) {
            this.updateNotificationIfNecessary$kotlin_audio_release(item);
        }
    }

    public final void removeUpcomingItems() {
        if (CollectionsKt.getLastIndex((List)this.queue) == -1 || this.getCurrentIndex() == -1) {
            return;
        }
        int lastIndex = CollectionsKt.getLastIndex((List)this.queue) + 1;
        int fromIndex = this.getCurrentIndex() + 1;
        this.getExoPlayer().removeMediaItems(fromIndex, lastIndex);
        this.queue.subList(fromIndex, lastIndex).clear();
    }

    public final void removePreviousItems() {
        this.getExoPlayer().removeMediaItems(0, this.getCurrentIndex());
        this.queue.subList(0, this.getCurrentIndex()).clear();
    }

    @Override
    public void destroy() {
        this.queue.clear();
        super.destroy();
    }

    @Override
    public void clear() {
        this.queue.clear();
        super.clear();
    }
}

