/*
 * Decompiled with CFR 0.152.
 */
package com.donkingliang.imageselector.model;

import android.content.ContentResolver;
import android.content.Context;
import android.database.ContentObserver;
import android.database.Cursor;
import android.net.Uri;
import android.provider.MediaStore;
import androidx.core.content.ContextCompat;
import com.donkingliang.imageselector.R;
import com.donkingliang.imageselector.entry.Folder;
import com.donkingliang.imageselector.entry.Image;
import com.donkingliang.imageselector.utils.ImageUtil;
import com.donkingliang.imageselector.utils.StringUtils;
import com.donkingliang.imageselector.utils.UriUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class ImageModel {
    private static ArrayList<Folder> cacheImageList = null;
    private static boolean isNeedCache = false;
    private static PhotoContentObserver observer;

    public static void preloadAndRegisterContentObserver(Context context) {
        isNeedCache = true;
        if (observer == null) {
            observer = new PhotoContentObserver(context.getApplicationContext());
            context.getApplicationContext().getContentResolver().registerContentObserver(MediaStore.Images.Media.EXTERNAL_CONTENT_URI, true, (ContentObserver)observer);
        }
        ImageModel.preload(context);
    }

    private static void preload(Context context) {
        int hasWriteExternalPermission = ContextCompat.checkSelfPermission((Context)context, (String)"android.permission.WRITE_EXTERNAL_STORAGE");
        if (hasWriteExternalPermission == 0) {
            ImageModel.loadImageForSDCard(context, true, null);
        }
    }

    public static void clearCache(Context context) {
        isNeedCache = false;
        if (observer != null) {
            context.getApplicationContext().getContentResolver().unregisterContentObserver((ContentObserver)observer);
            observer = null;
        }
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Class<ImageModel> clazz = ImageModel.class;
                synchronized (ImageModel.class) {
                    if (cacheImageList != null) {
                        cacheImageList.clear();
                        cacheImageList = null;
                    }
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return;
                }
            }
        }).start();
    }

    public static void loadImageForSDCard(Context context, DataCallback callback) {
        ImageModel.loadImageForSDCard(context, false, callback);
    }

    private static void loadImageForSDCard(final Context context, final boolean isPreload, final DataCallback callback) {
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Class<ImageModel> clazz = ImageModel.class;
                synchronized (ImageModel.class) {
                    String imageCacheDir = ImageUtil.getImageCacheDir(context);
                    ArrayList folders = null;
                    if (cacheImageList == null || isPreload) {
                        ArrayList imageList = ImageModel.loadImage(context);
                        Collections.sort(imageList, new Comparator<Image>(){

                            @Override
                            public int compare(Image image, Image t1) {
                                if (image.getTime() > t1.getTime()) {
                                    return 1;
                                }
                                if (image.getTime() < t1.getTime()) {
                                    return -1;
                                }
                                return 0;
                            }
                        });
                        ArrayList<Image> images = new ArrayList<Image>();
                        for (Image image : imageList) {
                            boolean exists;
                            boolean bl = exists = !"downloading".equals(ImageModel.getExtensionName(image.getPath())) && ImageModel.checkImgExists(image.getPath());
                            boolean isCutImage = ImageUtil.isCutImage(imageCacheDir, image.getPath());
                            if (isCutImage || !exists) continue;
                            images.add(image);
                        }
                        Collections.reverse(images);
                        folders = ImageModel.splitFolder(context, images);
                        if (isNeedCache) {
                            cacheImageList = folders;
                        }
                    } else {
                        folders = cacheImageList;
                    }
                    if (callback != null) {
                        callback.onSuccess(folders);
                    }
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return;
                }
            }
        }).start();
    }

    private static synchronized ArrayList<Image> loadImage(Context context) {
        Uri mImageUri = MediaStore.Images.Media.EXTERNAL_CONTENT_URI;
        ContentResolver mContentResolver = context.getContentResolver();
        Cursor mCursor = mContentResolver.query(mImageUri, new String[]{"_data", "_display_name", "date_added", "_id", "mime_type", "_size"}, "_size>0", null, "date_added DESC");
        ArrayList<Image> images = new ArrayList<Image>();
        if (mCursor != null) {
            while (mCursor.moveToNext()) {
                long id2 = mCursor.getLong(mCursor.getColumnIndex("_id"));
                String path = mCursor.getString(mCursor.getColumnIndex("_data"));
                String name = mCursor.getString(mCursor.getColumnIndex("_display_name"));
                long time = mCursor.getLong(mCursor.getColumnIndex("date_added"));
                if (String.valueOf(time).length() < 13) {
                    time *= 1000L;
                }
                String mimeType = mCursor.getString(mCursor.getColumnIndex("mime_type"));
                Uri uri = MediaStore.Images.Media.EXTERNAL_CONTENT_URI.buildUpon().appendPath(String.valueOf(id2)).build();
                images.add(new Image(path, time, name, mimeType, uri));
            }
            mCursor.close();
        }
        return images;
    }

    private static boolean checkImgExists(String filePath) {
        return new File(filePath).exists();
    }

    private static String getPathForAndroidQ(Context context, long id2) {
        return UriUtils.getPathForUri(context, MediaStore.Images.Media.EXTERNAL_CONTENT_URI.buildUpon().appendPath(String.valueOf(id2)).build());
    }

    private static ArrayList<Folder> splitFolder(Context context, ArrayList<Image> images) {
        ArrayList<Folder> folders = new ArrayList<Folder>();
        folders.add(new Folder(context.getString(R.string.selector_all_image), images));
        if (images != null && !images.isEmpty()) {
            int size = images.size();
            for (int i = 0; i < size; ++i) {
                String path = images.get(i).getPath();
                String name = ImageModel.getFolderName(path);
                if (!StringUtils.isNotEmptyString(name)) continue;
                Folder folder = ImageModel.getFolder(name, folders);
                folder.addImage(images.get(i));
            }
        }
        return folders;
    }

    public static String getExtensionName(String filename) {
        int dot;
        if (filename != null && filename.length() > 0 && (dot = filename.lastIndexOf(46)) > -1 && dot < filename.length() - 1) {
            return filename.substring(dot + 1);
        }
        return "";
    }

    private static String getFolderName(String path) {
        String[] strings;
        if (StringUtils.isNotEmptyString(path) && (strings = path.split(File.separator)).length >= 2) {
            return strings[strings.length - 2];
        }
        return "";
    }

    private static Folder getFolder(String name, List<Folder> folders) {
        if (!folders.isEmpty()) {
            int size = folders.size();
            for (int i = 0; i < size; ++i) {
                Folder folder = folders.get(i);
                if (!name.equals(folder.getName())) continue;
                return folder;
            }
        }
        Folder newFolder = new Folder(name);
        folders.add(newFolder);
        return newFolder;
    }

    private static class PhotoContentObserver
    extends ContentObserver {
        private Context context;

        public PhotoContentObserver(Context appContext) {
            super(null);
            this.context = appContext;
        }

        public void onChange(boolean selfChange, Uri uri) {
            super.onChange(selfChange, uri);
            ImageModel.preload(this.context);
        }
    }

    public static interface DataCallback {
        public void onSuccess(ArrayList<Folder> var1);
    }
}

