/*
 * Decompiled with CFR 0.152.
 */
package com.donkingliang.imageselector.adapter;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Matrix;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.viewpager.widget.PagerAdapter;
import com.bumptech.glide.Glide;
import com.bumptech.glide.RequestBuilder;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.bumptech.glide.request.RequestOptions;
import com.bumptech.glide.request.target.SimpleTarget;
import com.bumptech.glide.request.target.Target;
import com.bumptech.glide.request.transition.Transition;
import com.donkingliang.imageselector.entry.Image;
import com.donkingliang.imageselector.utils.ImageUtil;
import com.donkingliang.imageselector.utils.VersionUtils;
import com.github.chrisbanes.photoview.PhotoView;
import com.github.chrisbanes.photoview.PhotoViewAttacher;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

public class ImagePagerAdapter
extends PagerAdapter {
    private Context mContext;
    private List<PhotoView> viewList = new ArrayList<PhotoView>(4);
    List<Image> mImgList;
    private OnItemClickListener mListener;
    private boolean isAndroidQ = VersionUtils.isAndroidQ();

    public ImagePagerAdapter(Context context, List<Image> imgList) {
        this.mContext = context;
        this.createImageViews();
        this.mImgList = imgList;
    }

    private void createImageViews() {
        for (int i = 0; i < 4; ++i) {
            PhotoView imageView = new PhotoView(this.mContext);
            imageView.setAdjustViewBounds(true);
            this.viewList.add(imageView);
        }
    }

    public int getCount() {
        return this.mImgList == null ? 0 : this.mImgList.size();
    }

    public boolean isViewFromObject(View view, Object object) {
        return view == object;
    }

    public void destroyItem(ViewGroup container, int position, Object object) {
        if (object instanceof PhotoView) {
            PhotoView view = (PhotoView)object;
            view.setImageDrawable(null);
            this.viewList.add(view);
            container.removeView((View)view);
        }
    }

    public Object instantiateItem(ViewGroup container, final int position) {
        final PhotoView currentView = this.viewList.remove(0);
        final Image image = this.mImgList.get(position);
        container.addView((View)currentView);
        if (image.isGif()) {
            currentView.setScaleType(ImageView.ScaleType.FIT_CENTER);
            ((RequestBuilder)Glide.with((Context)this.mContext).load(this.isAndroidQ ? image.getUri() : image.getPath()).apply(new RequestOptions().diskCacheStrategy(DiskCacheStrategy.NONE)).override(720, 1080)).into((ImageView)currentView);
        } else {
            Glide.with((Context)this.mContext).asBitmap().apply(new RequestOptions().diskCacheStrategy(DiskCacheStrategy.NONE)).load(this.isAndroidQ ? image.getUri() : image.getPath()).into((Target)new SimpleTarget<Bitmap>(720, 1080){

                public void onResourceReady(@NonNull Bitmap resource, @Nullable Transition<? super Bitmap> transition) {
                    int bw = resource.getWidth();
                    int bh = resource.getHeight();
                    if (bw > 4096 || bh > 4096) {
                        Bitmap bitmap = ImageUtil.zoomBitmap(resource, 4096, 4096);
                        ImagePagerAdapter.this.setBitmap(currentView, bitmap);
                    } else {
                        ImagePagerAdapter.this.setBitmap(currentView, resource);
                    }
                }
            });
        }
        currentView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (ImagePagerAdapter.this.mListener != null) {
                    ImagePagerAdapter.this.mListener.onItemClick(position, image);
                }
            }
        });
        return currentView;
    }

    private void setBitmap(PhotoView imageView, Bitmap bitmap) {
        imageView.setImageBitmap(bitmap);
        if (bitmap != null) {
            int bw = bitmap.getWidth();
            int bh = bitmap.getHeight();
            int vw = imageView.getWidth();
            int vh = imageView.getHeight();
            if (bw != 0 && bh != 0 && vw != 0 && vh != 0) {
                if (1.0f * (float)bh / (float)bw > 1.0f * (float)vh / (float)vw) {
                    imageView.setScaleType(ImageView.ScaleType.CENTER_CROP);
                    float offset = (1.0f * (float)bh * (float)vw / (float)bw - (float)vh) / 2.0f;
                    this.adjustOffset(imageView, offset);
                } else {
                    imageView.setScaleType(ImageView.ScaleType.FIT_CENTER);
                }
            }
        }
    }

    public void setOnItemClickListener(OnItemClickListener l) {
        this.mListener = l;
    }

    private void adjustOffset(PhotoView view, float offset) {
        PhotoViewAttacher attacher = view.getAttacher();
        try {
            Field field = PhotoViewAttacher.class.getDeclaredField("mBaseMatrix");
            field.setAccessible(true);
            Matrix matrix = (Matrix)field.get(attacher);
            matrix.postTranslate(0.0f, offset);
            Method method = PhotoViewAttacher.class.getDeclaredMethod("resetMatrix", new Class[0]);
            method.setAccessible(true);
            method.invoke((Object)attacher, new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static interface OnItemClickListener {
        public void onItemClick(int var1, Image var2);
    }
}

