/*
 * Decompiled with CFR 0.152.
 */
package com.donkingliang.imageselector.adapter;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import androidx.recyclerview.widget.RecyclerView;
import com.bumptech.glide.Glide;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.bumptech.glide.request.RequestOptions;
import com.donkingliang.imageselector.R;
import com.donkingliang.imageselector.entry.Image;
import com.donkingliang.imageselector.utils.VersionUtils;
import java.util.ArrayList;

public class ImageAdapter
extends RecyclerView.Adapter<ViewHolder> {
    private Context mContext;
    private ArrayList<Image> mImages;
    private LayoutInflater mInflater;
    private ArrayList<Image> mSelectImages = new ArrayList();
    private OnImageSelectListener mSelectListener;
    private OnItemClickListener mItemClickListener;
    private int mMaxCount;
    private boolean isSingle;
    private boolean isViewImage;
    private static final int TYPE_CAMERA = 1;
    private static final int TYPE_IMAGE = 2;
    private boolean useCamera;
    private boolean isAndroidQ = VersionUtils.isAndroidQ();

    public ImageAdapter(Context context, int maxCount, boolean isSingle, boolean isViewImage) {
        this.mContext = context;
        this.mInflater = LayoutInflater.from((Context)this.mContext);
        this.mMaxCount = maxCount;
        this.isSingle = isSingle;
        this.isViewImage = isViewImage;
    }

    public ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        if (viewType == 2) {
            View view = this.mInflater.inflate(R.layout.adapter_images_item, parent, false);
            return new ViewHolder(view);
        }
        View view = this.mInflater.inflate(R.layout.adapter_camera, parent, false);
        return new ViewHolder(view);
    }

    public void onBindViewHolder(final ViewHolder holder, int position) {
        if (this.getItemViewType(position) == 2) {
            final Image image = this.getImage(position);
            Glide.with((Context)this.mContext).load(this.isAndroidQ ? image.getUri() : image.getPath()).apply(new RequestOptions().diskCacheStrategy(DiskCacheStrategy.NONE)).into(holder.ivImage);
            this.setItemSelect(holder, this.mSelectImages.contains(image));
            holder.ivGif.setVisibility(image.isGif() ? 0 : 8);
            holder.ivSelectIcon.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    ImageAdapter.this.checkedImage(holder, image);
                }
            });
            holder.itemView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (ImageAdapter.this.isViewImage) {
                        if (ImageAdapter.this.mItemClickListener != null) {
                            int p = holder.getAdapterPosition();
                            ImageAdapter.this.mItemClickListener.OnItemClick(image, ImageAdapter.this.useCamera ? p - 1 : p);
                        }
                    } else {
                        ImageAdapter.this.checkedImage(holder, image);
                    }
                }
            });
        } else if (this.getItemViewType(position) == 1) {
            holder.itemView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (ImageAdapter.this.mItemClickListener != null) {
                        ImageAdapter.this.mItemClickListener.OnCameraClick();
                    }
                }
            });
        }
    }

    public int getItemViewType(int position) {
        if (this.useCamera && position == 0) {
            return 1;
        }
        return 2;
    }

    private void checkedImage(ViewHolder holder, Image image) {
        if (this.mSelectImages.contains(image)) {
            this.unSelectImage(image);
            this.setItemSelect(holder, false);
        } else if (this.isSingle) {
            this.clearImageSelect();
            this.selectImage(image);
            this.setItemSelect(holder, true);
        } else if (this.mMaxCount <= 0 || this.mSelectImages.size() < this.mMaxCount) {
            this.selectImage(image);
            this.setItemSelect(holder, true);
        }
    }

    private void selectImage(Image image) {
        this.mSelectImages.add(image);
        if (this.mSelectListener != null) {
            this.mSelectListener.OnImageSelect(image, true, this.mSelectImages.size());
        }
    }

    private void unSelectImage(Image image) {
        this.mSelectImages.remove(image);
        if (this.mSelectListener != null) {
            this.mSelectListener.OnImageSelect(image, false, this.mSelectImages.size());
        }
    }

    public int getItemCount() {
        return this.useCamera ? this.getImageCount() + 1 : this.getImageCount();
    }

    private int getImageCount() {
        return this.mImages == null ? 0 : this.mImages.size();
    }

    public ArrayList<Image> getData() {
        return this.mImages;
    }

    public void refresh(ArrayList<Image> data, boolean useCamera) {
        this.mImages = data;
        this.useCamera = useCamera;
        this.notifyDataSetChanged();
    }

    private Image getImage(int position) {
        return this.mImages.get(this.useCamera ? position - 1 : position);
    }

    public Image getFirstVisibleImage(int firstVisibleItem) {
        if (this.mImages != null && !this.mImages.isEmpty()) {
            if (this.useCamera) {
                return this.mImages.get(firstVisibleItem > 0 ? firstVisibleItem - 1 : 0);
            }
            return this.mImages.get(firstVisibleItem < 0 ? 0 : firstVisibleItem);
        }
        return null;
    }

    private void setItemSelect(ViewHolder holder, boolean isSelect) {
        if (isSelect) {
            holder.ivSelectIcon.setImageResource(R.drawable.icon_image_select);
            holder.ivMasking.setAlpha(0.5f);
        } else {
            holder.ivSelectIcon.setImageResource(R.drawable.icon_image_un_select);
            holder.ivMasking.setAlpha(0.2f);
        }
    }

    private void clearImageSelect() {
        if (this.mImages != null && this.mSelectImages.size() == 1) {
            int index = this.mImages.indexOf(this.mSelectImages.get(0));
            this.mSelectImages.clear();
            if (index != -1) {
                this.notifyItemChanged(this.useCamera ? index + 1 : index);
            }
        }
    }

    public void setSelectedImages(ArrayList<String> selected) {
        if (this.mImages != null && selected != null) {
            block0: for (String path : selected) {
                if (this.isFull()) {
                    return;
                }
                for (Image image : this.mImages) {
                    if (!path.equals(image.getPath())) continue;
                    if (this.mSelectImages.contains(image)) continue block0;
                    this.mSelectImages.add(image);
                    continue block0;
                }
            }
            this.notifyDataSetChanged();
        }
    }

    private boolean isFull() {
        if (this.isSingle && this.mSelectImages.size() == 1) {
            return true;
        }
        return this.mMaxCount > 0 && this.mSelectImages.size() == this.mMaxCount;
    }

    public ArrayList<Image> getSelectImages() {
        return this.mSelectImages;
    }

    public void setOnImageSelectListener(OnImageSelectListener listener) {
        this.mSelectListener = listener;
    }

    public void setOnItemClickListener(OnItemClickListener listener) {
        this.mItemClickListener = listener;
    }

    public static interface OnItemClickListener {
        public void OnItemClick(Image var1, int var2);

        public void OnCameraClick();
    }

    public static interface OnImageSelectListener {
        public void OnImageSelect(Image var1, boolean var2, int var3);
    }

    static class ViewHolder
    extends RecyclerView.ViewHolder {
        ImageView ivImage;
        ImageView ivSelectIcon;
        ImageView ivMasking;
        ImageView ivGif;
        ImageView ivCamera;

        public ViewHolder(View itemView) {
            super(itemView);
            this.ivImage = (ImageView)itemView.findViewById(R.id.iv_image);
            this.ivSelectIcon = (ImageView)itemView.findViewById(R.id.iv_select);
            this.ivMasking = (ImageView)itemView.findViewById(R.id.iv_masking);
            this.ivGif = (ImageView)itemView.findViewById(R.id.iv_gif);
            this.ivCamera = (ImageView)itemView.findViewById(R.id.iv_camera);
        }
    }
}

