/*
 * Decompiled with CFR 0.152.
 */
package com.donkingliang.imageselector;

import android.app.Activity;
import android.app.Fragment;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.Color;
import android.os.Bundle;
import android.os.Parcelable;
import android.text.format.DateFormat;
import android.view.View;
import android.view.Window;
import android.widget.FrameLayout;
import com.donkingliang.imageselector.ImageSelectorActivity;
import com.donkingliang.imageselector.R;
import com.donkingliang.imageselector.entry.RequestConfig;
import com.donkingliang.imageselector.utils.ImageUtil;
import com.donkingliang.imageselector.utils.StringUtils;
import com.donkingliang.imageselector.utils.VersionUtils;
import com.donkingliang.imageselector.view.ClipImageView;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Locale;

public class ClipImageActivity
extends Activity {
    private FrameLayout btnConfirm;
    private FrameLayout btnBack;
    private ClipImageView imageView;
    private int mRequestCode;
    private boolean isCameraImage;
    private float cropRatio;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setRequestedOrientation(1);
        this.setContentView(R.layout.activity_clip_image);
        Intent intent = this.getIntent();
        RequestConfig config = (RequestConfig)intent.getParcelableExtra("key_config");
        this.mRequestCode = config.requestCode;
        config.isSingle = true;
        config.maxSelectCount = 0;
        this.cropRatio = config.cropRatio;
        this.setStatusBarColor();
        ImageSelectorActivity.openActivity(this, this.mRequestCode, config);
        this.initView();
    }

    private void setStatusBarColor() {
        if (VersionUtils.isAndroidL()) {
            Window window = this.getWindow();
            window.addFlags(Integer.MIN_VALUE);
            window.setStatusBarColor(Color.parseColor((String)"#373c3d"));
        }
    }

    private void initView() {
        this.imageView = (ClipImageView)this.findViewById(R.id.process_img);
        this.btnConfirm = (FrameLayout)this.findViewById(R.id.btn_confirm);
        this.btnBack = (FrameLayout)this.findViewById(R.id.btn_back);
        this.btnConfirm.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (ClipImageActivity.this.imageView.getDrawable() != null) {
                    ClipImageActivity.this.btnConfirm.setEnabled(false);
                    ClipImageActivity.this.confirm(ClipImageActivity.this.imageView.clipImage());
                }
            }
        });
        this.btnBack.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ClipImageActivity.this.finish();
            }
        });
        this.imageView.setRatio(this.cropRatio);
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (data != null && requestCode == this.mRequestCode) {
            ArrayList images = data.getStringArrayListExtra("select_result");
            this.isCameraImage = data.getBooleanExtra("is_camera_image", false);
            Bitmap bitmap = ImageUtil.decodeSampledBitmapFromFile((Context)this, (String)images.get(0), 720, 1080);
            if (bitmap != null) {
                this.imageView.setBitmapData(bitmap);
            } else {
                this.finish();
            }
        } else {
            this.finish();
        }
    }

    private void confirm(Bitmap bitmap) {
        String imagePath = null;
        if (bitmap != null) {
            String name = DateFormat.format((CharSequence)"yyyyMMdd_hhmmss", (Calendar)Calendar.getInstance(Locale.getDefault())).toString();
            String path = ImageUtil.getImageCacheDir((Context)this);
            imagePath = ImageUtil.saveImage(bitmap, path, name);
            bitmap.recycle();
            bitmap = null;
        }
        if (StringUtils.isNotEmptyString(imagePath)) {
            ArrayList<String> selectImages = new ArrayList<String>();
            selectImages.add(imagePath);
            Intent intent = new Intent();
            intent.putStringArrayListExtra("select_result", selectImages);
            intent.putExtra("is_camera_image", this.isCameraImage);
            this.setResult(-1, intent);
        }
        this.finish();
    }

    public static void openActivity(Activity activity, int requestCode, RequestConfig config) {
        Intent intent = new Intent((Context)activity, ClipImageActivity.class);
        intent.putExtra("key_config", (Parcelable)config);
        activity.startActivityForResult(intent, requestCode);
    }

    public static void openActivity(androidx.fragment.app.Fragment fragment, int requestCode, RequestConfig config) {
        Intent intent = new Intent((Context)fragment.getActivity(), ClipImageActivity.class);
        intent.putExtra("key_config", (Parcelable)config);
        fragment.startActivityForResult(intent, requestCode);
    }

    public static void openActivity(Fragment fragment, int requestCode, RequestConfig config) {
        Intent intent = new Intent((Context)fragment.getActivity(), ClipImageActivity.class);
        intent.putExtra("key_config", (Parcelable)config);
        fragment.startActivityForResult(intent, requestCode);
    }
}

