/*
 * Decompiled with CFR 0.152.
 */
package com.donkingliang.consecutivescroller;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.animation.AnimationUtils;
import android.view.animation.Interpolator;
import android.widget.AbsListView;
import android.widget.EdgeEffect;
import android.widget.OverScroller;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.view.NestedScrollingChild2;
import androidx.core.view.NestedScrollingChildHelper;
import androidx.core.view.NestedScrollingParent2;
import androidx.core.view.NestedScrollingParentHelper;
import androidx.core.view.ScrollingView;
import androidx.core.view.ViewCompat;
import androidx.core.widget.EdgeEffectCompat;
import androidx.recyclerview.widget.RecyclerView;
import com.donkingliang.consecutivescroller.IConsecutiveScroller;
import com.donkingliang.consecutivescroller.LayoutParamsUtils;
import com.donkingliang.consecutivescroller.OverScrollInterpolator;
import com.donkingliang.consecutivescroller.R;
import com.donkingliang.consecutivescroller.ScrollUtils;
import com.donkingliang.consecutivescroller.Util;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class ConsecutiveScrollerLayout
extends ViewGroup
implements ScrollingView,
NestedScrollingParent2,
NestedScrollingChild2 {
    private String TAG;
    protected int mScreenHeightPixels;
    protected float mDragRate = 0.5f;
    private boolean overDragMode;
    private int overDragMaxDistanceOfBottom;
    private int overDragMaxDistanceOfTop;
    protected int mReboundDuration = 300;
    protected int mCurrentVelocity;
    protected Interpolator mReboundInterpolator;
    protected ValueAnimator reboundAnimator;
    protected Runnable animationRunnable;
    protected Handler mHandler = new Handler(Looper.getMainLooper());
    private int mSecondScrollY;
    int mScrollRange;
    private OverScroller mScroller;
    private VelocityTracker mVelocityTracker;
    private VelocityTracker mAdjustVelocityTracker;
    private int mAdjustYVelocity;
    private int mMaximumVelocity;
    private int mMinimumVelocity;
    private int mTouchSlop;
    private int mTouchY;
    private int mEventX;
    private int mEventY;
    private HashMap<Integer, Float> mFixedYMap = new HashMap();
    private final int[] mDownLocation = new int[2];
    private boolean mTouching = false;
    private static final int SCROLL_NONE = 0;
    private static final int SCROLL_VERTICAL = 1;
    private static final int SCROLL_HORIZONTAL = 2;
    private int SCROLL_ORIENTATION = 0;
    protected OnScrollChangeListener mOnScrollChangeListener;
    private int mActivePointerId = -1;
    private NestedScrollingParentHelper mParentHelper;
    private NestedScrollingChildHelper mChildHelper;
    private final int[] mScrollOffset = new int[2];
    private final int[] mScrollConsumed = new int[2];
    private View mScrollToTopView;
    private int mAdjust;
    private int mScrollToIndex = -1;
    private int mSmoothScrollOffset = 0;
    private int mScrollToIndexWithOffset = 0;
    private int mCycleCount = 0;
    private static final int MAX_CYCLE_COUNT = 1000;
    private EdgeEffect mEdgeGlowTop;
    private EdgeEffect mEdgeGlowBottom;
    private int mLastScrollerY;
    private boolean isPermanent;
    private boolean disableChildHorizontalScroll;
    private boolean mAutoAdjustHeightAtBottomView;
    private int mAdjustHeightOffset = 0;
    private int mStickyOffset = 0;
    private View mCurrentStickyView;
    private final List<View> mCurrentStickyViews = new ArrayList<View>();
    private final List<View> mTempStickyViews = new ArrayList<View>();
    private int mOldScrollY = 0;
    private final List<View> mViews = new ArrayList<View>();
    private int mNestedYOffset = 0;
    private OnStickyChangeListener mOnStickyChangeListener;
    private OnPermanentStickyChangeListener mOnPermanentStickyChangeListener;
    public static final int SCROLL_STATE_IDLE = 0;
    public static final int SCROLL_STATE_DRAGGING = 1;
    public static final int SCROLL_STATE_SETTLING = 2;
    private int mScrollState = 0;
    static final Interpolator sQuinticInterpolator = new Interpolator(){

        public float getInterpolation(float t) {
            return (t -= 1.0f) * t * t * t * t + 1.0f;
        }
    };
    private boolean isTouchNotTriggerScrollStick = false;
    private boolean isIntercept = false;
    private boolean isBrake = false;

    public ConsecutiveScrollerLayout(Context context) {
        this(context, null);
    }

    public ConsecutiveScrollerLayout(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConsecutiveScrollerLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.TAG = ((Object)((Object)this)).getClass().getName();
        TypedArray a = null;
        try {
            a = context.obtainStyledAttributes(attrs, R.styleable.ConsecutiveScrollerLayout);
            if (a.hasValue(R.styleable.ConsecutiveScrollerLayout_overDragMode)) {
                this.overDragMode = a.getBoolean(R.styleable.ConsecutiveScrollerLayout_overDragMode, false);
                if (this.overDragMode) {
                    int defaultDistance = Util.dp2px(180.0f);
                    this.overDragMaxDistanceOfTop = a.getDimensionPixelOffset(R.styleable.ConsecutiveScrollerLayout_overDragMaxDistanceOfTop, defaultDistance);
                    this.overDragMaxDistanceOfBottom = a.getDimensionPixelOffset(R.styleable.ConsecutiveScrollerLayout_overDragMaxDistanceOfBottom, defaultDistance);
                }
            }
            this.isPermanent = a.getBoolean(R.styleable.ConsecutiveScrollerLayout_isPermanent, false);
            this.disableChildHorizontalScroll = a.getBoolean(R.styleable.ConsecutiveScrollerLayout_disableChildHorizontalScroll, false);
            this.mStickyOffset = a.getDimensionPixelOffset(R.styleable.ConsecutiveScrollerLayout_stickyOffset, 0);
            this.mAutoAdjustHeightAtBottomView = a.getBoolean(R.styleable.ConsecutiveScrollerLayout_autoAdjustHeightAtBottomView, false);
            this.mAdjustHeightOffset = a.getDimensionPixelOffset(R.styleable.ConsecutiveScrollerLayout_adjustHeightOffset, 0);
        }
        finally {
            if (a != null) {
                a.recycle();
            }
        }
        this.mScroller = new OverScroller(this.getContext(), sQuinticInterpolator);
        ViewConfiguration viewConfiguration = ViewConfiguration.get((Context)context);
        this.mMaximumVelocity = viewConfiguration.getScaledMaximumFlingVelocity();
        this.mMinimumVelocity = viewConfiguration.getScaledMinimumFlingVelocity();
        this.mTouchSlop = ViewConfiguration.getTouchSlop();
        this.setWillNotDraw(false);
        this.setVerticalScrollBarEnabled(true);
        this.mParentHelper = new NestedScrollingParentHelper((ViewGroup)this);
        this.mChildHelper = new NestedScrollingChildHelper((View)this);
        this.setNestedScrollingEnabled(true);
        this.setChildrenDrawingOrderEnabled(true);
        this.setMotionEventSplittingEnabled(false);
        this.mReboundInterpolator = new OverScrollInterpolator(OverScrollInterpolator.INTERPOLATOR_VISCOUS_FLUID);
    }

    public void addView(View child, int index, ViewGroup.LayoutParams params) {
        if (params instanceof LayoutParams) {
            LayoutParamsUtils.invalidTopAndBottomMargin((LayoutParams)params);
        }
        super.addView(child, index, params);
        if (ScrollUtils.isConsecutiveScrollerChild(child)) {
            List<View> views;
            View scrollChild = ScrollUtils.getScrollChild(child);
            this.disableChildScroll(scrollChild);
            if (scrollChild instanceof IConsecutiveScroller && (views = ((IConsecutiveScroller)scrollChild).getScrolledViews()) != null && !views.isEmpty()) {
                int size = views.size();
                for (int i = 0; i < size; ++i) {
                    this.disableChildScroll(views.get(i));
                }
            }
        }
        if (child instanceof ViewGroup) {
            ((ViewGroup)child).setClipToPadding(false);
        }
    }

    private void disableChildScroll(View child) {
        child.setVerticalScrollBarEnabled(false);
        child.setHorizontalScrollBarEnabled(false);
        child.setOverScrollMode(2);
        ViewCompat.setNestedScrollingEnabled((View)child, (boolean)false);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        this.resetScrollToTopView();
        int contentWidth = 0;
        int contentHeight = 0;
        List<View> children = this.getNonGoneChildren();
        int count = children.size();
        for (int i = 0; i < count; ++i) {
            View child = children.get(i);
            int heightUsed = 0;
            heightUsed = this.getAdjustHeightForChild(child);
            this.measureChildWithMargins(child, widthMeasureSpec, 0, heightMeasureSpec, heightUsed);
            contentWidth = Math.max(contentWidth, this.getContentWidth(child));
            contentHeight += child.getMeasuredHeight();
        }
        this.setMeasuredDimension(this.measureSize(widthMeasureSpec, contentWidth + this.getPaddingLeft() + this.getPaddingRight()), this.measureSize(heightMeasureSpec, contentHeight + this.getPaddingTop() + this.getPaddingBottom()));
    }

    private int getAdjustHeightForChild(View child) {
        if (this.mAutoAdjustHeightAtBottomView && child == this.getChildAt(this.getChildCount() - 1)) {
            return this.getAdjustHeight();
        }
        return 0;
    }

    private int getAdjustHeight() {
        List<View> children = this.getStickyChildren();
        int adjustHeight = this.mAdjustHeightOffset;
        int count = children.size();
        if (this.isPermanent) {
            for (int i = 0; i < count; ++i) {
                View child = children.get(i);
                if (this.isSink(child)) continue;
                adjustHeight += child.getMeasuredHeight();
            }
        } else {
            for (int i = count - 1; i >= 0; --i) {
                View child = children.get(i);
                if (this.isSink(child)) continue;
                adjustHeight += child.getMeasuredHeight();
                break;
            }
        }
        return adjustHeight;
    }

    private int getContentWidth(View child) {
        int contentWidth = child.getMeasuredWidth();
        LayoutParams params = (LayoutParams)child.getLayoutParams();
        contentWidth += params.leftMargin;
        return contentWidth += params.rightMargin;
    }

    private int measureSize(int measureSpec, int size) {
        int result = 0;
        int specMode = View.MeasureSpec.getMode((int)measureSpec);
        int specSize = View.MeasureSpec.getSize((int)measureSpec);
        if (specMode == 0x40000000) {
            result = specSize;
        } else {
            result = size;
            if (specMode == Integer.MIN_VALUE) {
                result = Math.min(result, specSize);
            }
        }
        result = Math.max(result, this.getSuggestedMinimumWidth());
        result = ConsecutiveScrollerLayout.resolveSizeAndState((int)result, (int)measureSpec, (int)0);
        return result;
    }

    protected void measureChildWithMargins(View child, int parentWidthMeasureSpec, int widthUsed, int parentHeightMeasureSpec, int heightUsed) {
        LayoutParamsUtils.invalidTopAndBottomMargin((LayoutParams)child.getLayoutParams());
        super.measureChildWithMargins(child, parentWidthMeasureSpec, widthUsed, parentHeightMeasureSpec, heightUsed);
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        this.mScreenHeightPixels = this.getResources().getDisplayMetrics().heightPixels;
        this.mScrollRange = 0;
        int childTop = this.getPaddingTop();
        int paddingLeft = this.getPaddingLeft();
        int paddingRight = this.getPaddingRight();
        int parentWidth = this.getMeasuredWidth();
        List<View> children = this.getNonGoneChildren();
        int count = children.size();
        for (int i = 0; i < count; ++i) {
            View child = children.get(i);
            int bottom = childTop + child.getMeasuredHeight();
            int left = this.getChildLeft(child, parentWidth, paddingLeft, paddingRight);
            child.layout(left, childTop, left + child.getMeasuredWidth(), bottom);
            childTop = bottom;
            this.mScrollRange += child.getHeight();
        }
        this.mScrollRange -= this.getMeasuredHeight() - this.getPaddingTop() - this.getPaddingBottom();
        if (this.mScrollRange < 0) {
            this.mScrollRange = 0;
        }
        this.checkLayoutChange(changed, false);
        this.sortViews();
    }

    public void requestLayout() {
        super.requestLayout();
    }

    private void sortViews() {
        View child;
        int i;
        ArrayList<View> list = new ArrayList<View>();
        int count = this.getChildCount();
        for (i = 0; i < count; ++i) {
            child = this.getChildAt(i);
            if (this.isStickyView(child) && !this.isSink(child)) continue;
            list.add(child);
        }
        for (i = 0; i < count; ++i) {
            child = this.getChildAt(i);
            if (!this.isStickyView(child) || this.isSink(child)) continue;
            list.add(child);
        }
        this.mViews.clear();
        this.mViews.addAll(list);
    }

    private int getChildLeft(View child, int parentWidth, int paddingLeft, int paddingRight) {
        LayoutParams lp = (LayoutParams)child.getLayoutParams();
        switch (lp.align) {
            case RIGHT: {
                return parentWidth - child.getMeasuredWidth() - paddingRight - lp.rightMargin;
            }
            case CENTER: {
                return paddingLeft + lp.leftMargin + (parentWidth - child.getMeasuredWidth() - paddingLeft - lp.leftMargin - paddingRight - lp.rightMargin) / 2;
            }
        }
        return paddingLeft + lp.leftMargin;
    }

    private void resetScrollToTopView() {
        this.mScrollToTopView = this.findFirstVisibleView();
        if (this.mScrollToTopView != null) {
            this.mAdjust = this.getScrollY() - this.mScrollToTopView.getTop();
        }
    }

    protected LayoutParams generateDefaultLayoutParams() {
        return new LayoutParams(-2, -2);
    }

    protected LayoutParams generateLayoutParams(ViewGroup.LayoutParams p) {
        return new LayoutParams(p);
    }

    public LayoutParams generateLayoutParams(AttributeSet attrs) {
        return new LayoutParams(this.getContext(), attrs);
    }

    public boolean dispatchTouchEvent(MotionEvent ev) {
        MotionEvent vtev;
        int actionIndex = ev.getActionIndex();
        if (this.SCROLL_ORIENTATION == 2 && this.mActivePointerId != -1 && this.mFixedYMap.get(this.mActivePointerId) != null) {
            int pointerIndex = ev.findPointerIndex(this.mActivePointerId);
            if (pointerIndex < 0 || pointerIndex >= ev.getPointerCount()) {
                return false;
            }
            ev.offsetLocation(0.0f, this.mFixedYMap.get(this.mActivePointerId).floatValue() - ev.getY(pointerIndex));
        }
        if ((vtev = MotionEvent.obtain((MotionEvent)ev)).getActionMasked() == 0) {
            this.mNestedYOffset = 0;
        }
        vtev.offsetLocation(0.0f, (float)this.mNestedYOffset);
        this.interceptAnimatorByAction(vtev.getAction());
        switch (ev.getActionMasked()) {
            case 0: {
                this.mCurrentVelocity = 0;
                this.isBrake = this.mScrollState == 2;
                this.stopScroll();
                this.mTouching = true;
                this.checkTargetsScroll(false, false);
                this.SCROLL_ORIENTATION = 0;
                this.mActivePointerId = ev.getPointerId(actionIndex);
                this.mFixedYMap.put(this.mActivePointerId, Float.valueOf(ev.getY(actionIndex)));
                this.mEventY = (int)ev.getY(actionIndex);
                this.mEventX = (int)ev.getX(actionIndex);
                this.initOrResetAdjustVelocityTracker();
                this.mAdjustVelocityTracker.addMovement(vtev);
                this.startNestedScroll(2, 0);
                this.mDownLocation[0] = ScrollUtils.getRawX((View)this, ev, actionIndex);
                this.mDownLocation[1] = ScrollUtils.getRawY((View)this, ev, actionIndex);
                this.isIntercept = this.isIntercept(this.mDownLocation[0], this.mDownLocation[1]);
                this.isTouchNotTriggerScrollStick = ScrollUtils.isTouchNotTriggerScrollStick((View)this, this.mDownLocation[0], this.mDownLocation[1]);
                break;
            }
            case 5: {
                this.mActivePointerId = ev.getPointerId(actionIndex);
                this.mFixedYMap.put(this.mActivePointerId, Float.valueOf(ev.getY(actionIndex)));
                this.mEventY = (int)ev.getY(actionIndex);
                this.mEventX = (int)ev.getX(actionIndex);
                this.requestDisallowInterceptTouchEvent(false);
                this.mDownLocation[0] = ScrollUtils.getRawX((View)this, ev, actionIndex);
                this.mDownLocation[1] = ScrollUtils.getRawY((View)this, ev, actionIndex);
                this.isIntercept = this.isIntercept(this.mDownLocation[0], this.mDownLocation[1]);
                this.isTouchNotTriggerScrollStick = ScrollUtils.isTouchNotTriggerScrollStick((View)this, this.mDownLocation[0], this.mDownLocation[1]);
                this.initAdjustVelocityTrackerIfNotExists();
                this.mAdjustVelocityTracker.addMovement(vtev);
                break;
            }
            case 2: {
                int pointerIndex = ev.findPointerIndex(this.mActivePointerId);
                if (pointerIndex < 0 || pointerIndex >= ev.getPointerCount()) {
                    return false;
                }
                this.initAdjustVelocityTrackerIfNotExists();
                this.mAdjustVelocityTracker.addMovement(vtev);
                int offsetY = (int)ev.getY(pointerIndex) - this.mEventY;
                int offsetX = (int)ev.getX(pointerIndex) - this.mEventX;
                if (this.SCROLL_ORIENTATION == 0 && (this.isIntercept || this.isIntercept(ev))) {
                    if (this.disableChildHorizontalScroll) {
                        if (Math.abs(offsetY) >= this.mTouchSlop) {
                            this.SCROLL_ORIENTATION = 1;
                        }
                    } else if (Math.abs(offsetX) > Math.abs(offsetY)) {
                        if (Math.abs(offsetX) >= this.mTouchSlop) {
                            int pointerIn;
                            this.SCROLL_ORIENTATION = 2;
                            if (this.mActivePointerId != -1 && this.mFixedYMap.get(this.mActivePointerId) != null && (pointerIn = ev.findPointerIndex(this.mActivePointerId)) >= 0 && pointerIndex < ev.getPointerCount()) {
                                ev.offsetLocation(0.0f, this.mFixedYMap.get(this.mActivePointerId).floatValue() - ev.getY(pointerIn));
                            }
                        }
                    } else if (Math.abs(offsetY) >= this.mTouchSlop) {
                        this.SCROLL_ORIENTATION = 1;
                    }
                    if (this.SCROLL_ORIENTATION == 0) {
                        return true;
                    }
                }
                this.mEventY = (int)ev.getY(pointerIndex);
                this.mEventX = (int)ev.getX(pointerIndex);
                break;
            }
            case 6: {
                this.mFixedYMap.remove(ev.getPointerId(actionIndex));
                if (this.mActivePointerId == ev.getPointerId(actionIndex)) {
                    int newPointerIndex = actionIndex == 0 ? 1 : 0;
                    this.mActivePointerId = ev.getPointerId(newPointerIndex);
                    this.mFixedYMap.put(this.mActivePointerId, Float.valueOf(ev.getY(newPointerIndex)));
                    this.mEventY = (int)ev.getY(newPointerIndex);
                    this.mEventX = (int)ev.getX(newPointerIndex);
                    this.mDownLocation[0] = ScrollUtils.getRawX((View)this, ev, newPointerIndex);
                    this.mDownLocation[1] = ScrollUtils.getRawY((View)this, ev, newPointerIndex);
                    this.isIntercept = this.isIntercept(this.mDownLocation[0], this.mDownLocation[1]);
                    this.isTouchNotTriggerScrollStick = ScrollUtils.isTouchNotTriggerScrollStick((View)this, this.mDownLocation[0], this.mDownLocation[1]);
                }
                this.initAdjustVelocityTrackerIfNotExists();
                this.mAdjustVelocityTracker.addMovement(vtev);
                break;
            }
            case 1: 
            case 3: {
                if (this.mAdjustVelocityTracker != null) {
                    int yVelocity;
                    this.mAdjustVelocityTracker.addMovement(vtev);
                    this.mAdjustVelocityTracker.computeCurrentVelocity(1000, (float)this.mMaximumVelocity);
                    this.mCurrentVelocity = yVelocity = (int)this.mAdjustVelocityTracker.getYVelocity();
                    this.mAdjustYVelocity = Math.max(-this.mMaximumVelocity, Math.min(yVelocity, this.mMaximumVelocity));
                    this.recycleAdjustVelocityTracker();
                    int touchX = ScrollUtils.getRawX((View)this, ev, actionIndex);
                    int touchY = ScrollUtils.getRawY((View)this, ev, actionIndex);
                    View targetView = this.getTouchTarget(touchX, touchY);
                    boolean canScrollVerticallyChild = ScrollUtils.canScrollVertically(targetView);
                    boolean canScrollHorizontallyChild = ScrollUtils.isHorizontalScroll((View)this, touchX, touchY);
                    if (this.SCROLL_ORIENTATION != 1 && canScrollVerticallyChild && Math.abs(yVelocity) >= this.mMinimumVelocity && !canScrollHorizontallyChild) {
                        ev.setAction(3);
                    }
                    if (!(this.SCROLL_ORIENTATION == 1 || ScrollUtils.isConsecutiveScrollParent((View)this) || !this.isIntercept(ev) || Math.abs(yVelocity) < this.mMinimumVelocity || this.SCROLL_ORIENTATION != 0 && canScrollHorizontallyChild)) {
                        this.fling(-this.mAdjustYVelocity);
                    }
                }
                this.mEventY = 0;
                this.mEventX = 0;
                this.mTouching = false;
                this.mDownLocation[0] = 0;
                this.mDownLocation[1] = 0;
                this.isTouchNotTriggerScrollStick = false;
                this.isIntercept = false;
                this.overSpinner();
            }
        }
        vtev.recycle();
        boolean dispatch = super.dispatchTouchEvent(ev);
        switch (ev.getActionMasked()) {
            case 1: 
            case 3: {
                this.SCROLL_ORIENTATION = 0;
                this.mAdjustYVelocity = 0;
                this.mFixedYMap.clear();
                this.mActivePointerId = -1;
                if (!this.mScroller.isFinished()) break;
                this.setScrollState(0);
            }
        }
        return dispatch;
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        switch (ev.getActionMasked()) {
            case 0: {
                this.initOrResetVelocityTracker();
                this.mVelocityTracker.addMovement(ev);
                break;
            }
            case 2: {
                if (this.SCROLL_ORIENTATION == 2 || !this.isIntercept && !this.isIntercept(ev)) break;
                return true;
            }
            case 1: 
            case 3: {
                this.stopNestedScroll(0);
                if (!this.isBrake || this.SCROLL_ORIENTATION != 0) break;
                return true;
            }
        }
        return super.onInterceptTouchEvent(ev);
    }

    public boolean onTouchEvent(MotionEvent ev) {
        if (ScrollUtils.isConsecutiveScrollParent((View)this) || this.isTouchNotTriggerScrollStick) {
            return super.onTouchEvent(ev);
        }
        MotionEvent vtev = MotionEvent.obtain((MotionEvent)ev);
        if (ev.getActionMasked() == 0) {
            this.mNestedYOffset = 0;
        }
        vtev.offsetLocation(0.0f, (float)this.mNestedYOffset);
        int pointerIndex = ev.findPointerIndex(this.mActivePointerId);
        if (pointerIndex < 0 || pointerIndex >= ev.getPointerCount()) {
            return false;
        }
        switch (ev.getActionMasked()) {
            case 0: {
                this.startNestedScroll(2, 0);
            }
            case 5: 
            case 6: {
                this.mTouchY = (int)ev.getY(pointerIndex);
                break;
            }
            case 2: {
                boolean canOverscroll;
                int scrolledDeltaY;
                if (this.mTouchY == 0) {
                    this.mTouchY = (int)ev.getY(pointerIndex);
                    return true;
                }
                this.mScrollConsumed[1] = 0;
                int y = (int)ev.getY(pointerIndex);
                int deltaY = this.mTouchY - y;
                this.mTouchY = y;
                if (this.dispatchNestedPreScroll(0, deltaY, this.mScrollConsumed, this.mScrollOffset, 0)) {
                    deltaY -= this.mScrollConsumed[1];
                    ev.offsetLocation(0.0f, (float)this.mScrollOffset[1]);
                    this.mNestedYOffset += this.mScrollOffset[1];
                    this.mTouchY -= this.mScrollOffset[1];
                    this.getParent().requestDisallowInterceptTouchEvent(true);
                }
                int oldScrollY = this.mSecondScrollY;
                if (this.mScrollState != 1) {
                    boolean startScroll = false;
                    if (this.canScrollVertically() && Math.abs(deltaY) > 0) {
                        startScroll = true;
                    }
                    if (startScroll) {
                        this.setScrollState(1);
                    }
                }
                if (this.mScrollState == 1) {
                    this.dispatchScroll(deltaY);
                }
                if ((scrolledDeltaY = this.mSecondScrollY - oldScrollY) != 0) {
                    this.getParent().requestDisallowInterceptTouchEvent(true);
                }
                if (this.dispatchNestedScroll(0, scrolledDeltaY, 0, deltaY -= scrolledDeltaY, this.mScrollOffset, 0)) {
                    deltaY += this.mScrollOffset[1];
                    this.mTouchY -= this.mScrollOffset[1];
                    this.mNestedYOffset += this.mScrollOffset[1];
                    ev.offsetLocation(0.0f, (float)this.mScrollOffset[1]);
                    this.getParent().requestDisallowInterceptTouchEvent(true);
                }
                int range = this.getScrollRange();
                int overscrollMode = this.getOverScrollMode();
                boolean bl = canOverscroll = overscrollMode == 0 || overscrollMode == 1 && range > 0;
                if (!canOverscroll) break;
                this.ensureGlows();
                int pulledToY = oldScrollY + deltaY;
                if (pulledToY < 0 && this.overDragMaxDistanceOfTop <= 0) {
                    EdgeEffectCompat.onPull((EdgeEffect)this.mEdgeGlowTop, (float)((float)deltaY / (float)this.getHeight()), (float)(ev.getX(pointerIndex) / (float)this.getWidth()));
                    if (!this.mEdgeGlowBottom.isFinished()) {
                        this.mEdgeGlowBottom.onRelease();
                    }
                } else if (pulledToY > range && this.overDragMaxDistanceOfBottom <= 0) {
                    EdgeEffectCompat.onPull((EdgeEffect)this.mEdgeGlowBottom, (float)((float)deltaY / (float)this.getHeight()), (float)(1.0f - ev.getX(pointerIndex) / (float)this.getWidth()));
                    if (!this.mEdgeGlowTop.isFinished()) {
                        this.mEdgeGlowTop.onRelease();
                    }
                }
                if (this.mEdgeGlowTop == null || this.mEdgeGlowTop.isFinished() && this.mEdgeGlowBottom.isFinished()) break;
                ViewCompat.postInvalidateOnAnimation((View)this);
                break;
            }
            case 3: {
                this.endDrag();
                this.mTouchY = 0;
                this.recycleVelocityTracker();
                this.setScrollState(0);
                break;
            }
            case 1: {
                this.endDrag();
                this.mTouchY = 0;
                if (this.mVelocityTracker == null) break;
                this.mVelocityTracker.addMovement(vtev);
                this.mVelocityTracker.computeCurrentVelocity(1000, (float)this.mMaximumVelocity);
                int yVelocity = (int)this.mVelocityTracker.getYVelocity();
                yVelocity = Math.max(-this.mMaximumVelocity, Math.min(yVelocity, this.mMaximumVelocity));
                if (yVelocity == 0 && this.mAdjustYVelocity != 0) {
                    yVelocity = this.mAdjustYVelocity;
                }
                this.fling(-yVelocity);
                this.recycleVelocityTracker();
            }
        }
        if (this.mVelocityTracker != null) {
            this.mVelocityTracker.addMovement(vtev);
        }
        vtev.recycle();
        return true;
    }

    private boolean canScrollVertically() {
        return !this.isScrollTop() || !this.isScrollBottom() || this.overDragMode;
    }

    protected int getChildDrawingOrder(int childCount, int drawingPosition) {
        int index;
        if (this.mViews.size() > drawingPosition && (index = this.indexOfChild(this.mViews.get(drawingPosition))) != -1) {
            return index;
        }
        return super.getChildDrawingOrder(childCount, drawingPosition);
    }

    int getDrawingPosition(View child) {
        return this.mViews.indexOf(child);
    }

    public void draw(Canvas canvas) {
        super.draw(canvas);
        if (this.mOldScrollY != this.getScrollY()) {
            this.mOldScrollY = this.getScrollY();
            this.resetSticky();
        }
        if (this.mEdgeGlowTop != null) {
            int yTranslation;
            int xTranslation;
            int height;
            int width;
            int restoreCount;
            int scrollY = this.getScrollY();
            if (!this.mEdgeGlowTop.isFinished()) {
                restoreCount = canvas.save();
                width = this.getWidth();
                height = this.getHeight();
                xTranslation = 0;
                yTranslation = scrollY;
                if (Build.VERSION.SDK_INT < 21 || this.getClipToPadding()) {
                    width -= this.getPaddingLeft() + this.getPaddingRight();
                    xTranslation += this.getPaddingLeft();
                }
                if (Build.VERSION.SDK_INT >= 21 && this.getClipToPadding()) {
                    height -= this.getPaddingTop() + this.getPaddingBottom();
                    yTranslation += this.getPaddingTop();
                }
                canvas.translate((float)xTranslation, (float)yTranslation);
                this.mEdgeGlowTop.setSize(width, height);
                if (this.mEdgeGlowTop.draw(canvas)) {
                    ViewCompat.postInvalidateOnAnimation((View)this);
                }
                canvas.restoreToCount(restoreCount);
            }
            if (!this.mEdgeGlowBottom.isFinished()) {
                restoreCount = canvas.save();
                width = this.getWidth();
                height = this.getHeight();
                xTranslation = 0;
                yTranslation = scrollY + height;
                if (Build.VERSION.SDK_INT < 21 || this.getClipToPadding()) {
                    width -= this.getPaddingLeft() + this.getPaddingRight();
                    xTranslation += this.getPaddingLeft();
                }
                if (Build.VERSION.SDK_INT >= 21 && this.getClipToPadding()) {
                    height -= this.getPaddingTop() + this.getPaddingBottom();
                    yTranslation -= this.getPaddingBottom();
                }
                canvas.translate((float)(xTranslation - width), (float)yTranslation);
                canvas.rotate(180.0f, (float)width, 0.0f);
                this.mEdgeGlowBottom.setSize(width, height);
                if (this.mEdgeGlowBottom.draw(canvas)) {
                    ViewCompat.postInvalidateOnAnimation((View)this);
                }
                canvas.restoreToCount(restoreCount);
            }
        }
    }

    private int getScrollRange() {
        int scrollRange = 0;
        if (this.getChildCount() > 0) {
            int childSize = this.computeVerticalScrollRange();
            int parentSpace = this.getHeight() - this.getPaddingTop() - this.getPaddingBottom();
            scrollRange = Math.max(0, childSize - parentSpace);
        }
        return scrollRange;
    }

    private void fling(int velocityY) {
        if (Math.abs(velocityY) > this.mMinimumVelocity && !this.dispatchNestedPreFling(0.0f, velocityY)) {
            boolean canScroll = velocityY < 0 && !this.isScrollTop() || velocityY > 0 && !this.isScrollBottom();
            this.dispatchNestedFling(0.0f, velocityY, canScroll);
            this.mScroller.fling(0, this.mSecondScrollY, 1, velocityY, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MAX_VALUE);
            this.startNestedScroll(2, 1);
            this.setScrollState(2);
            this.mLastScrollerY = this.mSecondScrollY;
            this.invalidate();
        }
    }

    public void computeScroll() {
        if (this.mScrollToIndex != -1 && this.mSmoothScrollOffset != 0) {
            if (this.mSmoothScrollOffset > 0 && this.mSmoothScrollOffset < 200) {
                this.mSmoothScrollOffset += 5;
            }
            if (this.mSmoothScrollOffset < 0 && this.mSmoothScrollOffset > -200) {
                this.mSmoothScrollOffset -= 5;
            }
            this.dispatchScroll(this.mSmoothScrollOffset);
            ++this.mCycleCount;
            this.invalidate();
        } else {
            if (this.mScroller.computeScrollOffset()) {
                int y = this.mScroller.getCurrY();
                int unconsumed = y - this.mLastScrollerY;
                this.mLastScrollerY = y;
                this.mScrollConsumed[1] = 0;
                this.dispatchNestedPreScroll(0, unconsumed, this.mScrollConsumed, null, 1);
                int oldScrollY = this.mSecondScrollY;
                this.dispatchScroll(unconsumed -= this.mScrollConsumed[1]);
                int scrolledByMe = this.mSecondScrollY - oldScrollY;
                if ((unconsumed -= scrolledByMe) < 0 && this.isScrollTop() || unconsumed > 0 && this.isScrollBottom()) {
                    this.dispatchNestedScroll(0, scrolledByMe, 0, unconsumed, this.mScrollOffset, 1);
                    unconsumed += this.mScrollOffset[1];
                }
                if (unconsumed < 0 && this.isScrollTop() || unconsumed > 0 && this.isScrollBottom()) {
                    if (this.overDragMode) {
                        int finalY = this.mScroller.getFinalY();
                        float velocity = finalY > 0 ? this.mScroller.getCurrVelocity() : -this.mScroller.getCurrVelocity();
                        this.animSpinnerBounce(velocity);
                        this.mScroller.forceFinished(true);
                    } else {
                        boolean canOverscroll;
                        int mode = this.getOverScrollMode();
                        boolean bl = canOverscroll = mode == 0 || mode == 1 && this.getScrollRange() > 0;
                        if (canOverscroll) {
                            this.ensureGlows();
                            if (unconsumed < 0) {
                                if (this.mEdgeGlowTop.isFinished()) {
                                    this.mEdgeGlowTop.onAbsorb((int)this.mScroller.getCurrVelocity());
                                }
                            } else if (this.mEdgeGlowBottom.isFinished()) {
                                this.mEdgeGlowBottom.onAbsorb((int)this.mScroller.getCurrVelocity());
                            }
                        }
                        this.stopScroll();
                    }
                }
                this.invalidate();
            }
            if (this.mScrollState == 2 && this.mScroller.isFinished()) {
                this.stopNestedScroll(1);
                this.checkTargetsScroll(false, false);
                this.setScrollState(0);
            }
        }
    }

    protected boolean interceptAnimatorByAction(int action) {
        if (action == 0) {
            if (this.reboundAnimator != null) {
                this.reboundAnimator.setDuration(0L);
                this.reboundAnimator.cancel();
                this.reboundAnimator = null;
            }
            this.animationRunnable = null;
        }
        return this.reboundAnimator != null;
    }

    protected void moveSpinnerInfinitely(float spinner) {
        double y;
        ConsecutiveScrollerLayout thisView = this;
        double H = Math.max(this.mScreenHeightPixels / 2, thisView.getHeight());
        if (spinner > 0.0f) {
            float maxDragHeight = this.overDragMaxDistanceOfBottom;
            double M = maxDragHeight;
            double x = Math.max(0.0f, spinner * this.mDragRate);
            y = Math.min(M * (1.0 - Math.pow(100.0, -x / (H == 0.0 ? 1.0 : H))), x);
        } else {
            float maxDragHeight = this.overDragMaxDistanceOfBottom;
            double M = maxDragHeight;
            double x = -Math.min(0.0f, spinner * this.mDragRate);
            y = -Math.min(M * (1.0 - Math.pow(100.0, -x / (H == 0.0 ? 1.0 : H))), x);
        }
        int mSpinner = (int)y;
        if (Math.abs(spinner) >= 1.0f && mSpinner == 0) {
            mSpinner = (int)spinner;
        }
        int finalScrollY = this.getScrollY() + mSpinner;
        this.mSecondScrollY += mSpinner;
        this.scrollSelf(finalScrollY);
    }

    protected ValueAnimator animSpinner(int startSpinner, int endSpinner, int startDelay, Interpolator interpolator, int duration) {
        if (startSpinner != endSpinner) {
            if (this.reboundAnimator != null) {
                this.reboundAnimator.setDuration(0L);
                this.reboundAnimator.cancel();
                this.reboundAnimator = null;
            }
            this.animationRunnable = null;
            this.reboundAnimator = ValueAnimator.ofInt((int[])new int[]{startSpinner, endSpinner});
            this.reboundAnimator.setDuration((long)duration);
            this.reboundAnimator.setInterpolator((TimeInterpolator)interpolator);
            this.reboundAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                public void onAnimationEnd(Animator animation) {
                    if (animation != null && animation.getDuration() == 0L) {
                        return;
                    }
                    ConsecutiveScrollerLayout.this.reboundAnimator = null;
                    ConsecutiveScrollerLayout.this.checkTargetsScroll(false, false);
                }
            });
            this.reboundAnimator.addUpdateListener(animation -> {
                int animatedValue = (Integer)animation.getAnimatedValue();
                int oldScrollY = this.computeVerticalScrollOffset();
                this.scrollSelf(animatedValue);
                this.mSecondScrollY = this.computeVerticalScrollOffset();
                if (oldScrollY != this.mSecondScrollY) {
                    this.scrollChange(this.mSecondScrollY, oldScrollY);
                }
            });
            this.reboundAnimator.setStartDelay((long)startDelay);
            this.reboundAnimator.start();
            return this.reboundAnimator;
        }
        return null;
    }

    protected void animSpinnerBounce(float velocity) {
        if (this.reboundAnimator == null) {
            if (velocity < 0.0f && this.overDragMaxDistanceOfTop > 0) {
                this.animationRunnable = new BounceRunnable(velocity, 0);
            } else if (velocity > 0.0f && this.overDragMaxDistanceOfBottom > 0) {
                this.animationRunnable = new BounceRunnable(velocity, this.mScrollRange);
            }
        }
    }

    protected void overSpinner() {
        int mScrollY = this.getScrollY();
        if (mScrollY < 0) {
            if (this.reboundAnimator == null) {
                this.animSpinner(mScrollY, 0, 0, this.mReboundInterpolator, this.mReboundDuration);
            }
        } else if (mScrollY > this.mScrollRange && this.reboundAnimator == null) {
            this.animSpinner(mScrollY, this.mScrollRange, 0, this.mReboundInterpolator, this.mReboundDuration);
        }
    }

    private void endDrag() {
        if (this.mEdgeGlowTop != null) {
            this.mEdgeGlowTop.onRelease();
            this.mEdgeGlowBottom.onRelease();
        }
    }

    private void ensureGlows() {
        if (this.getOverScrollMode() != 2) {
            if (this.mEdgeGlowTop == null) {
                Context context = this.getContext();
                this.mEdgeGlowTop = new EdgeEffect(context);
                this.mEdgeGlowBottom = new EdgeEffect(context);
            }
        } else {
            this.mEdgeGlowTop = null;
            this.mEdgeGlowBottom = null;
        }
    }

    private void dispatchScroll(int offset) {
        if (offset > 0) {
            this.scrollUp(offset);
        } else if (offset < 0) {
            this.scrollDown(offset);
        }
    }

    private void scrollUp(int offset) {
        int scrollOffset = 0;
        int remainder = offset;
        int oldScrollY = this.computeVerticalScrollOffset();
        do {
            int scrollAnchor = 0;
            int viewScrollOffset = 0;
            if (this.mScrollToIndex != -1) {
                View view = this.getChildAt(this.mScrollToIndex);
                scrollAnchor = view.getTop() - this.mScrollToIndexWithOffset;
                scrollAnchor -= this.getAdjustHeightForChild(view);
                if (this.mScrollToIndexWithOffset < 0) {
                    viewScrollOffset = this.getViewsScrollOffset(this.mScrollToIndex);
                }
                if (this.mCycleCount >= 1000 || this.getScrollY() + this.getPaddingTop() + viewScrollOffset >= scrollAnchor || this.isScrollBottom()) {
                    this.mScrollToIndex = -1;
                    this.mSmoothScrollOffset = 0;
                    this.mScrollToIndexWithOffset = 0;
                    this.mCycleCount = 0;
                    this.setScrollState(0);
                    break;
                }
            }
            scrollOffset = 0;
            int scrollY = this.getScrollY();
            if (!this.isScrollBottom() && scrollY >= 0) {
                View firstVisibleView = null;
                firstVisibleView = this.getScrollY() < this.mScrollRange ? this.findFirstVisibleView() : this.getBottomView();
                if (firstVisibleView == null) continue;
                this.awakenScrollBars();
                int bottomOffset = ScrollUtils.getScrollBottomOffset(firstVisibleView);
                if (bottomOffset > 0) {
                    scrollOffset = Math.min(remainder, bottomOffset);
                    if (this.mScrollToIndex != -1) {
                        scrollOffset = Math.min(scrollOffset, scrollAnchor - (this.getScrollY() + this.getPaddingTop() + viewScrollOffset));
                    }
                    this.scrollChild(firstVisibleView, scrollOffset);
                } else {
                    scrollOffset = Math.min(remainder, firstVisibleView.getBottom() - this.getPaddingTop() - this.getScrollY());
                    if (this.mScrollToIndex != -1) {
                        scrollOffset = Math.min(scrollOffset, scrollAnchor - (this.getScrollY() + this.getPaddingTop() + viewScrollOffset));
                    }
                    this.scrollSelf(scrollY + scrollOffset);
                }
                this.mSecondScrollY += scrollOffset;
                remainder -= scrollOffset;
                continue;
            }
            if (this.mTouching) {
                if (scrollY < 0 && remainder > Math.abs(scrollY)) {
                    scrollOffset = remainder - Math.abs(scrollY);
                    remainder -= scrollOffset;
                    this.moveSpinnerInfinitely(scrollOffset);
                    continue;
                }
                this.dispatchNestedScroll(0, 0, 0, remainder, this.mScrollOffset, 0);
                if (this.mScrollOffset[1] == 0 && this.overDragMode && this.overDragMaxDistanceOfBottom >= 0) {
                    this.moveSpinnerInfinitely(remainder);
                }
                remainder = 0;
                continue;
            }
            if (!this.mScroller.isFinished() && this.mScroller.getFinalY() > 0 && scrollY < 0) {
                if (this.reboundAnimator != null) {
                    this.interceptAnimatorByAction(0);
                }
                if (remainder > Math.abs(scrollY)) {
                    scrollOffset = remainder - Math.abs(scrollY);
                    remainder -= scrollOffset;
                } else {
                    scrollOffset = remainder;
                    remainder = 0;
                }
                this.mSecondScrollY += scrollOffset;
                this.scrollSelf(scrollY + scrollOffset);
                continue;
            }
            if (scrollY >= 0) continue;
            this.mScroller.forceFinished(true);
        } while (scrollOffset > 0 && remainder > 0);
        int newScrollY = this.computeVerticalScrollOffset();
        if (oldScrollY != newScrollY) {
            this.scrollChange(newScrollY, oldScrollY);
        }
    }

    private void scrollDown(int offset) {
        int scrollOffset = 0;
        int remainder = offset;
        int oldScrollY = this.computeVerticalScrollOffset();
        do {
            int scrollAnchor = 0;
            int viewScrollOffset = 0;
            if (this.mScrollToIndex != -1) {
                View view = this.getChildAt(this.mScrollToIndex);
                scrollAnchor = view.getTop() - this.mScrollToIndexWithOffset;
                viewScrollOffset = this.getViewsScrollOffset(this.mScrollToIndex);
                if (this.mCycleCount >= 1000 || this.getScrollY() + this.getPaddingTop() + viewScrollOffset <= (scrollAnchor -= this.getAdjustHeightForChild(view)) || this.isScrollTop()) {
                    this.mScrollToIndex = -1;
                    this.mSmoothScrollOffset = 0;
                    this.mScrollToIndexWithOffset = 0;
                    this.mCycleCount = 0;
                    this.setScrollState(0);
                    break;
                }
            }
            scrollOffset = 0;
            int scrollY = this.getScrollY();
            if (!this.isScrollTop() && scrollY <= this.mScrollRange && scrollY >= 0) {
                View lastVisibleView = null;
                lastVisibleView = scrollY < this.mScrollRange ? this.findLastVisibleView() : this.getBottomView();
                if (lastVisibleView == null) continue;
                this.awakenScrollBars();
                int childScrollOffset = ScrollUtils.getScrollTopOffset(lastVisibleView);
                if (childScrollOffset < 0) {
                    scrollOffset = Math.max(remainder, childScrollOffset);
                    if (this.mScrollToIndex != -1) {
                        scrollOffset = Math.max(scrollOffset, scrollAnchor - (this.getScrollY() + this.getPaddingTop() + viewScrollOffset));
                    }
                    this.scrollChild(lastVisibleView, scrollOffset);
                } else {
                    scrollOffset = Math.max(remainder, lastVisibleView.getTop() + this.getPaddingBottom() - scrollY - this.getHeight());
                    scrollOffset = Math.max(scrollOffset, -scrollY);
                    if (this.mScrollToIndex != -1) {
                        scrollOffset = Math.max(scrollOffset, scrollAnchor - (this.getScrollY() + this.getPaddingTop() + viewScrollOffset));
                    }
                    this.scrollSelf(scrollY + scrollOffset);
                }
                this.mSecondScrollY += scrollOffset;
                remainder -= scrollOffset;
                continue;
            }
            if (this.mTouching) {
                int diff = scrollY - this.mScrollRange;
                if (scrollY > this.mScrollRange && Math.abs(remainder) > diff) {
                    scrollOffset = -diff;
                    remainder -= scrollOffset;
                    this.moveSpinnerInfinitely(scrollOffset);
                    continue;
                }
                this.dispatchNestedScroll(0, 0, 0, remainder, this.mScrollOffset, 0);
                if ((remainder += this.mScrollOffset[1]) != 0) {
                    this.moveSpinnerInfinitely(remainder);
                }
                remainder = 0;
                continue;
            }
            if (!this.mScroller.isFinished() && this.mScroller.getFinalY() < this.mScrollRange && scrollY > this.mScrollRange) {
                int diff;
                if (this.reboundAnimator != null) {
                    this.interceptAnimatorByAction(0);
                }
                if (remainder < (diff = this.mScrollRange - scrollY)) {
                    scrollOffset = diff;
                    remainder -= scrollOffset;
                } else {
                    scrollOffset = remainder;
                    remainder = 0;
                }
                this.mSecondScrollY += scrollOffset;
                this.scrollSelf(scrollY + scrollOffset);
                continue;
            }
            if (scrollY <= this.mScrollRange) continue;
            this.mScroller.forceFinished(true);
        } while (scrollOffset < 0 && remainder < 0);
        int newScrollY = this.computeVerticalScrollOffset();
        if (oldScrollY != newScrollY) {
            this.scrollChange(newScrollY, oldScrollY);
        }
    }

    public void scrollBy(int x, int y) {
        this.scrollTo(0, this.mSecondScrollY + y);
    }

    public void scrollTo(int x, int y) {
        this.dispatchScroll(y - this.mSecondScrollY);
    }

    private void scrollChange(int scrollY, int oldScrollY) {
        if (this.mOnScrollChangeListener != null) {
            this.mOnScrollChangeListener.onScrollChange((View)this, scrollY, oldScrollY, this.mScrollState);
        }
    }

    private void stickyChange(View oldStickyView, View newStickyView) {
        if (this.mOnStickyChangeListener != null) {
            this.mOnStickyChangeListener.onStickyChange(oldStickyView, newStickyView);
        }
    }

    private void permanentStickyChange(List<View> mCurrentStickyViews) {
        if (this.mOnPermanentStickyChangeListener != null) {
            this.mOnPermanentStickyChangeListener.onStickyChange(mCurrentStickyViews);
        }
    }

    private void scrollSelf(int y) {
        int scrollY = y;
        if (scrollY < 0 && Math.abs(scrollY) > Math.abs(this.overDragMaxDistanceOfTop)) {
            scrollY = this.overDragMaxDistanceOfTop <= 0 ? 0 : -this.overDragMaxDistanceOfTop;
        } else if (scrollY > this.mScrollRange && scrollY > this.mScrollRange + Math.abs(this.overDragMaxDistanceOfBottom)) {
            scrollY = this.overDragMaxDistanceOfBottom <= 0 ? this.mScrollRange : this.mScrollRange + this.overDragMaxDistanceOfBottom;
        }
        super.scrollTo(0, scrollY);
    }

    private void scrollChild(View child, int y) {
        View scrolledView = ScrollUtils.getScrolledView(child);
        if (scrolledView instanceof AbsListView) {
            AbsListView listView = (AbsListView)scrolledView;
            if (Build.VERSION.SDK_INT >= 19) {
                listView.scrollListBy(y);
            }
        } else {
            boolean isInterceptRequestLayout = false;
            if (scrolledView instanceof RecyclerView) {
                isInterceptRequestLayout = ScrollUtils.startInterceptRequestLayout((RecyclerView)scrolledView);
            }
            scrolledView.scrollBy(0, y);
            if (isInterceptRequestLayout) {
                final RecyclerView view = (RecyclerView)scrolledView;
                view.postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        ScrollUtils.stopInterceptRequestLayout(view);
                    }
                }, 0L);
            }
        }
    }

    public void checkLayoutChange() {
        this.postDelayed(new Runnable(){

            @Override
            public void run() {
                ConsecutiveScrollerLayout.this.checkLayoutChange(false, true);
            }
        }, 20L);
    }

    private void checkLayoutChange(boolean changed, boolean isForce) {
        int y = this.mSecondScrollY;
        if (this.mScrollToTopView != null && changed) {
            if (this.indexOfChild(this.mScrollToTopView) != -1) {
                this.scrollSelf(this.mScrollToTopView.getTop() + this.mAdjust);
            }
        } else {
            this.scrollSelf(this.getScrollY());
        }
        this.checkTargetsScroll(true, isForce);
        if (y != this.mSecondScrollY && this.mScrollToTopView != this.findFirstVisibleView()) {
            this.scrollTo(0, y);
        }
        this.mScrollToTopView = null;
        this.mAdjust = 0;
        this.resetChildren();
        this.resetSticky();
    }

    private void checkTargetsScroll(boolean isLayoutChange, boolean isForce) {
        int newScrollY;
        int c;
        int size;
        List<View> views;
        int i;
        if (!(isForce || !this.mTouching && this.mScroller.isFinished() && this.mScrollToIndex == -1)) {
            return;
        }
        int oldScrollY = this.computeVerticalScrollOffset();
        View target = this.findFirstVisibleView();
        if (target == null) {
            return;
        }
        int index = this.indexOfChild(target);
        if (isLayoutChange) {
            while (true) {
                int bottomOffset = ScrollUtils.getScrollBottomOffset(target);
                int scrollTopOffset = target.getTop() - this.getScrollY();
                if (bottomOffset <= 0 || scrollTopOffset >= 0) break;
                int offset = Math.min(bottomOffset, -scrollTopOffset);
                this.scrollSelf(this.getScrollY() - offset);
                this.scrollChild(target, offset);
            }
        }
        for (i = 0; i < index; ++i) {
            View child = this.getChildAt(i);
            if (child.getVisibility() == 8 || !ScrollUtils.isConsecutiveScrollerChild(child)) continue;
            View scrollChild = ScrollUtils.getScrollChild(child);
            if (scrollChild instanceof IConsecutiveScroller) {
                views = ((IConsecutiveScroller)scrollChild).getScrolledViews();
                if (views == null || views.isEmpty()) continue;
                size = views.size();
                for (c = 0; c < size; ++c) {
                    this.scrollChildContentToBottom(views.get(c));
                }
                continue;
            }
            this.scrollChildContentToBottom(scrollChild);
        }
        for (i = index + 1; i < this.getChildCount(); ++i) {
            View child = this.getChildAt(i);
            if (child.getVisibility() == 8 || !ScrollUtils.isConsecutiveScrollerChild(child) || i == this.getChildCount() - 1 && child.getHeight() < this.getHeight() && this.getScrollY() >= this.mScrollRange) continue;
            View scrollChild = ScrollUtils.getScrollChild(child);
            if (scrollChild instanceof IConsecutiveScroller) {
                views = ((IConsecutiveScroller)scrollChild).getScrolledViews();
                if (views == null || views.isEmpty()) continue;
                size = views.size();
                for (c = 0; c < size; ++c) {
                    this.scrollChildContentToTop(views.get(c));
                }
                continue;
            }
            this.scrollChildContentToTop(scrollChild);
        }
        this.computeOwnScrollOffset();
        if (isLayoutChange && oldScrollY != (newScrollY = this.computeVerticalScrollOffset())) {
            this.scrollChange(newScrollY, oldScrollY);
        }
        this.resetSticky();
    }

    void scrollChildContentToTop(View target) {
        int scrollY = 0;
        do {
            scrollY = 0;
            int offset = ScrollUtils.getScrollTopOffset(target);
            if (offset >= 0) continue;
            int childOldScrollY = ScrollUtils.computeVerticalScrollOffset(target);
            this.scrollChild(target, offset);
            scrollY = childOldScrollY - ScrollUtils.computeVerticalScrollOffset(target);
        } while (scrollY != 0);
    }

    void scrollChildContentToBottom(View target) {
        int scrollY = 0;
        do {
            scrollY = 0;
            int offset = ScrollUtils.getScrollBottomOffset(target);
            if (offset <= 0) continue;
            int childOldScrollY = ScrollUtils.computeVerticalScrollOffset(target);
            this.scrollChild(target, offset);
            scrollY = childOldScrollY - ScrollUtils.computeVerticalScrollOffset(target);
        } while (scrollY != 0);
    }

    private void computeOwnScrollOffset() {
        this.mSecondScrollY = this.computeVerticalScrollOffset();
    }

    private void initOrResetVelocityTracker() {
        if (this.mVelocityTracker == null) {
            this.mVelocityTracker = VelocityTracker.obtain();
        } else {
            this.mVelocityTracker.clear();
        }
    }

    private void initVelocityTrackerIfNotExists() {
        if (this.mVelocityTracker == null) {
            this.mVelocityTracker = VelocityTracker.obtain();
        }
    }

    private void recycleVelocityTracker() {
        if (this.mVelocityTracker != null) {
            this.mVelocityTracker.recycle();
            this.mVelocityTracker = null;
        }
    }

    private void initOrResetAdjustVelocityTracker() {
        if (this.mAdjustVelocityTracker == null) {
            this.mAdjustVelocityTracker = VelocityTracker.obtain();
        } else {
            this.mAdjustVelocityTracker.clear();
        }
    }

    private void initAdjustVelocityTrackerIfNotExists() {
        if (this.mAdjustVelocityTracker == null) {
            this.mAdjustVelocityTracker = VelocityTracker.obtain();
        }
    }

    private void recycleAdjustVelocityTracker() {
        if (this.mAdjustVelocityTracker != null) {
            this.mAdjustVelocityTracker.recycle();
            this.mAdjustVelocityTracker = null;
        }
    }

    public void stopScroll() {
        if (!this.mScroller.isFinished()) {
            this.mScroller.abortAnimation();
            this.stopNestedScroll(1);
            if (this.mScrollToIndex == -1) {
                this.setScrollState(0);
            }
        }
    }

    private View getBottomView() {
        List<View> views = this.getEffectiveChildren();
        if (!views.isEmpty()) {
            return views.get(views.size() - 1);
        }
        return null;
    }

    private List<View> getNonGoneChildren() {
        ArrayList<View> children = new ArrayList<View>();
        int count = this.getChildCount();
        for (int i = 0; i < count; ++i) {
            View child = this.getChildAt(i);
            if (child.getVisibility() == 8) continue;
            children.add(child);
        }
        return children;
    }

    private List<View> getEffectiveChildren() {
        ArrayList<View> children = new ArrayList<View>();
        int count = this.getChildCount();
        for (int i = 0; i < count; ++i) {
            View child = this.getChildAt(i);
            if (child.getVisibility() == 8 || child.getHeight() <= 0) continue;
            children.add(child);
        }
        return children;
    }

    private List<View> getStickyChildren() {
        ArrayList<View> children = new ArrayList<View>();
        int count = this.getChildCount();
        for (int i = 0; i < count; ++i) {
            View child = this.getChildAt(i);
            if (child.getVisibility() == 8 || !this.isStickyView(child)) continue;
            children.add(child);
        }
        return children;
    }

    public boolean isStickyView(View child) {
        ViewGroup.LayoutParams lp = child.getLayoutParams();
        if (lp instanceof LayoutParams) {
            return ((LayoutParams)lp).isSticky;
        }
        return false;
    }

    public boolean isSink(View stickyView) {
        ViewGroup.LayoutParams lp = stickyView.getLayoutParams();
        if (lp instanceof LayoutParams) {
            return ((LayoutParams)lp).isSink;
        }
        return false;
    }

    private void resetChildren() {
        List<View> children = this.getNonGoneChildren();
        for (View child : children) {
            child.setTranslationY(0.0f);
        }
    }

    private void resetSticky() {
        List<View> children = this.getStickyChildren();
        if (!children.isEmpty()) {
            int count = children.size();
            for (int i = 0; i < count; ++i) {
                View child = children.get(i);
                child.setTranslationY(0.0f);
            }
            if (this.isPermanent) {
                this.clearCurrentStickyView();
                this.permanentStickyChild(children);
            } else {
                this.clearCurrentStickyViews();
                View stickyView = null;
                View nextStickyView = null;
                for (int i = count - 1; i >= 0; --i) {
                    boolean find;
                    View child = children.get(i);
                    int scrollY = this.getScrollY();
                    boolean bl = find = scrollY < 0 && child.getTop() + scrollY <= this.getStickyY();
                    if (!find && child.getTop() > this.getStickyY()) continue;
                    stickyView = child;
                    if (i == count - 1) break;
                    nextStickyView = children.get(i + 1);
                    break;
                }
                View oldStickyView = this.mCurrentStickyView;
                View newStickyView = stickyView;
                if (stickyView != null) {
                    int offset = 0;
                    if (nextStickyView != null && !this.isSink(stickyView)) {
                        int mOffset = stickyView.getHeight() - (nextStickyView.getTop() - this.getStickyY());
                        offset = Math.max(0, mOffset);
                    }
                    this.stickyChild(stickyView, offset);
                }
                if (oldStickyView != newStickyView) {
                    this.mCurrentStickyView = newStickyView;
                    this.stickyChange(oldStickyView, newStickyView);
                }
            }
        } else {
            this.clearCurrentStickyView();
            this.clearCurrentStickyViews();
        }
    }

    private void clearCurrentStickyView() {
        if (this.mCurrentStickyView != null) {
            View oldStickyView = this.mCurrentStickyView;
            this.mCurrentStickyView = null;
            this.stickyChange(oldStickyView, null);
        }
    }

    private void clearCurrentStickyViews() {
        if (!this.mCurrentStickyViews.isEmpty()) {
            this.mCurrentStickyViews.clear();
            this.permanentStickyChange(this.mCurrentStickyViews);
        }
    }

    private void stickyChild(View child, int offset) {
        child.setY((float)(this.getStickyY() - offset));
        child.setClickable(true);
    }

    private int getStickyY() {
        return this.getScrollY() + this.getPaddingTop() + this.mStickyOffset;
    }

    private void permanentStickyChild(List<View> children) {
        this.mTempStickyViews.clear();
        for (int i = 0; i < children.size(); ++i) {
            View child = children.get(i);
            int permanentHeight = this.getPermanentHeight(children, i);
            if (child.getTop() > this.getStickyY() + permanentHeight) continue;
            child.setY((float)(this.getStickyY() + permanentHeight));
            child.setClickable(true);
            this.mTempStickyViews.add(child);
        }
        if (!this.isListEqual()) {
            this.mCurrentStickyViews.clear();
            this.mCurrentStickyViews.addAll(this.mTempStickyViews);
            this.mTempStickyViews.clear();
            this.permanentStickyChange(this.mCurrentStickyViews);
        }
    }

    private int getPermanentHeight(List<View> children, int currentPosition) {
        int height = 0;
        for (int i = 0; i < currentPosition; ++i) {
            View child = children.get(i);
            if (this.isSink(child)) continue;
            height += child.getMeasuredHeight();
        }
        return height;
    }

    private boolean isListEqual() {
        if (this.mTempStickyViews.size() == this.mCurrentStickyViews.size()) {
            int size = this.mTempStickyViews.size();
            for (int i = 0; i < size; ++i) {
                if (this.mTempStickyViews.get(i) == this.mCurrentStickyViews.get(i)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int getScrollState() {
        return this.mScrollState;
    }

    void setScrollState(int state) {
        if (state == this.mScrollState) {
            return;
        }
        this.mScrollState = state;
        int newScrollY = this.computeVerticalScrollOffset();
        this.scrollChange(newScrollY, newScrollY);
    }

    public int getOwnScrollY() {
        return this.computeVerticalScrollOffset();
    }

    public View findFirstVisibleView() {
        int offset = this.getScrollY() + this.getPaddingTop();
        List<View> children = this.getEffectiveChildren();
        int count = children.size();
        for (int i = 0; i < count; ++i) {
            View child = children.get(i);
            if (child.getTop() > offset || child.getBottom() <= offset) continue;
            return child;
        }
        return null;
    }

    public View findLastVisibleView() {
        int offset = this.getHeight() - this.getPaddingBottom() + this.getScrollY();
        List<View> children = this.getEffectiveChildren();
        int count = children.size();
        for (int i = 0; i < count; ++i) {
            View child = children.get(i);
            if (child.getTop() >= offset || child.getBottom() < offset) continue;
            return child;
        }
        return null;
    }

    public boolean isScrollTop() {
        List<View> children = this.getEffectiveChildren();
        int size = children.size();
        if (size > 0) {
            boolean isScrollTop;
            View child = children.get(0);
            boolean bl = isScrollTop = this.getScrollY() <= 0 && !ScrollUtils.canScrollVertically(child, -1);
            if (isScrollTop) {
                for (int i = size - 1; i >= 0; --i) {
                    View view = children.get(i);
                    if (!ScrollUtils.isConsecutiveScrollerChild(view) || !ScrollUtils.canScrollVertically(view, -1)) continue;
                    return false;
                }
            }
            return isScrollTop;
        }
        return true;
    }

    public boolean isScrollBottom() {
        List<View> children = this.getEffectiveChildren();
        int size = children.size();
        if (size > 0) {
            boolean isScrollBottom;
            View child = children.get(children.size() - 1);
            boolean bl = isScrollBottom = this.getScrollY() >= this.mScrollRange && !ScrollUtils.canScrollVertically(child, 1);
            if (isScrollBottom) {
                for (int i = size - 1; i >= 0; --i) {
                    View view = children.get(i);
                    if (!ScrollUtils.isConsecutiveScrollerChild(view) || !ScrollUtils.canScrollVertically(view, 1)) continue;
                    return false;
                }
            }
            return isScrollBottom;
        }
        return true;
    }

    public boolean canScrollVertically(int direction) {
        if (direction > 0) {
            return !this.isScrollBottom();
        }
        return !this.isScrollTop();
    }

    @Deprecated
    public void setOnScrollChangeListener(View.OnScrollChangeListener l) {
    }

    public void setOnVerticalScrollChangeListener(OnScrollChangeListener l) {
        this.mOnScrollChangeListener = l;
    }

    public OnScrollChangeListener getOnVerticalScrollChangeListener() {
        return this.mOnScrollChangeListener;
    }

    public int computeHorizontalScrollRange() {
        return super.computeHorizontalScrollRange();
    }

    public int computeHorizontalScrollOffset() {
        return super.computeHorizontalScrollOffset();
    }

    public int computeHorizontalScrollExtent() {
        return super.computeHorizontalScrollExtent();
    }

    public int computeVerticalScrollRange() {
        int range = 0;
        List<View> children = this.getNonGoneChildren();
        int count = children.size();
        for (int i = 0; i < count; ++i) {
            View child = children.get(i);
            if (!ScrollUtils.isConsecutiveScrollerChild(child)) {
                range += child.getHeight();
                continue;
            }
            if (ScrollUtils.canScrollVertically(child)) {
                View view = ScrollUtils.getScrolledView(child);
                range += ScrollUtils.computeVerticalScrollRange(view) + view.getPaddingTop() + view.getPaddingBottom();
                continue;
            }
            range += child.getHeight();
        }
        return range;
    }

    public int computeVerticalScrollOffset() {
        int scrollOffset = this.getScrollY();
        List<View> children = this.getNonGoneChildren();
        int count = children.size();
        for (int i = 0; i < count; ++i) {
            View child = children.get(i);
            if (!ScrollUtils.isConsecutiveScrollerChild(child)) continue;
            scrollOffset += ScrollUtils.computeVerticalScrollOffset(child);
        }
        return scrollOffset;
    }

    public int computeVerticalScrollExtent() {
        return this.getHeight() - this.getPaddingTop() - this.getPaddingBottom();
    }

    private View getTouchTarget(int touchX, int touchY) {
        View targetView = null;
        List<View> touchableViews = this.getNonGoneChildren();
        for (View touchableView : touchableViews) {
            if (!ScrollUtils.isTouchPointInView(touchableView, touchX, touchY)) continue;
            targetView = touchableView;
            break;
        }
        return targetView;
    }

    private boolean isIntercept(MotionEvent ev) {
        int pointerIndex = ev.findPointerIndex(this.mActivePointerId);
        if (pointerIndex < 0 || pointerIndex >= ev.getPointerCount()) {
            return true;
        }
        return this.isIntercept(ScrollUtils.getRawX((View)this, ev, pointerIndex), ScrollUtils.getRawY((View)this, ev, pointerIndex));
    }

    private boolean isIntercept(int touchX, int touchY) {
        View target = this.getTouchTarget(touchX, touchY);
        if (target != null) {
            return ScrollUtils.isConsecutiveScrollerChild(target);
        }
        return false;
    }

    public void scrollToChild(View view) {
        this.scrollToChildWithOffset(view, 0);
    }

    public void scrollToChildWithOffset(View view, int offset) {
        int scrollToIndex = this.indexOfChild(view);
        if (scrollToIndex != -1) {
            int scrollAnchor = view.getTop() - offset;
            scrollAnchor -= this.getAdjustHeightForChild(view);
            int scrollOrientation = 0;
            if (offset >= 0) {
                if (this.getScrollY() + this.getPaddingTop() > scrollAnchor) {
                    scrollOrientation = -1;
                } else if (this.getScrollY() + this.getPaddingTop() < scrollAnchor) {
                    scrollOrientation = 1;
                } else if (ScrollUtils.canScrollVertically(view, -1)) {
                    scrollOrientation = -1;
                }
            } else {
                int viewScrollOffset = this.getViewsScrollOffset(scrollToIndex);
                if (this.getScrollY() + this.getPaddingTop() + viewScrollOffset > scrollAnchor) {
                    scrollOrientation = -1;
                } else if (this.getScrollY() + this.getPaddingTop() + viewScrollOffset < scrollAnchor) {
                    scrollOrientation = 1;
                }
            }
            if (scrollOrientation != 0) {
                this.mScrollToIndex = scrollToIndex;
                this.stopScroll();
                this.mScrollToIndexWithOffset = offset;
                this.setScrollState(2);
                do {
                    if (scrollOrientation < 0) {
                        this.dispatchScroll(-200);
                    } else {
                        this.dispatchScroll(200);
                    }
                    ++this.mCycleCount;
                } while (this.mScrollToIndex != -1);
            }
        }
    }

    public void smoothScrollToChild(View view) {
        this.smoothScrollToChildWithOffset(view, 0);
    }

    public void smoothScrollToChildWithOffset(View view, int offset) {
        int scrollToIndex = this.indexOfChild(view);
        if (scrollToIndex != -1) {
            int scrollAnchor = view.getTop() - offset;
            scrollAnchor -= this.getAdjustHeightForChild(view);
            int scrollOrientation = 0;
            if (offset >= 0) {
                if (this.getScrollY() + this.getPaddingTop() > scrollAnchor) {
                    scrollOrientation = -1;
                } else if (this.getScrollY() + this.getPaddingTop() < scrollAnchor) {
                    scrollOrientation = 1;
                } else if (ScrollUtils.canScrollVertically(view, -1)) {
                    scrollOrientation = -1;
                }
            } else {
                int viewScrollOffset = this.getViewsScrollOffset(scrollToIndex);
                if (this.getScrollY() + this.getPaddingTop() + viewScrollOffset > scrollAnchor) {
                    scrollOrientation = -1;
                } else if (this.getScrollY() + this.getPaddingTop() + viewScrollOffset < scrollAnchor) {
                    scrollOrientation = 1;
                }
            }
            if (scrollOrientation != 0) {
                this.mScrollToIndex = scrollToIndex;
                this.stopScroll();
                this.mScrollToIndexWithOffset = offset;
                this.setScrollState(2);
                this.mSmoothScrollOffset = scrollOrientation < 0 ? -50 : 50;
                this.invalidate();
            }
        }
    }

    private int getViewsScrollOffset(int index) {
        int offset = 0;
        int count = this.getChildCount();
        for (int i = index; i < count; ++i) {
            View child = this.getChildAt(i);
            if (child.getVisibility() == 8 || !ScrollUtils.isConsecutiveScrollerChild(child)) continue;
            offset += ScrollUtils.computeVerticalScrollOffset(child);
        }
        return offset;
    }

    public boolean isAutoAdjustHeightAtBottomView() {
        return this.mAutoAdjustHeightAtBottomView;
    }

    public void setAutoAdjustHeightAtBottomView(boolean autoAdjustHeightAtBottomView) {
        if (this.mAutoAdjustHeightAtBottomView != autoAdjustHeightAtBottomView) {
            this.mAutoAdjustHeightAtBottomView = autoAdjustHeightAtBottomView;
            this.requestLayout();
        }
    }

    public int getAdjustHeightOffset() {
        return this.mAdjustHeightOffset;
    }

    public void setAdjustHeightOffset(int adjustHeightOffset) {
        if (this.mAdjustHeightOffset != adjustHeightOffset) {
            this.mAdjustHeightOffset = adjustHeightOffset;
            this.requestLayout();
        }
    }

    public void setPermanent(boolean isPermanent) {
        if (this.isPermanent != isPermanent) {
            this.isPermanent = isPermanent;
            if (this.mAutoAdjustHeightAtBottomView) {
                this.requestLayout();
            } else {
                this.resetSticky();
            }
        }
    }

    public boolean isPermanent() {
        return this.isPermanent;
    }

    public boolean isDisableChildHorizontalScroll() {
        return this.disableChildHorizontalScroll;
    }

    public void setDisableChildHorizontalScroll(boolean disableChildHorizontalScroll) {
        this.disableChildHorizontalScroll = disableChildHorizontalScroll;
    }

    public void setStickyOffset(int offset) {
        if (this.mStickyOffset != offset) {
            this.mStickyOffset = offset;
            this.resetSticky();
        }
    }

    public int getStickyOffset() {
        return this.mStickyOffset;
    }

    public View getCurrentStickyView() {
        return this.mCurrentStickyView;
    }

    public List<View> getCurrentStickyViews() {
        return this.mCurrentStickyViews;
    }

    public boolean theChildIsStick(View child) {
        return !this.isPermanent && this.mCurrentStickyView == child || this.isPermanent && this.mCurrentStickyViews.contains(child);
    }

    public OnStickyChangeListener getOnStickyChangeListener() {
        return this.mOnStickyChangeListener;
    }

    public void setOnStickyChangeListener(OnStickyChangeListener l) {
        this.mOnStickyChangeListener = l;
    }

    public OnPermanentStickyChangeListener getOnPermanentStickyChangeListener() {
        return this.mOnPermanentStickyChangeListener;
    }

    public void setOnPermanentStickyChangeListener(OnPermanentStickyChangeListener l) {
        this.mOnPermanentStickyChangeListener = l;
    }

    public void setNestedScrollingEnabled(boolean enabled) {
        this.mChildHelper.setNestedScrollingEnabled(enabled);
    }

    public boolean isNestedScrollingEnabled() {
        return this.mChildHelper.isNestedScrollingEnabled();
    }

    public boolean dispatchNestedFling(float velocityX, float velocityY, boolean consumed) {
        return this.mChildHelper.dispatchNestedFling(velocityX, velocityY, consumed);
    }

    public boolean dispatchNestedPreFling(float velocityX, float velocityY) {
        return this.mChildHelper.dispatchNestedPreFling(velocityX, velocityY);
    }

    public boolean startNestedScroll(int axes, int type) {
        return this.mChildHelper.startNestedScroll(axes, type);
    }

    public void stopNestedScroll(int type) {
        this.mChildHelper.stopNestedScroll(type);
    }

    public void stopNestedScroll() {
        this.stopNestedScroll(0);
    }

    public boolean hasNestedScrollingParent(int type) {
        return this.mChildHelper.hasNestedScrollingParent(type);
    }

    public boolean dispatchNestedScroll(int dxConsumed, int dyConsumed, int dxUnconsumed, int dyUnconsumed, int[] offsetInWindow) {
        return this.mChildHelper.dispatchNestedScroll(dxConsumed, dyConsumed, dxUnconsumed, dyUnconsumed, offsetInWindow);
    }

    public boolean dispatchNestedScroll(int dxConsumed, int dyConsumed, int dxUnconsumed, int dyUnconsumed, @Nullable int[] offsetInWindow, int type) {
        return this.mChildHelper.dispatchNestedScroll(dxConsumed, dyConsumed, dxUnconsumed, dyUnconsumed, offsetInWindow, type);
    }

    public boolean dispatchNestedPreScroll(int dx, int dy, int[] consumed, int[] offsetInWindow) {
        return this.dispatchNestedPreScroll(dx, dy, consumed, offsetInWindow, 0);
    }

    public boolean dispatchNestedPreScroll(int dx, int dy, @Nullable int[] consumed, @Nullable int[] offsetInWindow, int type) {
        return this.mChildHelper.dispatchNestedPreScroll(dx, dy, consumed, offsetInWindow, type);
    }

    public boolean onStartNestedScroll(@NonNull View child, @NonNull View target, int axes, int type) {
        boolean isNestedScroll = false;
        ViewGroup.LayoutParams lp = child.getLayoutParams();
        if (lp instanceof LayoutParams) {
            isNestedScroll = ((LayoutParams)lp).isNestedScroll;
        }
        if (isNestedScroll) {
            return (axes & 2) != 0;
        }
        return false;
    }

    public void onNestedScrollAccepted(@NonNull View child, @NonNull View target, int axes, int type) {
        this.mParentHelper.onNestedScrollAccepted(child, target, axes, type);
        this.checkTargetsScroll(false, false);
        this.startNestedScroll(2, type);
        this.interceptAnimatorByAction(0);
    }

    public void onStopNestedScroll(@NonNull View target, int type) {
        this.mParentHelper.onStopNestedScroll(target, type);
        this.stopNestedScroll(type);
        this.overSpinner();
    }

    public void onNestedScroll(@NonNull View target, int dxConsumed, int dyConsumed, int dxUnconsumed, int dyUnconsumed, int type) {
        this.onNestedScrollInternal(dyUnconsumed, type);
    }

    private void onNestedScrollInternal(int dyUnconsumed, int type) {
        int oldScrollY = this.mSecondScrollY;
        this.dispatchScroll(dyUnconsumed);
        int myConsumed = this.mSecondScrollY - oldScrollY;
        int myUnconsumed = dyUnconsumed - myConsumed;
        this.mChildHelper.dispatchNestedScroll(0, myConsumed, 0, myUnconsumed, null, type);
    }

    public boolean onStartNestedScroll(View child, View target, int nestedScrollAxes) {
        return this.onStartNestedScroll(child, target, nestedScrollAxes, 0);
    }

    public void onNestedScrollAccepted(View child, View target, int nestedScrollAxes) {
        this.onNestedScrollAccepted(child, target, nestedScrollAxes, 0);
    }

    public void onStopNestedScroll(View target) {
        this.onStopNestedScroll(target, 0);
    }

    public void onNestedScroll(View target, int dxConsumed, int dyConsumed, int dxUnconsumed, int dyUnconsumed) {
        this.onNestedScrollInternal(dyUnconsumed, 0);
    }

    public void onNestedPreScroll(View target, int dx, int dy, int[] consumed) {
        this.onNestedPreScroll(target, dx, dy, consumed, 0);
    }

    public int getNestedScrollAxes() {
        return this.mParentHelper.getNestedScrollAxes();
    }

    public void onNestedPreScroll(@NonNull View target, int dx, int dy, @NonNull int[] consumed, int type) {
        this.dispatchNestedPreScroll(dx, dy, consumed, null, type);
    }

    public boolean onNestedFling(@NonNull View target, float velocityX, float velocityY, boolean consumed) {
        if (!consumed) {
            this.dispatchNestedFling(0.0f, velocityY, true);
            this.fling((int)velocityY);
            return true;
        }
        return false;
    }

    public boolean onNestedPreFling(@NonNull View target, float velocityX, float velocityY) {
        return this.dispatchNestedPreFling(velocityX, velocityY);
    }

    public boolean isEnableOverDragMode() {
        return this.overDragMode || this.overDragMaxDistanceOfTop > 0 || this.overDragMaxDistanceOfBottom > 0;
    }

    public void enableOverDragMode(boolean enable) {
        this.overDragMode = enable;
        if (enable) {
            int defaultDistance = Util.dp2px(180.0f);
            if (this.overDragMaxDistanceOfTop <= 0) {
                this.overDragMaxDistanceOfTop = defaultDistance;
            }
            if (this.overDragMaxDistanceOfBottom <= 0) {
                this.overDragMaxDistanceOfBottom = defaultDistance;
            }
        } else {
            this.overDragMaxDistanceOfTop = 0;
            this.overDragMaxDistanceOfBottom = 0;
        }
    }

    public void enableOverDragMode(boolean enable, int topDistance, int bottomDistance) {
        this.overDragMode = enable;
        if (enable) {
            this.overDragMaxDistanceOfTop = topDistance;
            this.overDragMaxDistanceOfBottom = bottomDistance;
        } else {
            this.overDragMaxDistanceOfTop = 0;
            this.overDragMaxDistanceOfBottom = 0;
        }
    }

    public void setOverDragMaxDistanceOfTop(int distance) {
        if (!this.isEnableOverDragMode()) {
            this.enableOverDragMode(true, distance, this.overDragMaxDistanceOfBottom);
        } else {
            this.overDragMaxDistanceOfTop = distance;
        }
    }

    public void setOverDragMaxDistanceOfBottom(int distance) {
        if (!this.isEnableOverDragMode()) {
            this.enableOverDragMode(true, this.overDragMaxDistanceOfTop, distance);
        } else {
            this.overDragMaxDistanceOfBottom = distance;
        }
    }

    public void setOverDragRate(float rate) {
        this.mDragRate = rate;
    }

    public static interface OnPermanentStickyChangeListener {
        public void onStickyChange(@NonNull List<View> var1);
    }

    public static interface OnStickyChangeListener {
        public void onStickyChange(@Nullable View var1, @Nullable View var2);
    }

    public static interface OnScrollChangeListener {
        public void onScrollChange(View var1, int var2, int var3, int var4);
    }

    public static class LayoutParams
    extends ViewGroup.MarginLayoutParams {
        public boolean isConsecutive = true;
        public boolean isNestedScroll = true;
        public boolean isSticky = false;
        public boolean isTriggerScroll = false;
        public boolean isSink = false;
        public int scrollChild = -1;
        public Align align = Align.LEFT;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public LayoutParams(Context c, AttributeSet attrs) {
            super(c, attrs);
            TypedArray a = null;
            try {
                a = c.obtainStyledAttributes(attrs, R.styleable.ConsecutiveScrollerLayout_Layout);
                this.isConsecutive = a.getBoolean(R.styleable.ConsecutiveScrollerLayout_Layout_layout_isConsecutive, true);
                this.isNestedScroll = a.getBoolean(R.styleable.ConsecutiveScrollerLayout_Layout_layout_isNestedScroll, true);
                this.isSticky = a.getBoolean(R.styleable.ConsecutiveScrollerLayout_Layout_layout_isSticky, false);
                this.isTriggerScroll = a.getBoolean(R.styleable.ConsecutiveScrollerLayout_Layout_layout_isTriggerScroll, false);
                this.isSink = a.getBoolean(R.styleable.ConsecutiveScrollerLayout_Layout_layout_isSink, false);
                int type = a.getInt(R.styleable.ConsecutiveScrollerLayout_Layout_layout_align, 1);
                this.align = Align.get(type);
                this.scrollChild = a.getResourceId(R.styleable.ConsecutiveScrollerLayout_Layout_layout_scrollChild, -1);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                if (a != null) {
                    a.recycle();
                }
            }
        }

        public LayoutParams(int width, int height) {
            super(width, height);
        }

        public LayoutParams(ViewGroup.LayoutParams source) {
            super(source);
        }

        public static enum Align {
            LEFT(1),
            RIGHT(2),
            CENTER(3);

            int value;

            private Align(int value) {
                this.value = value;
            }

            static Align get(int value) {
                switch (value) {
                    case 1: {
                        return LEFT;
                    }
                    case 2: {
                        return RIGHT;
                    }
                    case 3: {
                        return CENTER;
                    }
                }
                return LEFT;
            }
        }
    }

    protected class BounceRunnable
    implements Runnable {
        int mFrame = 0;
        int mFrameDelay = 10;
        int mSmoothDistance;
        long mLastTime;
        float mOffset = 0.0f;
        float mVelocity;

        BounceRunnable(float velocity, int smoothDistance) {
            this.mVelocity = velocity;
            this.mSmoothDistance = smoothDistance;
            this.mLastTime = AnimationUtils.currentAnimationTimeMillis();
            ConsecutiveScrollerLayout.this.mHandler.postDelayed((Runnable)this, (long)this.mFrameDelay);
        }

        @Override
        public void run() {
            if (ConsecutiveScrollerLayout.this.animationRunnable == this) {
                this.mVelocity = (float)((double)this.mVelocity * Math.pow(0.85f, ++this.mFrame * 2));
                long now = AnimationUtils.currentAnimationTimeMillis();
                float t = 1.0f * (float)(now - this.mLastTime) / 1000.0f;
                float velocity = this.mVelocity * t;
                if (Math.abs(velocity) >= 1.0f) {
                    this.mLastTime = now;
                    this.mOffset += velocity;
                    int oldScrollY = ConsecutiveScrollerLayout.this.getScrollY();
                    ConsecutiveScrollerLayout.this.moveSpinnerInfinitely(this.mOffset);
                    if (oldScrollY != ConsecutiveScrollerLayout.this.mSecondScrollY) {
                        ConsecutiveScrollerLayout.this.scrollChange(ConsecutiveScrollerLayout.this.mSecondScrollY, oldScrollY);
                    }
                    ConsecutiveScrollerLayout.this.mHandler.postDelayed((Runnable)this, (long)this.mFrameDelay);
                } else {
                    ConsecutiveScrollerLayout.this.animationRunnable = null;
                    int startY = ConsecutiveScrollerLayout.this.getScrollY();
                    int duration = 10 * Math.min(Math.max((int)Util.px2dp(Math.abs(startY - this.mSmoothDistance)), 30), 100);
                    ConsecutiveScrollerLayout.this.animSpinner(startY, this.mSmoothDistance, 0, ConsecutiveScrollerLayout.this.mReboundInterpolator, duration);
                }
            }
        }
    }
}

