/*
 * Decompiled with CFR 0.152.
 */
package com.yongbeam.y_photopicker.util.photopicker.utils;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ResolveInfo;
import android.net.Uri;
import android.os.Bundle;
import android.os.Environment;
import android.os.Parcelable;
import android.support.v4.content.FileProvider;
import android.util.Log;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class ImageCaptureManager {
    private static final String CAPTURED_PHOTO_PATH_KEY = "mCurrentPhotoPath";
    public static final int REQUEST_TAKE_PHOTO = 1;
    private String mCurrentPhotoPath;
    private Context mContext;

    public ImageCaptureManager(Context mContext) {
        this.mContext = mContext;
    }

    private File createImageFile() throws IOException {
        String timeStamp = new SimpleDateFormat("yyyyMMdd_HHmmss").format(new Date());
        String imageFileName = "JPEG_" + timeStamp + "_";
        File storageDir = Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_PICTURES);
        if (!storageDir.exists() && !storageDir.mkdir()) {
            throw new IOException();
        }
        File image = File.createTempFile(imageFileName, ".jpg", storageDir);
        this.mCurrentPhotoPath = image.getAbsolutePath();
        return image;
    }

    public Intent dispatchTakePictureIntent() throws IOException {
        Log.d((String)"TAG", (String)"\uce74\uba54\ub77c \ud638\ucd9c");
        Intent takePictureIntent = new Intent("android.media.action.IMAGE_CAPTURE");
        if (takePictureIntent.resolveActivity(this.mContext.getPackageManager()) != null) {
            ResolveInfo mInfo = this.mContext.getPackageManager().resolveActivity(takePictureIntent, 0);
            takePictureIntent.setComponent(new ComponentName(mInfo.activityInfo.packageName, mInfo.activityInfo.name));
            File photoFile = this.createImageFile();
            if (photoFile != null) {
                Uri uri = FileProvider.getUriForFile((Context)this.mContext, (String)"com.yongbeam.y_photopicker.fileprovider", (File)photoFile);
                takePictureIntent.putExtra("output", (Parcelable)uri);
                Log.d((String)"TAG", (String)("\ud30c\uc77c\uc800\uc7a5" + uri.toString()));
            }
        }
        return takePictureIntent;
    }

    public void galleryAddPic() {
        String dcimPath = Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_DCIM).getAbsolutePath();
        String timeStamp = new SimpleDateFormat("yyyyMMdd_HHmmss").format(new Date());
        String resultImageDri = dcimPath + "/" + timeStamp + ".jpg";
        this.copyFile(this.mCurrentPhotoPath, resultImageDri);
        File tempImage = new File(this.mCurrentPhotoPath);
        File f = new File(resultImageDri);
        Intent mediaIntent = new Intent("android.intent.action.MEDIA_SCANNER_SCAN_FILE");
        mediaIntent.setData(Uri.fromFile((File)f));
        this.mContext.sendBroadcast(mediaIntent);
        if (tempImage.delete()) {
            Log.d((String)"Y-Photo-Picker", (String)"#### DELETE TEMP IMAGE");
        }
    }

    private boolean copyFile(String strSrc, String save_file) {
        boolean result;
        File file = new File(strSrc);
        if (file != null && file.exists()) {
            try {
                FileInputStream fis = new FileInputStream(file);
                FileOutputStream newfos = new FileOutputStream(save_file);
                int readcount = 0;
                byte[] buffer = new byte[1024];
                while ((readcount = fis.read(buffer, 0, 1024)) != -1) {
                    newfos.write(buffer, 0, readcount);
                }
                newfos.close();
                fis.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            result = true;
        } else {
            result = false;
        }
        return result;
    }

    public String getCurrentPhotoPath() {
        return this.mCurrentPhotoPath;
    }

    public void onSaveInstanceState(Bundle savedInstanceState) {
        if (savedInstanceState != null && this.mCurrentPhotoPath != null) {
            savedInstanceState.putString(CAPTURED_PHOTO_PATH_KEY, this.mCurrentPhotoPath);
        }
    }

    public void onRestoreInstanceState(Bundle savedInstanceState) {
        if (savedInstanceState != null && savedInstanceState.containsKey(CAPTURED_PHOTO_PATH_KEY)) {
            this.mCurrentPhotoPath = savedInstanceState.getString(CAPTURED_PHOTO_PATH_KEY);
        }
    }
}

