/*
 * Decompiled with CFR 0.152.
 */
package com.yongbeam.y_photopicker.util.photopicker.adapter;

import android.support.v7.widget.RecyclerView;
import com.yongbeam.y_photopicker.util.photopicker.entity.Photo;
import com.yongbeam.y_photopicker.util.photopicker.entity.PhotoDirectory;
import com.yongbeam.y_photopicker.util.photopicker.event.Selectable;
import java.util.ArrayList;
import java.util.List;

public abstract class SelectableAdapter<VH extends RecyclerView.ViewHolder>
extends RecyclerView.Adapter<VH>
implements Selectable {
    private static final String TAG = SelectableAdapter.class.getSimpleName();
    protected List<PhotoDirectory> photoDirectories = new ArrayList<PhotoDirectory>();
    protected List<Photo> selectedPhotos = new ArrayList<Photo>();
    public int currentDirectoryIndex = 0;

    @Override
    public boolean isSelected(Photo photo) {
        return this.getSelectedPhotos().contains(photo);
    }

    @Override
    public void toggleSelection(Photo photo) {
        if (this.selectedPhotos.contains(photo)) {
            this.selectedPhotos.remove(photo);
        } else {
            this.selectedPhotos.add(photo);
        }
    }

    @Override
    public void clearSelection() {
        this.selectedPhotos.clear();
    }

    @Override
    public int getSelectedItemCount() {
        return this.selectedPhotos.size();
    }

    public void setCurrentDirectoryIndex(int currentDirectoryIndex) {
        this.currentDirectoryIndex = currentDirectoryIndex;
    }

    public List<Photo> getCurrentPhotos() {
        return this.photoDirectories.get(this.currentDirectoryIndex).getPhotos();
    }

    public List<String> getCurrentPhotoPaths() {
        ArrayList<String> currentPhotoPaths = new ArrayList<String>(this.getCurrentPhotos().size());
        for (Photo photo : this.getCurrentPhotos()) {
            currentPhotoPaths.add(photo.getPath());
        }
        return currentPhotoPaths;
    }

    @Override
    public List<Photo> getSelectedPhotos() {
        return this.selectedPhotos;
    }
}

