/*
 * Decompiled with CFR 0.152.
 */
package com.yongbeam.y_photopicker.util.photopicker.adapter;

import android.content.Context;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import com.bumptech.glide.Glide;
import com.yongbeam.y_photopicker.R;
import com.yongbeam.y_photopicker.util.photopicker.adapter.SelectableAdapter;
import com.yongbeam.y_photopicker.util.photopicker.entity.Photo;
import com.yongbeam.y_photopicker.util.photopicker.entity.PhotoDirectory;
import com.yongbeam.y_photopicker.util.photopicker.event.OnItemCheckListener;
import com.yongbeam.y_photopicker.util.photopicker.event.OnPhotoClickListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class PhotoGridAdapter
extends SelectableAdapter<PhotoViewHolder> {
    private LayoutInflater inflater;
    private Context mContext;
    private OnItemCheckListener onItemCheckListener = null;
    private OnPhotoClickListener onPhotoClickListener = null;
    private View.OnClickListener onCameraClickListener = null;
    public static final int ITEM_TYPE_CAMERA = 100;
    public static final int ITEM_TYPE_PHOTO = 101;
    private boolean hasCamera = true;
    private boolean mIsCheckBoxOnly = false;

    public PhotoGridAdapter(Context mContext, List<PhotoDirectory> photoDirectories, boolean isCheckBoxOnly) {
        this.photoDirectories = photoDirectories;
        this.mContext = mContext;
        this.mIsCheckBoxOnly = isCheckBoxOnly;
        this.inflater = LayoutInflater.from((Context)mContext);
    }

    public int getItemViewType(int position) {
        return this.showCamera() && position == 0 ? 100 : 101;
    }

    public PhotoViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        View itemView = this.inflater.inflate(R.layout.util_item_photo, parent, false);
        PhotoViewHolder holder = new PhotoViewHolder(itemView);
        if (viewType == 100) {
            holder.vSelected.setVisibility(8);
            holder.ivPhoto.setScaleType(ImageView.ScaleType.CENTER);
            holder.ivPhoto.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    if (PhotoGridAdapter.this.onCameraClickListener != null) {
                        PhotoGridAdapter.this.onCameraClickListener.onClick(view);
                    }
                }
            });
        }
        return holder;
    }

    public void onBindViewHolder(final PhotoViewHolder holder, int position) {
        if (this.getItemViewType(position) == 101) {
            List<Photo> photos = this.getCurrentPhotos();
            final Photo photo = this.showCamera() ? photos.get(position - 1) : photos.get(position);
            Glide.with((Context)this.mContext).load(new File(photo.getPath())).centerCrop().thumbnail(0.1f).placeholder(R.color.img_loding_placeholder).error(R.color.image_loading_error_color).into(holder.ivPhoto);
            final boolean isChecked = this.isSelected(photo);
            holder.vSelected.setSelected(isChecked);
            holder.ivPhoto.setSelected(isChecked);
            holder.ivPhoto.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    if (PhotoGridAdapter.this.mIsCheckBoxOnly) {
                        boolean isEnable = true;
                        if (PhotoGridAdapter.this.onItemCheckListener != null) {
                            isEnable = PhotoGridAdapter.this.onItemCheckListener.OnItemCheck(holder.getAdapterPosition(), photo, isChecked, PhotoGridAdapter.this.getSelectedPhotos().size());
                        }
                        if (isEnable) {
                            PhotoGridAdapter.this.toggleSelection(photo);
                            PhotoGridAdapter.this.notifyItemChanged(holder.getAdapterPosition());
                        }
                    } else if (PhotoGridAdapter.this.onPhotoClickListener != null) {
                        PhotoGridAdapter.this.onPhotoClickListener.onClick(view, holder.getAdapterPosition(), PhotoGridAdapter.this.showCamera());
                    }
                }
            });
            holder.vSelected.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    boolean isEnable = true;
                    if (PhotoGridAdapter.this.onItemCheckListener != null) {
                        isEnable = PhotoGridAdapter.this.onItemCheckListener.OnItemCheck(holder.getAdapterPosition(), photo, isChecked, PhotoGridAdapter.this.getSelectedPhotos().size());
                    }
                    if (isEnable) {
                        PhotoGridAdapter.this.toggleSelection(photo);
                        PhotoGridAdapter.this.notifyItemChanged(holder.getAdapterPosition());
                    }
                }
            });
        } else {
            holder.ivPhoto.setImageResource(R.drawable.camera);
        }
    }

    public int getItemCount() {
        int photosCount;
        int n = photosCount = this.photoDirectories.size() == 0 ? 0 : this.getCurrentPhotos().size();
        if (this.showCamera()) {
            return photosCount + 1;
        }
        return photosCount;
    }

    public void setOnItemCheckListener(OnItemCheckListener onItemCheckListener) {
        this.onItemCheckListener = onItemCheckListener;
    }

    public void setOnPhotoClickListener(OnPhotoClickListener onPhotoClickListener) {
        this.onPhotoClickListener = onPhotoClickListener;
    }

    public void setOnCameraClickListener(View.OnClickListener onCameraClickListener) {
        this.onCameraClickListener = onCameraClickListener;
    }

    public ArrayList<String> getSelectedPhotoPaths() {
        ArrayList<String> selectedPhotoPaths = new ArrayList<String>(this.getSelectedItemCount());
        for (Photo photo : this.selectedPhotos) {
            selectedPhotoPaths.add(photo.getPath());
        }
        return selectedPhotoPaths;
    }

    public void setShowCamera(boolean hasCamera) {
        this.hasCamera = hasCamera;
    }

    public boolean showCamera() {
        return this.hasCamera && this.currentDirectoryIndex == 0;
    }

    public static class PhotoViewHolder
    extends RecyclerView.ViewHolder {
        private ImageView ivPhoto;
        private View vSelected;

        public PhotoViewHolder(View itemView) {
            super(itemView);
            this.ivPhoto = (ImageView)itemView.findViewById(R.id.iv_photo);
            this.vSelected = itemView.findViewById(R.id.v_selected);
        }
    }
}

