/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.api.model;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.node.NullNode;
import com.github.dockerjava.api.model.VolumeBind;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;

@JsonDeserialize(using=Deserializer.class)
@JsonSerialize(using=Serializer.class)
public class VolumeBinds {
    private final VolumeBind[] binds;

    public VolumeBinds(VolumeBind ... binds) {
        this.binds = binds;
    }

    public VolumeBind[] getBinds() {
        return this.binds;
    }

    public static final class Deserializer
    extends JsonDeserializer<VolumeBinds> {
        public VolumeBinds deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
            ArrayList<VolumeBind> binds = new ArrayList<VolumeBind>();
            ObjectCodec oc = jsonParser.getCodec();
            JsonNode node = (JsonNode)oc.readTree(jsonParser);
            Iterator it = node.fields();
            while (it.hasNext()) {
                Map.Entry field = (Map.Entry)it.next();
                JsonNode value = (JsonNode)field.getValue();
                if (value.equals((Object)NullNode.getInstance())) continue;
                if (!value.isTextual()) {
                    throw deserializationContext.mappingException("Expected path for '" + (String)field.getKey() + "'in host but got '" + value + "'.");
                }
                VolumeBind bind = new VolumeBind(value.asText(), (String)field.getKey());
                binds.add(bind);
            }
            return new VolumeBinds(binds.toArray(new VolumeBind[binds.size()]));
        }
    }

    public static final class Serializer
    extends JsonSerializer<VolumeBinds> {
        public void serialize(VolumeBinds value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            jgen.writeStartObject();
            for (VolumeBind bind : value.binds) {
                jgen.writeStringField(bind.getContainerPath(), bind.getHostPath());
            }
            jgen.writeEndObject();
        }
    }
}

