/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.zerodep.shaded.org.apache.hc.client5.http.async;

import com.github.dockerjava.zerodep.shaded.org.apache.hc.client5.http.HttpRoute;
import com.github.dockerjava.zerodep.shaded.org.apache.hc.client5.http.async.AsyncExecCallback;
import com.github.dockerjava.zerodep.shaded.org.apache.hc.client5.http.async.AsyncExecRuntime;
import com.github.dockerjava.zerodep.shaded.org.apache.hc.client5.http.protocol.HttpClientContext;
import com.github.dockerjava.zerodep.shaded.org.apache.hc.core5.annotation.Contract;
import com.github.dockerjava.zerodep.shaded.org.apache.hc.core5.annotation.Internal;
import com.github.dockerjava.zerodep.shaded.org.apache.hc.core5.annotation.ThreadingBehavior;
import com.github.dockerjava.zerodep.shaded.org.apache.hc.core5.concurrent.CancellableDependency;
import com.github.dockerjava.zerodep.shaded.org.apache.hc.core5.http.HttpException;
import com.github.dockerjava.zerodep.shaded.org.apache.hc.core5.http.HttpRequest;
import com.github.dockerjava.zerodep.shaded.org.apache.hc.core5.http.nio.AsyncEntityProducer;
import com.github.dockerjava.zerodep.shaded.org.apache.hc.core5.util.Args;
import com.github.dockerjava.zerodep.shaded.org.apache.hc.core5.util.TimeValue;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;

@Contract(threading=ThreadingBehavior.STATELESS)
public interface AsyncExecChain {
    public void proceed(HttpRequest var1, AsyncEntityProducer var2, Scope var3, AsyncExecCallback var4) throws HttpException, IOException;

    public static interface Scheduler {
        public void scheduleExecution(HttpRequest var1, AsyncEntityProducer var2, Scope var3, AsyncExecCallback var4, TimeValue var5);

        @Internal
        default public void scheduleExecution(HttpRequest request, AsyncEntityProducer entityProducer, Scope scope, AsyncExecChain chain, AsyncExecCallback asyncExecCallback, TimeValue delay) {
            this.scheduleExecution(request, entityProducer, scope, asyncExecCallback, delay);
        }
    }

    public static final class Scope {
        public final String exchangeId;
        public final HttpRoute route;
        public final HttpRequest originalRequest;
        public final CancellableDependency cancellableDependency;
        public final HttpClientContext clientContext;
        public final AsyncExecRuntime execRuntime;
        public final Scheduler scheduler;
        public final AtomicInteger execCount;

        public Scope(String exchangeId, HttpRoute route, HttpRequest originalRequest, CancellableDependency cancellableDependency, HttpClientContext clientContext, AsyncExecRuntime execRuntime, Scheduler scheduler, AtomicInteger execCount) {
            this.exchangeId = Args.notBlank(exchangeId, "Exchange id");
            this.route = Args.notNull(route, "Route");
            this.originalRequest = Args.notNull(originalRequest, "Original request");
            this.cancellableDependency = Args.notNull(cancellableDependency, "Dependency");
            this.clientContext = Args.notNull(clientContext, "HTTP context");
            this.execRuntime = Args.notNull(execRuntime, "Exec runtime");
            this.scheduler = scheduler;
            this.execCount = execCount != null ? execCount : new AtomicInteger(1);
        }

        @Deprecated
        public Scope(String exchangeId, HttpRoute route, HttpRequest originalRequest, CancellableDependency cancellableDependency, HttpClientContext clientContext, AsyncExecRuntime execRuntime) {
            this(exchangeId, route, originalRequest, cancellableDependency, clientContext, execRuntime, null, new AtomicInteger(1));
        }
    }
}

