/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.core.command;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.dockerjava.api.command.DockerCmd;
import com.github.dockerjava.api.command.DockerCmdSyncExec;
import com.github.dockerjava.api.command.SyncDockerCmd;
import com.github.dockerjava.api.exception.DockerException;
import com.github.dockerjava.api.model.AuthConfig;
import com.google.common.base.Preconditions;
import java.io.IOException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.builder.ReflectionToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstrDockerCmd<CMD_T extends DockerCmd<RES_T>, RES_T>
implements SyncDockerCmd<RES_T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstrDockerCmd.class);
    protected DockerCmdSyncExec<CMD_T, RES_T> execution;

    public AbstrDockerCmd(DockerCmdSyncExec<CMD_T, RES_T> execution) {
        Preconditions.checkNotNull(execution, (Object)"execution was not specified");
        this.execution = execution;
    }

    public RES_T exec() throws DockerException {
        LOGGER.debug("Cmd: {}", (Object)this);
        return (RES_T)this.execution.exec((DockerCmd)this);
    }

    public void close() {
    }

    public String toString() {
        return ReflectionToStringBuilder.toString((Object)this, (ToStringStyle)ToStringStyle.SIMPLE_STYLE);
    }

    protected String registryAuth(AuthConfig authConfig) {
        try {
            return Base64.encodeBase64String((byte[])new ObjectMapper().writeValueAsString((Object)authConfig).getBytes());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

