/*
 * Copyright 2016 Dennis Vriend
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package akka.persistence.query.scaladsl

import akka.NotUsed
import akka.persistence.PersistentRepr
import akka.persistence.query.scaladsl.EventWriter.WriteEvent
import akka.stream.scaladsl.Flow

import scala.collection.immutable.Set

object EventWriter {
  final case class WriteEvent(repr: PersistentRepr, tags: Set[String])
}

/**
 * A plugin may optionally support this query by implementing this interface.
 */
trait EventWriter extends ReadJournal {
  /**
   * Plugin should serialize and write a PersistentRepr to the store.
   * The caller is responsible for ensuring PersistenceId/SequenceNr uniqueness
   */
  def eventWriter: Flow[WriteEvent, WriteEvent, NotUsed]
}
