/*
 * Decompiled with CFR 0.152.
 */
package com.github.dnault.xmlpatch.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.Namespace;
import org.jdom2.Parent;
import org.jdom2.input.SAXBuilder;

public class XmlHelper {
    public static Document parse(File f) throws IOException, JDOMException {
        try (FileInputStream fis = new FileInputStream(f);){
            Document document = XmlHelper.parse(fis);
            return document;
        }
    }

    public static Document parse(InputStream is) throws IOException, JDOMException {
        SAXBuilder builder = new SAXBuilder();
        builder.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        Document doc = builder.build(is);
        return doc;
    }

    public static List<Content> clone(List<Content> content) {
        ArrayList<Content> cloned = new ArrayList<Content>();
        for (Content o : content) {
            cloned.add(o.clone());
        }
        return cloned;
    }

    public static int indexOf(Parent p, Content child) {
        return p.getContent().indexOf(child);
    }

    public static Map<String, String> getInScopeNamespaceDeclarations(Element e) {
        HashMap<String, String> prefixToUri = new HashMap<String, String>();
        while (e != null) {
            XmlHelper.putIfAbsent(prefixToUri, e.getNamespace());
            for (Object o : e.getAdditionalNamespaces()) {
                XmlHelper.putIfAbsent(prefixToUri, (Namespace)o);
            }
            e = e.getParentElement();
        }
        return prefixToUri;
    }

    public static List<Element> getChildren(Element e) {
        return e.getChildren();
    }

    public static List<Element> getChildren(Element e, String name) {
        return e.getChildren(name);
    }

    private static <K, V> boolean putIfAbsent(Map<K, V> map, K key, V value) {
        if (map.containsKey(key)) {
            return false;
        }
        map.put(key, value);
        return true;
    }

    private static boolean putIfAbsent(Map<String, String> prefixToUri, Namespace ns) {
        if (ns == null) {
            return false;
        }
        return XmlHelper.putIfAbsent(prefixToUri, ns.getPrefix(), ns.getURI());
    }
}

