/*
 * Decompiled with CFR 0.152.
 */
package com.github.dnault.xmlpatch;

import com.github.dnault.xmlpatch.PatchException;
import com.github.dnault.xmlpatch.Patcher;
import com.github.dnault.xmlpatch.batch.PatchAssembler;
import com.github.dnault.xmlpatch.internal.IoHelper;
import com.github.dnault.xmlpatch.internal.Log;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionException;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import org.jdom2.Element;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;

public class BatchPatcher {
    private static OptionSet parseOptions(OptionParser parser, String ... args) throws IOException {
        try {
            return parser.parse(args);
        }
        catch (OptionException e) {
            System.err.println(e.getMessage());
            System.err.println();
            parser.printHelpOn((OutputStream)System.err);
            System.exit(1);
            throw new Error();
        }
    }

    public static void main(String ... args) throws Exception {
        BatchPatcher.patch(args);
    }

    public static void patch(String ... args) throws Exception {
        File destdir;
        OptionParser parser = new OptionParser();
        OptionSpecBuilder helpOption = parser.acceptsAll(Arrays.asList("help", "?"), "display this help message");
        ArgumentAcceptingOptionSpec patchOption = parser.accepts("patch", "patch file to apply").withRequiredArg().ofType(File.class).required();
        ArgumentAcceptingOptionSpec srcdirOption = parser.accepts("srcdir", "for multi-file patches, specifies the base dir for the files to be patched").withRequiredArg().ofType(File.class).required();
        ArgumentAcceptingOptionSpec destdirOption = parser.accepts("destdir", "for multi-file patches, specifies the output directory. (default: apply the patch in-place)").withRequiredArg().ofType(File.class);
        OptionSet options = BatchPatcher.parseOptions(parser, args);
        if (options.has((OptionSpec)helpOption)) {
            parser.printHelpOn((OutputStream)System.out);
            System.exit(0);
        }
        File patchFile = (File)patchOption.value(options);
        BatchPatcher.assertFileExists(patchFile, "patch");
        File srcdir = (File)srcdirOption.value(options);
        BatchPatcher.assertDirectoryExists(srcdir, "srcdir");
        File file = destdir = options.has((OptionSpec)destdirOption) ? (File)destdirOption.value(options) : srcdir;
        if (destdir.exists() && !destdir.isDirectory()) {
            throw new IllegalArgumentException("destdir is not a directory: " + destdir.getAbsolutePath());
        }
        File tempdir = IoHelper.createTempDir();
        try {
            Set<String> relativePathsOfPatchedFiles = BatchPatcher.patch(BatchPatcher.assemblePatchDocument(patchFile), srcdir, destdir, tempdir);
            Log.info("writing patched files to destdir: " + destdir.getAbsolutePath());
            for (String path : relativePathsOfPatchedFiles) {
                File tempFile = new File(tempdir, path);
                File destFile = new File(destdir, path);
                IoHelper.makeParentDirectory(destFile);
                IoHelper.move(tempFile, destFile);
            }
            IoHelper.deleteDirectory(tempdir);
        }
        catch (PatchException e) {
            Log.error(e.getMessage());
            System.exit(1);
        }
    }

    public static void assertFileExists(File f, String argname) throws FileNotFoundException {
        if (!f.exists()) {
            throw new FileNotFoundException(argname + " file not found: " + f.getAbsolutePath());
        }
        if (!f.isFile()) {
            throw new IllegalArgumentException(argname + " is not a file: " + f.getAbsolutePath());
        }
    }

    public static void assertDirectoryExists(File f, String argname) throws FileNotFoundException {
        if (!f.exists()) {
            throw new FileNotFoundException(argname + " directory not found: " + f.getAbsolutePath());
        }
        if (!f.isDirectory()) {
            throw new IllegalArgumentException(argname + " is not a directory: " + f.getAbsolutePath());
        }
    }

    private static List<Element> assemblePatchDocument(File patchFile) throws Exception {
        return new PatchAssembler().assemble(patchFile).getDiffs();
    }

    private static Set<String> patch(List<Element> diffs, File srcdir, File destdir, File tempdir) throws Exception {
        HashSet<String> outputFilePaths = new HashSet<String>();
        for (Element diff : diffs) {
            if (diff.getAttribute("file") == null) {
                throw new IllegalArgumentException("diff element missing 'file' attribute");
            }
            String srcfilePath = diff.getAttributeValue("file");
            File fileToPatch = new File(srcfilePath);
            if (fileToPatch.isAbsolute()) {
                throw new IllegalArgumentException("not a relative path: " + srcfilePath);
            }
            outputFilePaths.add(srcfilePath);
            File alreadyInTempDir = new File(tempdir, srcfilePath);
            fileToPatch = alreadyInTempDir.exists() ? alreadyInTempDir : new File(srcdir, srcfilePath);
            Log.info("patching " + srcfilePath + " [from " + fileToPatch.getAbsolutePath() + "]");
            diff.removeAttribute("file");
            Format format = Format.getRawFormat();
            format.setOmitDeclaration(true);
            XMLOutputter outputter = new XMLOutputter(format);
            String s = outputter.outputString(diff);
            ByteArrayInputStream diffStream = new ByteArrayInputStream(s.getBytes("UTF-8"));
            FileInputStream inputStream = new FileInputStream(fileToPatch);
            File outputFile = File.createTempFile("xmlpatch", ".xml");
            FileOutputStream outputStream = new FileOutputStream(outputFile);
            Patcher.patch(inputStream, diffStream, outputStream);
            ((InputStream)inputStream).close();
            ((OutputStream)outputStream).close();
            File outputTemp = new File(tempdir, srcfilePath);
            File tempParentDir = outputTemp.getParentFile();
            if (!tempParentDir.exists() && !tempParentDir.mkdirs()) {
                throw new IOException("failed to create directory: " + tempParentDir.getAbsolutePath());
            }
            IoHelper.move(outputFile, outputTemp);
        }
        return outputFilePaths;
    }
}

