/*
 * Decompiled with CFR 0.152.
 */
package blue.hive.vo;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.text.WordUtils;

public class SearchMap
extends HashMap<String, Object> {
    private static final long serialVersionUID = -7116224054358578695L;

    @Override
    public Object put(String key, Object value) {
        key = StringUtils.removeStart((String)key, (String)"search");
        key = "search" + WordUtils.capitalize((String)key);
        return super.put(key, value);
    }

    @Override
    public Object get(Object keyObj) {
        String key = (String)keyObj;
        if (!this.containsKey(key)) {
            key = "search" + WordUtils.capitalize((String)key);
        }
        return super.get(key);
    }

    public SearchMap add(String key, Object value) {
        this.put(key, value);
        return this;
    }

    public SearchMap(Map<? extends String, ? extends Object> map) {
        for (Map.Entry<? extends String, ? extends Object> entry : map.entrySet()) {
            if (entry.getValue() instanceof String[]) {
                String[] values = (String[])entry.getValue();
                if (values.length == 0) continue;
                if (values.length == 1) {
                    this.put(entry.getKey(), (Object)this.decodeURIComponent(values[0]));
                    continue;
                }
                for (String value : values) {
                    value = this.decodeURIComponent(value);
                }
                this.put(entry.getKey(), (Object)Arrays.asList(values));
                continue;
            }
            if (entry.getValue() instanceof String) {
                this.put(entry.getKey(), (Object)this.decodeURIComponent((String)entry.getValue()));
                continue;
            }
            this.put(entry.getKey(), entry.getValue());
        }
    }

    private String decodeURIComponent(String value) {
        try {
            return URLDecoder.decode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return value;
        }
    }

    public SearchMap() {
    }

    public SearchMap(ServletRequest request) {
        this(request.getParameterMap());
    }

    public static SearchMap buildFrom(Map<? extends String, ? extends Object> map) {
        return new SearchMap(map);
    }

    public static SearchMap buildFrom(ServletRequest request) {
        return new SearchMap(request);
    }
}

