/*
 * Decompiled with CFR 0.152.
 */
package blue.hive.validation.constraints.impl;

import blue.hive.validation.constraints.BHiveAllowExtensions;
import blue.hive.validation.constraints.impl.BHiveConstraintValidator;
import java.util.ArrayList;
import javax.validation.ConstraintValidatorContext;
import org.apache.commons.io.FilenameUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.multipart.MultipartFile;

public class BHiveAllowExtensionsForListOfMultipartFile
extends BHiveConstraintValidator<BHiveAllowExtensions, ArrayList<MultipartFile>> {
    protected String allowExtensionsString = "";
    protected ArrayList<String> allowExtensions = new ArrayList();

    @Override
    public void initialize(BHiveAllowExtensions constraintAnnotation) {
        String[] extentions;
        this.allowExtensionsString = constraintAnnotation.value();
        for (String extention : extentions = StringUtils.tokenizeToStringArray((String)this.allowExtensionsString, (String)",")) {
            this.allowExtensions.add(extention.toLowerCase());
        }
    }

    @Override
    public boolean isValid(ArrayList<MultipartFile> listValue, ConstraintValidatorContext context) {
        if (listValue == null || listValue.isEmpty()) {
            return true;
        }
        boolean allowedAll = true;
        for (MultipartFile value : listValue) {
            boolean allowedTemp = false;
            String filename = value.getOriginalFilename();
            if (!StringUtils.isEmpty((Object)filename)) {
                String extension = FilenameUtils.getExtension((String)filename).toLowerCase();
                for (String allowExtension : this.allowExtensions) {
                    if (!allowExtension.equalsIgnoreCase(extension)) continue;
                    allowedTemp = true;
                    break;
                }
            } else {
                allowedTemp = true;
            }
            boolean bl = allowedAll = allowedAll && allowedTemp;
            if (!this.logger.isTraceEnabled()) continue;
            this.logger.trace("isValid({}) allowextension:{} => allowed: {}, allowedAll: {}", new Object[]{filename, this.allowExtensionsString, allowedTemp, allowedAll});
        }
        return allowedAll;
    }
}

