/*
 * Decompiled with CFR 0.152.
 */
package blue.hive.spring.web.rest.jsonview;

import blue.hive.spring.web.rest.BHiveView;
import blue.hive.spring.web.rest.jsonview.BHiveSort;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonView;
import java.util.Iterator;
import java.util.List;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Slice;
import org.springframework.data.domain.Sort;

public class BHivePageImpl<T>
implements Page<T>,
Slice<T> {
    @JsonIgnore
    private Page<T> page;

    public BHivePageImpl(Page<T> page) {
        this.page = page;
    }

    public BHivePageImpl(List<T> content, Pageable pageable, long total) {
        this.page = new PageImpl(content, pageable, total);
    }

    public Iterator<T> iterator() {
        return this.page.iterator();
    }

    @JsonView(value={BHiveView.BaseView.class})
    public int getNumber() {
        return this.page.getNumber();
    }

    @JsonView(value={BHiveView.BaseView.class})
    public int getSize() {
        return this.page.getSize();
    }

    @JsonView(value={BHiveView.BaseView.class})
    public int getNumberOfElements() {
        return this.page.getNumberOfElements();
    }

    @JsonView(value={BHiveView.BaseView.class})
    public List<T> getContent() {
        return this.page.getContent();
    }

    @JsonView(value={BHiveView.BaseView.class})
    public boolean hasContent() {
        return this.page.hasContent();
    }

    @JsonView(value={BHiveView.BaseView.class})
    public Sort getSort() {
        BHiveSort ableSort = BHiveSort.buildFrom(this.page.getSort());
        return ableSort;
    }

    @JsonView(value={BHiveView.BaseView.class})
    public boolean isFirst() {
        return this.page.isFirst();
    }

    @JsonView(value={BHiveView.BaseView.class})
    public boolean isLast() {
        return this.page.isLast();
    }

    @JsonView(value={BHiveView.BaseView.class})
    public boolean hasNext() {
        return this.page.hasNext();
    }

    @JsonView(value={BHiveView.BaseView.class})
    public boolean hasPrevious() {
        return this.page.hasPrevious();
    }

    public Pageable nextPageable() {
        return this.page.nextPageable();
    }

    public Pageable previousPageable() {
        return this.page.previousPageable();
    }

    @JsonView(value={BHiveView.BaseView.class})
    public int getTotalPages() {
        return this.page.getTotalPages();
    }

    @JsonView(value={BHiveView.BaseView.class})
    public long getTotalElements() {
        return this.page.getTotalElements();
    }

    public <S> Page<S> map(Converter<? super T, ? extends S> converter) {
        return this.page.map(converter);
    }
}

