/*
 * Decompiled with CFR 0.152.
 */
package blue.hive.spring.web.multipart;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.PathMatcher;
import org.springframework.web.multipart.MultipartException;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.multipart.MultipartResolver;

public class BHiveDelegatingMultipartResolver
implements MultipartResolver,
InitializingBean {
    static final Logger logger = LoggerFactory.getLogger(BHiveDelegatingMultipartResolver.class);
    private List<String> excludePatterns = new ArrayList<String>();
    private PathMatcher pathMatcher = new AntPathMatcher();
    private MultipartResolver multipartResolver = null;

    public List<String> getExcludePatterns() {
        return this.excludePatterns;
    }

    public void setExcludePatterns(List<String> excludePatterns) {
        this.excludePatterns = excludePatterns;
    }

    public PathMatcher getPathMatcher() {
        return this.pathMatcher;
    }

    public void setPathMatcher(PathMatcher pathMatcher) {
        this.pathMatcher = pathMatcher;
    }

    public MultipartResolver getMultipartResolver() {
        return this.multipartResolver;
    }

    public void setMultipartResolver(MultipartResolver multipartResolver) {
        this.multipartResolver = multipartResolver;
    }

    public BHiveDelegatingMultipartResolver() {
    }

    public BHiveDelegatingMultipartResolver(MultipartResolver multipartResolver) {
        this.multipartResolver = multipartResolver;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.multipartResolver == null) {
            logger.error("\uc704\uc784\ud560 MultipartResolver\uac00 \uc9c0\uc815\ub418\uc5b4 \uc788\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4.");
            throw new RuntimeException("\uc704\uc784\ud560 MultipartResolver\uac00 \uc9c0\uc815\ub418\uc5b4 \uc788\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4.");
        }
    }

    protected boolean isExcludeUrlPattern(HttpServletRequest request) {
        if (this.excludePatterns == null || this.excludePatterns.size() == 0) {
            return false;
        }
        String servletPath = request.getServletPath();
        for (String excludePattern : this.excludePatterns) {
            boolean isMatch = this.pathMatcher.match(excludePattern, servletPath);
            logger.trace("isExcludeUrlPattern => {}, {} => {}", new Object[]{excludePattern, servletPath, isMatch});
            if (!isMatch) continue;
            logger.trace("isExcludeUrlPattern => true");
            return true;
        }
        logger.trace("isExcludeUrlPattern => false");
        return false;
    }

    public boolean isMultipart(HttpServletRequest request) {
        if (this.isExcludeUrlPattern(request)) {
            return false;
        }
        return this.multipartResolver.isMultipart(request);
    }

    public MultipartHttpServletRequest resolveMultipart(HttpServletRequest request) throws MultipartException {
        if (this.isExcludeUrlPattern(request)) {
            return null;
        }
        return this.multipartResolver.resolveMultipart(request);
    }

    public void cleanupMultipart(MultipartHttpServletRequest request) {
        if (this.isExcludeUrlPattern((HttpServletRequest)request)) {
            return;
        }
        this.multipartResolver.cleanupMultipart(request);
    }
}

