/*
 * Decompiled with CFR 0.152.
 */
package blue.hive.spring.http;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import org.apache.commons.io.input.TeeInputStream;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpInputMessage;
import org.springframework.util.StringUtils;

public class BHiveTeeHttpInputMessage
implements HttpInputMessage {
    HttpInputMessage httpInputMessage;
    InputStream customBodyStream;
    ByteArrayOutputStream baos;

    public BHiveTeeHttpInputMessage(HttpInputMessage httpInputMessage) throws IOException {
        this.httpInputMessage = httpInputMessage;
        this.baos = new ByteArrayOutputStream();
        this.customBodyStream = new TeeInputStream(httpInputMessage.getBody(), (OutputStream)this.baos);
    }

    public HttpHeaders getHeaders() {
        return this.httpInputMessage.getHeaders();
    }

    public InputStream getBody() throws IOException {
        return this.customBodyStream;
    }

    public byte[] getTeeInputBytes() {
        return this.baos.toByteArray();
    }

    public String getTeeInputString() throws UnsupportedEncodingException {
        return StringUtils.trimTrailingWhitespace((String)this.baos.toString("UTF-8"));
    }
}

