/*
 * Decompiled with CFR 0.152.
 */
package blue.hive.spring.core.convert;

import blue.hive.exception.BHiveConvertException;
import blue.hive.util.BHiveDateUtil;
import org.joda.time.LocalDateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.convert.converter.Converter;

public class BHiveStringToJodaLocalDateTimeConverter
implements Converter<String, LocalDateTime> {
    private final Logger logger = LoggerFactory.getLogger(BHiveStringToJodaLocalDateTimeConverter.class);

    public LocalDateTime convert(String dateString) {
        try {
            this.logger.trace("convert({})", (Object)dateString);
            return BHiveDateUtil.parseToLocalDateTime(dateString);
        }
        catch (Exception e) {
            this.logger.trace("convert({}) - Exception: {}", (Object)dateString, (Object)e.toString());
            throw new BHiveConvertException("Cannot convert dateString to Joda DateTime.", e);
        }
    }
}

