/*
 * Decompiled with CFR 0.152.
 */
package blue.hive.mybatis.typehandler;

import blue.hive.type.BHiveValueEnum;
import blue.hive.util.BHiveEnumUtil;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.ibatis.type.BaseTypeHandler;
import org.apache.ibatis.type.JdbcType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BHiveEnumTypeHandler<E extends Enum<E>>
extends BaseTypeHandler<E> {
    private Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private Class<E> type;
    private final E[] enums;

    public BHiveEnumTypeHandler(Class<E> type) {
        this.type = type;
        this.enums = (Enum[])type.getEnumConstants();
        if (this.enums == null) {
            throw new IllegalArgumentException(type.getSimpleName() + " does not represent an enum type.");
        }
    }

    private E parseToValue(String value) throws SQLException {
        return BHiveEnumUtil.parseEnumValueOf(this.type, value);
    }

    private String convertToString(Enum<E> param) {
        String result;
        String string = result = param == null ? "" : param.toString();
        if (param instanceof BHiveValueEnum) {
            BHiveValueEnum typedParam = (BHiveValueEnum)((Object)param);
            result = typedParam.getValue().toString();
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace(param + " -> \"" + result + "\"");
        }
        return result;
    }

    public void setNonNullParameter(PreparedStatement ps, int i, E parameter, JdbcType jdbcType) throws SQLException {
        ps.setString(i, this.convertToString((Enum<E>)parameter));
    }

    public E getNullableResult(ResultSet rs, String columnName) throws SQLException {
        return this.parseToValue(rs.getString(columnName));
    }

    public E getNullableResult(ResultSet rs, int columnIndex) throws SQLException {
        return this.parseToValue(rs.getString(columnIndex));
    }

    public E getNullableResult(CallableStatement cs, int columnIndex) throws SQLException {
        return this.parseToValue(cs.getString(columnIndex));
    }
}

