/*
 * Decompiled with CFR 0.152.
 */
package blue.hive.mybatis.support;

import java.sql.Connection;
import java.util.List;
import java.util.Map;
import org.apache.ibatis.executor.BatchResult;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.SqlSessionTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;

public class BHiveSqlSessionDaoSupport
implements InitializingBean {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private SqlSession sqlSession;
    private boolean externalSqlSession;

    @Autowired
    public void setSqlSession(SqlSession sqlSession) {
        this.sqlSession = sqlSession;
    }

    protected void setSqlSessionFactory(SqlSessionFactory sqlSessionFactory) {
        if (!this.externalSqlSession) {
            this.sqlSession = new SqlSessionTemplate(sqlSessionFactory);
        }
    }

    protected void setSqlSessionTemplate(SqlSessionTemplate sqlSessionTemplate) {
        this.sqlSession = sqlSessionTemplate;
        this.externalSqlSession = true;
    }

    public void afterPropertiesSet() throws IllegalArgumentException, BeanInitializationException {
        this.checkDaoConfig();
        try {
            this.initDao();
        }
        catch (Exception ex) {
            throw new BeanInitializationException("Initialization of DAO failed", (Throwable)ex);
        }
    }

    protected void checkDaoConfig() {
        Assert.notNull((Object)this.sqlSession, (String)"Property 'sqlSessionFactory' or 'sqlSessionTemplate' are required");
    }

    protected void initDao() throws Exception {
    }

    protected SqlSession getSqlSession() {
        return this.sqlSession;
    }

    protected <T> T selectOne(String statement) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("SQL ===>[" + statement + "]");
        }
        return (T)this.sqlSession.selectOne(statement);
    }

    protected <T> T selectOne(String statement, Object parameter) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("SQL ===>[" + statement + "]");
        }
        return (T)this.sqlSession.selectOne(statement, parameter);
    }

    protected <E> List<E> selectList(String statement) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("SQL ===>[" + statement + "]");
        }
        return this.sqlSession.selectList(statement);
    }

    protected <E> List<E> selectList(String statement, Object parameter) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("SQL ===>[" + statement + "]");
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("PARAM =>[" + parameter + "]");
        }
        return this.sqlSession.selectList(statement, parameter);
    }

    protected <E> List<E> selectList(String statement, Object parameter, RowBounds rowBounds) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("SQL ===>[" + statement + "]");
        }
        return this.sqlSession.selectList(statement, parameter, rowBounds);
    }

    protected <K, V> Map<K, V> selectMap(String statement, String mapKey) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("SQL ===>[" + statement + "]");
        }
        return this.sqlSession.selectMap(statement, mapKey);
    }

    protected <K, V> Map<K, V> selectMap(String statement, Object parameter, String mapKey) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("SQL ===>[" + statement + "]");
        }
        return this.sqlSession.selectMap(statement, parameter, mapKey);
    }

    protected <K, V> Map<K, V> selectMap(String statement, Object parameter, String mapKey, RowBounds rowBounds) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("SQL ===>[" + statement + "]");
        }
        return this.sqlSession.selectMap(statement, parameter, mapKey, rowBounds);
    }

    protected void select(String statement, Object parameter, ResultHandler<?> handler) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("SQL ===>[" + statement + "]");
        }
        this.sqlSession.select(statement, parameter, handler);
    }

    protected void select(String statement, ResultHandler<?> handler) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("SQL ===>[" + statement + "]");
        }
        this.sqlSession.select(statement, handler);
    }

    protected void select(String statement, Object parameter, RowBounds rowBounds, ResultHandler<?> handler) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("SQL ===>[" + statement + "]");
        }
        this.sqlSession.select(statement, parameter, rowBounds, handler);
    }

    protected int insert(String statement) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("SQL ===>[" + statement + "]");
        }
        return this.sqlSession.insert(statement);
    }

    protected int insert(String statement, Object parameter) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("SQL ===>[" + statement + "]");
        }
        return this.sqlSession.insert(statement, parameter);
    }

    protected int update(String statement) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("SQL ===>[" + statement + "]");
        }
        return this.sqlSession.update(statement);
    }

    protected int update(String statement, Object parameter) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("SQL ===>[" + statement + "]");
        }
        return this.sqlSession.update(statement, parameter);
    }

    protected int delete(String statement) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("SQL ===>[" + statement + "]");
        }
        return this.sqlSession.delete(statement);
    }

    protected int delete(String statement, Object parameter) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("SQL ===>[" + statement + "]");
        }
        return this.sqlSession.delete(statement, parameter);
    }

    protected void commit() {
        this.sqlSession.commit();
    }

    protected void commit(boolean force) {
        this.sqlSession.commit(force);
    }

    protected void rollback() {
        this.sqlSession.rollback();
    }

    protected void rollback(boolean force) {
        this.sqlSession.rollback(force);
    }

    protected List<BatchResult> flushStatements() {
        return this.sqlSession.flushStatements();
    }

    protected void close() {
        this.sqlSession.close();
    }

    protected void clearCache() {
        this.sqlSession.clearCache();
    }

    protected Configuration getConfiguration() {
        return this.sqlSession.getConfiguration();
    }

    protected <T> T getMapper(Class<T> type) {
        return (T)this.sqlSession.getMapper(type);
    }

    protected Connection getConnection() {
        return this.sqlSession.getConnection();
    }

    public static String getCurrentMethodName() {
        StackTraceElement[] stacks = Thread.currentThread().getStackTrace();
        int depth = 0;
        for (StackTraceElement stack : stacks) {
            if (stack.getClassName().equals("java.lang.Thread") && (stack.getMethodName().equals("getStackTraceImpl") || stack.getMethodName().equals("getStackTrace"))) continue;
            if (depth == 1) {
                return stack.getClassName() + "." + stack.getMethodName();
            }
            ++depth;
        }
        throw new RuntimeException("#### FAILED to getCurrentMethodName ####");
    }
}

