/*
 * Decompiled with CFR 0.152.
 */
package blue.hive.crypto;

import blue.hive.exception.BHiveRuntimeException;
import blue.hive.io.BHiveBase64InputStream;
import blue.hive.io.BHiveBase64OutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.security.Key;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AES256Crypto {
    Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final Charset UTF8 = Charset.forName("UTF-8");
    private static final String DEFAULT_CIPHER_ALGORITHM = "AES/CBC/PKCS5Padding";
    private static byte[] DEFAULT_IV = new byte[16];
    String cipherAlgorithm = null;
    String secretKey;
    byte[] iv;
    SecretKeySpec secretSpec = null;
    IvParameterSpec ivSpec = null;

    public String getSecretKey() {
        return this.secretKey;
    }

    public void setSecretKey(String secretKey) {
        if (secretKey.length() > 24) {
            this.secretKey = StringUtils.rightPad((String)secretKey, (int)32, (String)"\u0000");
        } else if (secretKey.length() > 16) {
            this.secretKey = StringUtils.rightPad((String)secretKey, (int)24, (String)"\u0000");
        } else if (secretKey.length() > 0) {
            this.secretKey = StringUtils.rightPad((String)secretKey, (int)16, (String)"\u0000");
        }
    }

    public AES256Crypto() {
        this(DEFAULT_CIPHER_ALGORITHM, "", DEFAULT_IV);
    }

    public AES256Crypto(String secretKey) {
        this(DEFAULT_CIPHER_ALGORITHM, secretKey, DEFAULT_IV);
    }

    public AES256Crypto(String cipherAlgorithm, String secretKey) {
        this(cipherAlgorithm, secretKey, DEFAULT_IV);
    }

    public AES256Crypto(String cipherAlgorithm, String secretKey, byte[] iv) {
        this.cipherAlgorithm = cipherAlgorithm;
        this.setSecretKey(secretKey);
        this.iv = Arrays.copyOf(iv, iv.length);
    }

    public Cipher getEncryptChiper() throws Exception {
        try {
            this.secretSpec = new SecretKeySpec(this.secretKey.getBytes("UTF-8"), "AES");
            this.ivSpec = new IvParameterSpec(this.iv);
            Cipher cipher = Cipher.getInstance(this.cipherAlgorithm);
            if (this.cipherAlgorithm.contains("ECB")) {
                cipher.init(1, this.secretSpec);
            } else {
                cipher.init(1, (Key)this.secretSpec, this.ivSpec);
            }
            return cipher;
        }
        catch (Exception ex) {
            this.logger.warn("getEncryptChiper FAILED. cipherAlgorithm:{}, secretKey:{}, iv:{} - EXCEPTION: {} - {}", new Object[]{this.cipherAlgorithm, this.secretKey, this.iv, ex.getClass().getName(), ex.getMessage()});
            throw ex;
        }
    }

    public Cipher getDecryptChiper() throws Exception {
        try {
            this.secretSpec = new SecretKeySpec(this.secretKey.getBytes("UTF-8"), "AES");
            this.ivSpec = new IvParameterSpec(this.iv);
            Cipher cipher = Cipher.getInstance(this.cipherAlgorithm);
            if (this.cipherAlgorithm.contains("ECB")) {
                cipher.init(2, this.secretSpec);
            } else {
                cipher.init(2, (Key)this.secretSpec, this.ivSpec);
            }
            return cipher;
        }
        catch (Exception ex) {
            this.logger.warn("getDecryptChiper FAILED. cipherAlgorithm:{}, secretKey:{}, iv:{} - EXCEPTION: {} - {}", new Object[]{this.cipherAlgorithm, this.secretKey, this.iv, ex.getClass().getName(), ex.getMessage()});
            throw ex;
        }
    }

    public byte[] encryptString(String plainString) {
        return this.encryptString(plainString, UTF8);
    }

    public byte[] encryptString(String plainString, Charset charset) {
        if (org.springframework.util.StringUtils.isEmpty((Object)plainString)) {
            this.logger.warn("encryptString FAILED. -> plainString is empty.");
            return null;
        }
        byte[] cipherBytes = null;
        try {
            Cipher cipher = this.getEncryptChiper();
            byte[] plainBytes = plainString.getBytes(charset);
            if (this.cipherAlgorithm.contains("ECB") && plainBytes.length % 16 != 0) {
                int size = plainBytes.length + (16 - plainBytes.length % 16);
                byte[] plainBytesPadded = new byte[size];
                Arrays.fill(plainBytesPadded, (byte)0);
                System.arraycopy(plainBytes, 0, plainBytesPadded, 0, plainBytes.length);
                plainBytes = plainBytesPadded;
            }
            cipherBytes = cipher.doFinal(plainBytes);
        }
        catch (Exception ex) {
            this.logger.warn("encryptString FAILED. plainString: {} - EXCEPTION: {} - {}", new Object[]{plainString, ex.getClass().getName(), ex.getMessage()});
        }
        return cipherBytes;
    }

    public String encryptStringToBase64(String plainString) {
        return this.encryptStringToBase64(plainString, UTF8);
    }

    public String encryptStringToBase64(String plainString, Charset charset) {
        byte[] cipherBytes = this.encryptString(plainString, charset);
        if (cipherBytes != null) {
            this.logger.trace("cipherBytes: " + Arrays.toString(cipherBytes));
            byte[] cipherBytesBase64Encoded = Base64.encodeBase64((byte[])cipherBytes);
            this.logger.trace("cipherBytesBase64Encoded: " + Arrays.toString(cipherBytesBase64Encoded));
            return new String(cipherBytesBase64Encoded, charset);
        }
        return plainString;
    }

    public OutputStream getEncryptChiperOutputStream(OutputStream os) {
        return this.getEncryptChiperOutputStream(os, true);
    }

    public OutputStream getEncryptChiperOutputStream(OutputStream os, boolean useBase64) {
        if (os == null) {
            throw new IllegalArgumentException("OutputStream 'os' parameter cannot be null.");
        }
        try {
            if (useBase64) {
                os = new BHiveBase64OutputStream((OutputStream)os);
            }
            CipherOutputStream osEncrypted = new CipherOutputStream((OutputStream)os, this.getEncryptChiper());
            return osEncrypted;
        }
        catch (Exception ex) {
            this.logger.warn("getEncryptChiperOutputStream FAILED. EXCEPTION: {}", (Object)ex.getMessage(), (Object)ex);
            throw new BHiveRuntimeException("FAILED TO CREATE ENCRYPT OUTPUTSTREAM.", ex);
        }
    }

    public String decryptBytes(byte[] chiperBytes) {
        return this.decryptBytes(chiperBytes, UTF8);
    }

    public String decryptBytes(byte[] chiperBytes, Charset charset) {
        if (chiperBytes == null || chiperBytes.length == 0) {
            this.logger.warn("decryptBytes FAILED. -> chiperBytes is empty.");
            return null;
        }
        String plainString = null;
        try {
            Cipher cipher = this.getDecryptChiper();
            byte[] plainBytes = cipher.doFinal(chiperBytes);
            plainString = new String(plainBytes, charset);
        }
        catch (Exception ex) {
            this.logger.warn("decryptBytes FAILED. - EXCEPTION: {} - {}", (Object)ex.getClass().getName(), (Object)ex.getMessage());
        }
        return plainString;
    }

    public String decryptBase64String(String cipherBase64String) {
        return this.decryptBase64String(cipherBase64String, UTF8);
    }

    public String decryptBase64String(String cipherBase64String, Charset charset) {
        if (org.springframework.util.StringUtils.isEmpty((Object)cipherBase64String)) {
            this.logger.warn("decryptBase64String FAILED -> cipherBase64String is empty.");
            return null;
        }
        byte[] cipherBytes = Base64.decodeBase64((String)cipherBase64String);
        String plainString = this.decryptBytes(cipherBytes, charset);
        plainString = org.springframework.util.StringUtils.trimTrailingWhitespace((String)plainString);
        return org.springframework.util.StringUtils.trimWhitespace((String)plainString);
    }

    public InputStream getDecryptChiperInputStream(InputStream is) {
        return this.getDecryptChiperInputStream(is, true);
    }

    public InputStream getDecryptChiperInputStream(InputStream is, boolean useBase64) {
        if (is == null) {
            throw new IllegalArgumentException("InputStream 'is' parameter cannot be null.");
        }
        try {
            if (useBase64) {
                is = new BHiveBase64InputStream((InputStream)is);
            }
            CipherInputStream isDecrypted = new CipherInputStream((InputStream)is, this.getDecryptChiper());
            return isDecrypted;
        }
        catch (Exception ex) {
            this.logger.warn("getDecryptChiperInputStream FAILED. EXCEPTION: {} - {}", (Object)ex.getClass().getName(), (Object)ex.getMessage());
            throw new BHiveRuntimeException("FAILED TO CREATE DECRYPT INPUTSTREAM.", ex);
        }
    }

    static {
        Arrays.fill(DEFAULT_IV, (byte)0);
    }
}

