/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hslf.record;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;
import org.apache.poi.hslf.record.PersistRecord;
import org.apache.poi.hslf.record.PositionDependentRecord;
import org.apache.poi.hslf.record.RecordAtom;
import org.apache.poi.hslf.record.RecordTypes;
import org.apache.poi.util.BoundedInputStream;
import org.apache.poi.util.LittleEndian;

public class ExOleObjStg
extends RecordAtom
implements PositionDependentRecord,
PersistRecord {
    private int _persistId;
    private final byte[] _header = new byte[8];
    private byte[] _data;
    protected int myLastOnDiskOffset;

    public ExOleObjStg() {
        this._data = new byte[0];
        LittleEndian.putShort((byte[])this._header, (int)0, (short)16);
        LittleEndian.putShort((byte[])this._header, (int)2, (short)((short)this.getRecordType()));
        LittleEndian.putInt((byte[])this._header, (int)4, (int)this._data.length);
    }

    protected ExOleObjStg(byte[] source, int start, int len) {
        System.arraycopy(source, start, this._header, 0, 8);
        this._data = new byte[len - 8];
        System.arraycopy(source, start + 8, this._data, 0, len - 8);
    }

    public boolean isCompressed() {
        return LittleEndian.getShort((byte[])this._header, (int)0) != 0;
    }

    public int getDataLength() {
        if (this.isCompressed()) {
            return LittleEndian.getInt((byte[])this._data, (int)0);
        }
        return this._data.length;
    }

    public InputStream getData() {
        if (this.isCompressed()) {
            int size = LittleEndian.getInt((byte[])this._data);
            ByteArrayInputStream compressedStream = new ByteArrayInputStream(this._data, 4, this._data.length);
            return new BoundedInputStream((InputStream)new InflaterInputStream(compressedStream), (long)size);
        }
        return new ByteArrayInputStream(this._data, 0, this._data.length);
    }

    public byte[] getRawData() {
        return this._data;
    }

    public void setData(byte[] data) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] b = new byte[4];
        LittleEndian.putInt((byte[])b, (int)0, (int)data.length);
        out.write(b);
        DeflaterOutputStream def = new DeflaterOutputStream(out);
        def.write(data, 0, data.length);
        def.finish();
        this._data = out.toByteArray();
        LittleEndian.putInt((byte[])this._header, (int)4, (int)this._data.length);
    }

    @Override
    public long getRecordType() {
        return RecordTypes.ExOleObjStg.typeID;
    }

    @Override
    public void writeOut(OutputStream out) throws IOException {
        out.write(this._header);
        out.write(this._data);
    }

    @Override
    public int getPersistId() {
        return this._persistId;
    }

    @Override
    public void setPersistId(int id) {
        this._persistId = id;
    }

    @Override
    public int getLastOnDiskOffset() {
        return this.myLastOnDiskOffset;
    }

    @Override
    public void setLastOnDiskOffset(int offset) {
        this.myLastOnDiskOffset = offset;
    }

    @Override
    public void updateOtherRecordReferences(Map<Integer, Integer> oldToNewReferencesLookup) {
    }
}

