/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jooq.BatchBindStep;
import org.jooq.Configuration;
import org.jooq.DSLContext;
import org.jooq.DataType;
import org.jooq.Field;
import org.jooq.Param;
import org.jooq.Query;
import org.jooq.conf.ParamType;
import org.jooq.conf.SettingsTools;
import org.jooq.exception.ControlFlowSignal;
import org.jooq.impl.BatchMultiple;
import org.jooq.impl.DSL;
import org.jooq.impl.DefaultBindContext;
import org.jooq.impl.DefaultExecuteContext;
import org.jooq.impl.ExecuteListeners;
import org.jooq.impl.ParamCollector;
import org.jooq.impl.Utils;
import org.jooq.tools.JooqLogger;

class BatchSingle
implements BatchBindStep {
    private static final long serialVersionUID = 3793967258181493207L;
    private static final JooqLogger log = JooqLogger.getLogger(BatchSingle.class);
    private final DSLContext create;
    private final Configuration configuration;
    private final Query query;
    private final Map<String, List<Integer>> nameToIndexMapping;
    private final List<Object[]> allBindValues;
    private final int expectedBindValues;

    public BatchSingle(Configuration configuration, Query query) {
        int i = 0;
        ParamCollector collector = new ParamCollector(configuration, false);
        collector.visit(query);
        this.create = DSL.using(configuration);
        this.configuration = configuration;
        this.query = query;
        this.allBindValues = new ArrayList<Object[]>();
        this.nameToIndexMapping = new LinkedHashMap<String, List<Integer>>();
        this.expectedBindValues = collector.resultList.size();
        for (Map.Entry<String, Param<?>> entry : collector.resultList) {
            List<Integer> list = this.nameToIndexMapping.get(entry.getKey());
            if (list == null) {
                list = new ArrayList<Integer>();
                this.nameToIndexMapping.put(entry.getKey(), list);
            }
            list.add(i++);
        }
    }

    @Override
    public final BatchSingle bind(Object ... bindValues) {
        this.allBindValues.add(bindValues);
        return this;
    }

    @Override
    public final BatchSingle bind(Object[] ... bindValues) {
        for (Object[] v : bindValues) {
            this.bind(v);
        }
        return this;
    }

    @Override
    public final BatchSingle bind(Map<String, Object> namedBindValues) {
        return this.bind(new Map[]{namedBindValues});
    }

    @Override
    @SafeVarargs
    public final BatchSingle bind(Map<String, Object> ... namedBindValues) {
        List<Object> defaultValues = this.query.getBindValues();
        Object[][] bindValues = new Object[namedBindValues.length][];
        for (int row = 0; row < bindValues.length; ++row) {
            bindValues[row] = defaultValues.toArray();
            for (Map.Entry<String, Object> entry : namedBindValues[row].entrySet()) {
                List<Integer> indexes = this.nameToIndexMapping.get(entry.getKey());
                if (indexes == null) continue;
                for (int index : indexes) {
                    bindValues[row][index] = entry.getValue();
                }
            }
        }
        this.bind(bindValues);
        return this;
    }

    @Override
    public final int size() {
        return this.allBindValues.size();
    }

    @Override
    public final int[] execute() {
        if (this.allBindValues.isEmpty()) {
            log.info((Object)"Single batch", "No bind variables have been provided with a single statement batch execution. This may be due to accidental API misuse");
            return BatchMultiple.execute(this.configuration, new Query[]{this.query});
        }
        this.checkBindValues();
        if (SettingsTools.executeStaticStatements(this.configuration.settings())) {
            return this.executeStatic();
        }
        return this.executePrepared();
    }

    private final void checkBindValues() {
        for (int i = 0; i < this.allBindValues.size(); ++i) {
            if (this.allBindValues.get(i).length == this.expectedBindValues) continue;
            log.info((Object)"Bind value count", "Batch bind value set " + i + " has " + this.allBindValues.get(i).length + " values when " + this.expectedBindValues + " values were expected");
        }
    }

    private final int[] executePrepared() {
        DefaultExecuteContext ctx = new DefaultExecuteContext(this.configuration, new Query[]{this.query});
        ExecuteListeners listener = new ExecuteListeners(ctx);
        Connection connection = ctx.connection();
        ParamCollector collector = new ParamCollector(this.configuration, false);
        collector.visit(this.query);
        ArrayList params = new ArrayList();
        for (Map.Entry<String, Param<?>> entry : collector.resultList) {
            params.add(entry.getValue());
        }
        DataType<?>[] paramTypes = Utils.dataTypes(params.toArray(new Field[0]));
        try {
            listener.renderStart(ctx);
            ctx.sql(this.create.render(this.query));
            listener.renderEnd(ctx);
            listener.prepareStart(ctx);
            ctx.statement(connection.prepareStatement(ctx.sql()));
            listener.prepareEnd(ctx);
            for (Object[] bindValues : this.allBindValues) {
                listener.bindStart(ctx);
                Utils.visitAll(new DefaultBindContext(this.configuration, ctx.statement()), paramTypes.length > 0 ? Utils.fields(bindValues, paramTypes) : Utils.fields(bindValues));
                listener.bindEnd(ctx);
                ctx.statement().addBatch();
            }
            listener.executeStart(ctx);
            int[] nArray = ctx.statement().executeBatch();
            int[] batchRows = ctx.batchRows();
            for (int i = 0; i < batchRows.length && i < nArray.length; ++i) {
                batchRows[i] = nArray[i];
            }
            listener.executeEnd(ctx);
            int[] nArray2 = nArray;
            return nArray2;
        }
        catch (ControlFlowSignal controlFlowSignal) {
            throw controlFlowSignal;
        }
        catch (RuntimeException runtimeException) {
            ctx.exception(runtimeException);
            listener.exception(ctx);
            throw ctx.exception();
        }
        catch (SQLException sQLException) {
            ctx.sqlException(sQLException);
            listener.exception(ctx);
            throw ctx.exception();
        }
        finally {
            Utils.safeClose(listener, ctx);
        }
    }

    private final int[] executeStatic() {
        ArrayList<Query> queries = new ArrayList<Query>();
        for (Object[] bindValues : this.allBindValues) {
            for (int i = 0; i < bindValues.length; ++i) {
                this.query.bind(i + 1, bindValues[i]);
            }
            queries.add(this.create.query(this.query.getSQL(ParamType.INLINED)));
        }
        return this.create.batch(queries).execute();
    }
}

