/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.jooq.Binding;
import org.jooq.Clause;
import org.jooq.Context;
import org.jooq.Converter;
import org.jooq.DataType;
import org.jooq.DivideByOnStep;
import org.jooq.Field;
import org.jooq.ForeignKey;
import org.jooq.Identity;
import org.jooq.JoinType;
import org.jooq.Name;
import org.jooq.QueryPart;
import org.jooq.Record;
import org.jooq.RecordType;
import org.jooq.Row;
import org.jooq.SQL;
import org.jooq.Schema;
import org.jooq.Table;
import org.jooq.TableField;
import org.jooq.TableLike;
import org.jooq.TableOnStep;
import org.jooq.TableOptionalOnStep;
import org.jooq.TablePartitionByStep;
import org.jooq.UniqueKey;
import org.jooq.impl.AbstractQueryPart;
import org.jooq.impl.DSL;
import org.jooq.impl.DefaultBinding;
import org.jooq.impl.DefaultConfiguration;
import org.jooq.impl.DivideBy;
import org.jooq.impl.Fields;
import org.jooq.impl.HintedTable;
import org.jooq.impl.JoinTable;
import org.jooq.impl.RowImpl;
import org.jooq.impl.TableAlias;
import org.jooq.impl.TableFieldImpl;
import org.jooq.impl.TableImpl;
import org.jooq.tools.StringUtils;

abstract class AbstractTable<R extends Record>
extends AbstractQueryPart
implements Table<R> {
    private static final long serialVersionUID = 3155496238969274871L;
    private static final Clause[] CLAUSES = new Clause[]{Clause.TABLE};
    private final Schema tableschema;
    private final String tablename;
    private final String tablecomment;

    AbstractTable(String name) {
        this(name, null, null);
    }

    AbstractTable(String name, Schema schema) {
        this(name, schema, null);
    }

    AbstractTable(String name, Schema schema, String comment) {
        this.tableschema = schema;
        this.tablename = name;
        this.tablecomment = comment;
    }

    @Override
    public Clause[] clauses(Context<?> ctx) {
        return CLAUSES;
    }

    abstract Fields<R> fields0();

    @Override
    public final RecordType<R> recordType() {
        return this.fields0();
    }

    @Override
    public final R newRecord() {
        return DSL.using(new DefaultConfiguration()).newRecord(this);
    }

    @Override
    public final Row fieldsRow() {
        return new RowImpl(this.fields0());
    }

    @Override
    public final <T> Field<T> field(Field<T> field) {
        return this.fieldsRow().field(field);
    }

    @Override
    public final Field<?> field(String string) {
        return this.fieldsRow().field(string);
    }

    @Override
    public final <T> Field<T> field(String name, Class<T> type) {
        return this.fieldsRow().field(name, type);
    }

    @Override
    public final <T> Field<T> field(String name, DataType<T> dataType) {
        return this.fieldsRow().field(name, dataType);
    }

    @Override
    public final Field<?> field(Name name) {
        return this.fieldsRow().field(name);
    }

    @Override
    public final <T> Field<T> field(Name name, Class<T> type) {
        return this.fieldsRow().field(name, type);
    }

    @Override
    public final <T> Field<T> field(Name name, DataType<T> dataType) {
        return this.fieldsRow().field(name, dataType);
    }

    @Override
    public final Field<?> field(int index) {
        return this.fieldsRow().field(index);
    }

    @Override
    public final <T> Field<T> field(int index, Class<T> type) {
        return this.fieldsRow().field(index, type);
    }

    @Override
    public final <T> Field<T> field(int index, DataType<T> dataType) {
        return this.fieldsRow().field(index, dataType);
    }

    @Override
    public final Field<?>[] fields() {
        return this.fieldsRow().fields();
    }

    @Override
    public final Field<?>[] fields(Field<?> ... fields) {
        return this.fieldsRow().fields(fields);
    }

    @Override
    public final Field<?>[] fields(String ... fieldNames) {
        return this.fieldsRow().fields(fieldNames);
    }

    @Override
    public final Field<?>[] fields(Name ... fieldNames) {
        return this.fieldsRow().fields(fieldNames);
    }

    @Override
    public final Field<?>[] fields(int ... fieldIndexes) {
        return this.fieldsRow().fields(fieldIndexes);
    }

    @Override
    public final Table<R> asTable() {
        return this;
    }

    @Override
    public final Table<R> asTable(String alias) {
        return this.as(alias);
    }

    @Override
    public final Table<R> asTable(String alias, String ... fieldAliases) {
        return this.as(alias, fieldAliases);
    }

    @Override
    public final Schema getSchema() {
        return this.tableschema;
    }

    @Override
    public final String getName() {
        return this.tablename;
    }

    @Override
    public final String getComment() {
        return this.tablecomment;
    }

    @Override
    public Identity<R, ?> getIdentity() {
        return null;
    }

    @Override
    public UniqueKey<R> getPrimaryKey() {
        return null;
    }

    @Override
    public TableField<R, ? extends Number> getRecordVersion() {
        return null;
    }

    @Override
    public TableField<R, ? extends Date> getRecordTimestamp() {
        return null;
    }

    @Override
    public List<UniqueKey<R>> getKeys() {
        return Collections.emptyList();
    }

    @Override
    public final <O extends Record> List<ForeignKey<O, R>> getReferencesFrom(Table<O> other) {
        return other.getReferencesTo(this);
    }

    @Override
    public List<ForeignKey<R, ?>> getReferences() {
        return Collections.emptyList();
    }

    @Override
    public final <O extends Record> List<ForeignKey<R, O>> getReferencesTo(Table<O> other) {
        ArrayList result = new ArrayList();
        for (ForeignKey<R, ?> reference : this.getReferences()) {
            Table aliased;
            if (other.equals(reference.getKey().getTable())) {
                result.add(reference);
                continue;
            }
            if (other instanceof TableImpl) {
                aliased = ((TableImpl)other).getAliasedTable();
                if (aliased == null || !aliased.equals(reference.getKey().getTable())) continue;
                result.add(reference);
                continue;
            }
            if (!(other instanceof TableAlias) || (aliased = ((TableAlias)other).getAliasedTable()) == null || !aliased.equals(reference.getKey().getTable())) continue;
            result.add(reference);
        }
        return Collections.unmodifiableList(result);
    }

    protected static final <R extends Record, T> TableField<R, T> createField(String name, DataType<T> type, Table<R> table) {
        return AbstractTable.createField(name, type, table, null, null, null);
    }

    protected static final <R extends Record, T> TableField<R, T> createField(String name, DataType<T> type, Table<R> table, String comment) {
        return AbstractTable.createField(name, type, table, comment, null, null);
    }

    protected static final <R extends Record, T, U> TableField<R, U> createField(String name, DataType<T> type, Table<R> table, String comment, Converter<T, U> converter) {
        return AbstractTable.createField(name, type, table, comment, converter, null);
    }

    protected static final <R extends Record, T, U> TableField<R, U> createField(String name, DataType<T> type, Table<R> table, String comment, Binding<T, U> binding) {
        return AbstractTable.createField(name, type, table, comment, null, binding);
    }

    protected static final <R extends Record, T, X, U> TableField<R, U> createField(String name, DataType<T> type, Table<R> table, String comment, Converter<X, U> converter, Binding<T, X> binding) {
        Binding<T, U> actualBinding = DefaultBinding.newBinding(converter, type, binding);
        DataType<Object> actualType = converter == null && binding == null ? type : type.asConvertedDataType(actualBinding);
        TableFieldImpl<R, T> tableField = new TableFieldImpl<R, T>(name, actualType, table, comment, actualBinding);
        if (table instanceof TableImpl) {
            ((TableImpl)table).fields0().add(tableField);
        }
        return tableField;
    }

    protected final <T> TableField<R, T> createField(String name, DataType<T> type) {
        return AbstractTable.createField(name, type, this, null, null, null);
    }

    protected final <T> TableField<R, T> createField(String name, DataType<T> type, String comment) {
        return AbstractTable.createField(name, type, this, comment, null, null);
    }

    protected final <T, U> TableField<R, U> createField(String name, DataType<T> type, String comment, Converter<T, U> converter) {
        return AbstractTable.createField(name, type, this, comment, converter, null);
    }

    protected final <T, U> TableField<R, U> createField(String name, DataType<T> type, String comment, Binding<T, U> binding) {
        return AbstractTable.createField(name, type, this, comment, null, binding);
    }

    protected final <T, X, U> TableField<R, U> createField(String name, DataType<T> type, String comment, Converter<X, U> converter, Binding<T, X> binding) {
        return AbstractTable.createField(name, type, this, comment, converter, binding);
    }

    @Override
    public final Table<R> useIndex(String ... indexes) {
        return new HintedTable(this, "use index", indexes);
    }

    @Override
    public final Table<R> useIndexForJoin(String ... indexes) {
        return new HintedTable(this, "use index for join", indexes);
    }

    @Override
    public final Table<R> useIndexForOrderBy(String ... indexes) {
        return new HintedTable(this, "use index for order by", indexes);
    }

    @Override
    public final Table<R> useIndexForGroupBy(String ... indexes) {
        return new HintedTable(this, "use index for group by", indexes);
    }

    @Override
    public final Table<R> ignoreIndex(String ... indexes) {
        return new HintedTable(this, "ignore index", indexes);
    }

    @Override
    public final Table<R> ignoreIndexForJoin(String ... indexes) {
        return new HintedTable(this, "ignore index for join", indexes);
    }

    @Override
    public final Table<R> ignoreIndexForOrderBy(String ... indexes) {
        return new HintedTable(this, "ignore index for order by", indexes);
    }

    @Override
    public final Table<R> ignoreIndexForGroupBy(String ... indexes) {
        return new HintedTable(this, "ignore index for group by", indexes);
    }

    @Override
    public final Table<R> forceIndex(String ... indexes) {
        return new HintedTable(this, "force index", indexes);
    }

    @Override
    public final Table<R> forceIndexForJoin(String ... indexes) {
        return new HintedTable(this, "force index for join", indexes);
    }

    @Override
    public final Table<R> forceIndexForOrderBy(String ... indexes) {
        return new HintedTable(this, "force index for order by", indexes);
    }

    @Override
    public final Table<R> forceIndexForGroupBy(String ... indexes) {
        return new HintedTable(this, "force index for group by", indexes);
    }

    @Override
    public final DivideByOnStep divideBy(Table<?> divisor) {
        return new DivideBy(this, divisor);
    }

    @Override
    public final TableOnStep<R> leftSemiJoin(TableLike<?> table) {
        return this.join(table, JoinType.LEFT_SEMI_JOIN);
    }

    @Override
    public final TableOnStep<R> leftAntiJoin(TableLike<?> table) {
        return this.join(table, JoinType.LEFT_ANTI_JOIN);
    }

    @Override
    public final TableOptionalOnStep<Record> join(TableLike<?> table, JoinType type) {
        return new JoinTable(this, table, type);
    }

    @Override
    public final TableOnStep<Record> join(TableLike<?> table) {
        return this.innerJoin(table);
    }

    @Override
    public final TableOnStep<Record> join(SQL sql) {
        return this.innerJoin(sql);
    }

    @Override
    public final TableOnStep<Record> join(String sql) {
        return this.innerJoin(sql);
    }

    @Override
    public final TableOnStep<Record> join(String sql, Object ... bindings) {
        return this.innerJoin(sql, bindings);
    }

    @Override
    public final TableOnStep<Record> join(String sql, QueryPart ... parts) {
        return this.innerJoin(sql, parts);
    }

    @Override
    public final TableOnStep<Record> innerJoin(TableLike<?> table) {
        return this.join(table, JoinType.JOIN);
    }

    @Override
    public final TableOnStep<Record> innerJoin(SQL sql) {
        return this.innerJoin(DSL.table(sql));
    }

    @Override
    public final TableOnStep<Record> innerJoin(String sql) {
        return this.innerJoin(DSL.table(sql));
    }

    @Override
    public final TableOnStep<Record> innerJoin(String sql, Object ... bindings) {
        return this.innerJoin(DSL.table(sql, bindings));
    }

    @Override
    public final TableOnStep<Record> innerJoin(String sql, QueryPart ... parts) {
        return this.innerJoin(DSL.table(sql, parts));
    }

    @Override
    public final TablePartitionByStep<Record> leftJoin(TableLike<?> table) {
        return this.leftOuterJoin(table);
    }

    @Override
    public final TablePartitionByStep<Record> leftJoin(SQL sql) {
        return this.leftOuterJoin(sql);
    }

    @Override
    public final TablePartitionByStep<Record> leftJoin(String sql) {
        return this.leftOuterJoin(sql);
    }

    @Override
    public final TablePartitionByStep<Record> leftJoin(String sql, Object ... bindings) {
        return this.leftOuterJoin(sql, bindings);
    }

    @Override
    public final TablePartitionByStep<Record> leftJoin(String sql, QueryPart ... parts) {
        return this.leftOuterJoin(sql, parts);
    }

    @Override
    public final TablePartitionByStep<Record> leftOuterJoin(TableLike<?> table) {
        return this.join(table, JoinType.LEFT_OUTER_JOIN);
    }

    @Override
    public final TablePartitionByStep<Record> leftOuterJoin(SQL sql) {
        return this.leftOuterJoin(DSL.table(sql));
    }

    @Override
    public final TablePartitionByStep<Record> leftOuterJoin(String sql) {
        return this.leftOuterJoin(DSL.table(sql));
    }

    @Override
    public final TablePartitionByStep<Record> leftOuterJoin(String sql, Object ... bindings) {
        return this.leftOuterJoin(DSL.table(sql, bindings));
    }

    @Override
    public final TablePartitionByStep<Record> leftOuterJoin(String sql, QueryPart ... parts) {
        return this.leftOuterJoin(DSL.table(sql, parts));
    }

    @Override
    public final TablePartitionByStep<Record> rightJoin(TableLike<?> table) {
        return this.rightOuterJoin(table);
    }

    @Override
    public final TablePartitionByStep<Record> rightJoin(SQL sql) {
        return this.rightOuterJoin(sql);
    }

    @Override
    public final TablePartitionByStep<Record> rightJoin(String sql) {
        return this.rightOuterJoin(sql);
    }

    @Override
    public final TablePartitionByStep<Record> rightJoin(String sql, Object ... bindings) {
        return this.rightOuterJoin(sql, bindings);
    }

    @Override
    public final TablePartitionByStep<Record> rightJoin(String sql, QueryPart ... parts) {
        return this.rightOuterJoin(sql, parts);
    }

    @Override
    public final TablePartitionByStep<Record> rightOuterJoin(TableLike<?> table) {
        return this.join(table, JoinType.RIGHT_OUTER_JOIN);
    }

    @Override
    public final TablePartitionByStep<Record> rightOuterJoin(SQL sql) {
        return this.rightOuterJoin(DSL.table(sql));
    }

    @Override
    public final TablePartitionByStep<Record> rightOuterJoin(String sql) {
        return this.rightOuterJoin(DSL.table(sql));
    }

    @Override
    public final TablePartitionByStep<Record> rightOuterJoin(String sql, Object ... bindings) {
        return this.rightOuterJoin(DSL.table(sql, bindings));
    }

    @Override
    public final TablePartitionByStep<Record> rightOuterJoin(String sql, QueryPart ... parts) {
        return this.rightOuterJoin(DSL.table(sql, parts));
    }

    @Override
    public final TableOnStep<Record> fullOuterJoin(TableLike<?> table) {
        return this.join(table, JoinType.FULL_OUTER_JOIN);
    }

    @Override
    public final TableOnStep<Record> fullOuterJoin(SQL sql) {
        return this.fullOuterJoin(DSL.table(sql));
    }

    @Override
    public final TableOnStep<Record> fullOuterJoin(String sql) {
        return this.fullOuterJoin(DSL.table(sql));
    }

    @Override
    public final TableOnStep<Record> fullOuterJoin(String sql, Object ... bindings) {
        return this.fullOuterJoin(DSL.table(sql, bindings));
    }

    @Override
    public final TableOnStep<Record> fullOuterJoin(String sql, QueryPart ... parts) {
        return this.fullOuterJoin(DSL.table(sql, parts));
    }

    @Override
    public final Table<Record> crossJoin(TableLike<?> table) {
        return this.join(table, JoinType.CROSS_JOIN);
    }

    @Override
    public final Table<Record> crossJoin(SQL sql) {
        return this.crossJoin(DSL.table(sql));
    }

    @Override
    public final Table<Record> crossJoin(String sql) {
        return this.crossJoin(DSL.table(sql));
    }

    @Override
    public final Table<Record> crossJoin(String sql, Object ... bindings) {
        return this.crossJoin(DSL.table(sql, bindings));
    }

    @Override
    public final Table<Record> crossJoin(String sql, QueryPart ... parts) {
        return this.crossJoin(DSL.table(sql, parts));
    }

    @Override
    public final Table<Record> naturalJoin(TableLike<?> table) {
        return this.join(table, JoinType.NATURAL_JOIN);
    }

    @Override
    public final Table<Record> naturalJoin(SQL sql) {
        return this.naturalJoin(DSL.table(sql));
    }

    @Override
    public final Table<Record> naturalJoin(String sql) {
        return this.naturalJoin(DSL.table(sql));
    }

    @Override
    public final Table<Record> naturalJoin(String sql, Object ... bindings) {
        return this.naturalJoin(DSL.table(sql, bindings));
    }

    @Override
    public final Table<Record> naturalJoin(String sql, QueryPart ... parts) {
        return this.naturalJoin(DSL.table(sql, parts));
    }

    @Override
    public final Table<Record> naturalLeftOuterJoin(TableLike<?> table) {
        return this.join(table, JoinType.NATURAL_LEFT_OUTER_JOIN);
    }

    @Override
    public final Table<Record> naturalLeftOuterJoin(SQL sql) {
        return this.naturalLeftOuterJoin(DSL.table(sql));
    }

    @Override
    public final Table<Record> naturalLeftOuterJoin(String sql) {
        return this.naturalLeftOuterJoin(DSL.table(sql));
    }

    @Override
    public final Table<Record> naturalLeftOuterJoin(String sql, Object ... bindings) {
        return this.naturalLeftOuterJoin(DSL.table(sql, bindings));
    }

    @Override
    public final Table<Record> naturalLeftOuterJoin(String sql, QueryPart ... parts) {
        return this.naturalLeftOuterJoin(DSL.table(sql, parts));
    }

    @Override
    public final Table<Record> naturalRightOuterJoin(TableLike<?> table) {
        return this.join(table, JoinType.NATURAL_RIGHT_OUTER_JOIN);
    }

    @Override
    public final Table<Record> naturalRightOuterJoin(SQL sql) {
        return this.naturalRightOuterJoin(DSL.table(sql));
    }

    @Override
    public final Table<Record> naturalRightOuterJoin(String sql) {
        return this.naturalRightOuterJoin(DSL.table(sql));
    }

    @Override
    public final Table<Record> naturalRightOuterJoin(String sql, Object ... bindings) {
        return this.naturalRightOuterJoin(DSL.table(sql, bindings));
    }

    @Override
    public final Table<Record> naturalRightOuterJoin(String sql, QueryPart ... parts) {
        return this.naturalRightOuterJoin(DSL.table(sql, parts));
    }

    @Override
    public final Table<Record> crossApply(TableLike<?> table) {
        return this.join(table, JoinType.CROSS_APPLY);
    }

    @Override
    public final Table<Record> crossApply(SQL sql) {
        return this.crossApply(DSL.table(sql));
    }

    @Override
    public final Table<Record> crossApply(String sql) {
        return this.crossApply(DSL.table(sql));
    }

    @Override
    public final Table<Record> crossApply(String sql, Object ... bindings) {
        return this.crossApply(DSL.table(sql, bindings));
    }

    @Override
    public final Table<Record> crossApply(String sql, QueryPart ... parts) {
        return this.crossApply(DSL.table(sql, parts));
    }

    @Override
    public final Table<Record> outerApply(TableLike<?> table) {
        return this.join(table, JoinType.OUTER_APPLY);
    }

    @Override
    public final Table<Record> outerApply(SQL sql) {
        return this.outerApply(DSL.table(sql));
    }

    @Override
    public final Table<Record> outerApply(String sql) {
        return this.outerApply(DSL.table(sql));
    }

    @Override
    public final Table<Record> outerApply(String sql, Object ... bindings) {
        return this.outerApply(DSL.table(sql, bindings));
    }

    @Override
    public final Table<Record> outerApply(String sql, QueryPart ... parts) {
        return this.outerApply(DSL.table(sql, parts));
    }

    public final TableOptionalOnStep<Record> straightJoin(TableLike<?> table) {
        return this.join(table, JoinType.STRAIGHT_JOIN);
    }

    public final TableOptionalOnStep<Record> straightJoin(SQL sql) {
        return this.straightJoin(DSL.table(sql));
    }

    public final TableOptionalOnStep<Record> straightJoin(String sql) {
        return this.straightJoin(DSL.table(sql));
    }

    public final TableOptionalOnStep<Record> straightJoin(String sql, Object ... bindings) {
        return this.straightJoin(DSL.table(sql, bindings));
    }

    public final TableOptionalOnStep<Record> straightJoin(String sql, QueryPart ... parts) {
        return this.straightJoin(DSL.table(sql, parts));
    }

    @Override
    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that instanceof AbstractTable) {
            if (StringUtils.equals(this.tablename, ((AbstractTable)that).tablename)) {
                return super.equals(that);
            }
            return false;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.tablename.hashCode();
    }
}

