/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.lang.reflect.Array;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.stream.Stream;
import org.jooq.Configuration;
import org.jooq.Converter;
import org.jooq.Cursor;
import org.jooq.ExecuteContext;
import org.jooq.ExecuteListener;
import org.jooq.Field;
import org.jooq.FutureResult;
import org.jooq.Name;
import org.jooq.Record;
import org.jooq.RecordHandler;
import org.jooq.RecordMapper;
import org.jooq.Result;
import org.jooq.ResultQuery;
import org.jooq.Results;
import org.jooq.SQLDialect;
import org.jooq.Table;
import org.jooq.exception.DataAccessException;
import org.jooq.impl.AbstractQuery;
import org.jooq.impl.CursorImpl;
import org.jooq.impl.FutureResultImpl;
import org.jooq.impl.Intern;
import org.jooq.impl.ResultImpl;
import org.jooq.impl.ResultsImpl;
import org.jooq.impl.Utils;
import org.jooq.tools.Convert;
import org.jooq.tools.JooqLogger;

abstract class AbstractResultQuery<R extends Record>
extends AbstractQuery
implements ResultQuery<R> {
    private static final long serialVersionUID = -5588344253566055707L;
    private static final JooqLogger log = JooqLogger.getLogger(AbstractResultQuery.class);
    private int maxRows;
    private int fetchSize;
    private int resultSetConcurrency;
    private int resultSetType;
    private int resultSetHoldability;
    private transient boolean lazy;
    private transient boolean many;
    private transient Cursor<R> cursor;
    private Result<R> result;
    private ResultsImpl results;
    private final Intern intern = new Intern();

    AbstractResultQuery(Configuration configuration) {
        super(configuration);
    }

    protected abstract Field<?>[] getFields(ResultSetMetaData var1) throws SQLException;

    @Override
    public final ResultQuery<R> bind(String param, Object value) {
        return (ResultQuery)super.bind(param, value);
    }

    @Override
    public final ResultQuery<R> bind(int index, Object value) {
        return (ResultQuery)super.bind(index, value);
    }

    @Override
    public final ResultQuery<R> queryTimeout(int timeout) {
        return (ResultQuery)super.queryTimeout(timeout);
    }

    @Override
    public final ResultQuery<R> keepStatement(boolean k) {
        return (ResultQuery)super.keepStatement(k);
    }

    @Override
    public final ResultQuery<R> maxRows(int rows) {
        this.maxRows = rows;
        return this;
    }

    @Override
    public final ResultQuery<R> fetchSize(int rows) {
        this.fetchSize = rows;
        return this;
    }

    @Override
    public final ResultQuery<R> resultSetConcurrency(int concurrency) {
        this.resultSetConcurrency = concurrency;
        return this;
    }

    @Override
    public final ResultQuery<R> resultSetType(int type) {
        this.resultSetType = type;
        return this;
    }

    @Override
    public final ResultQuery<R> resultSetHoldability(int holdability) {
        this.resultSetHoldability = holdability;
        return this;
    }

    @Override
    public final ResultQuery<R> intern(Field<?> ... fields) {
        this.intern.internFields = fields;
        return this;
    }

    @Override
    public final ResultQuery<R> intern(int ... fieldIndexes) {
        this.intern.internIndexes = fieldIndexes;
        return this;
    }

    @Override
    public final ResultQuery<R> intern(String ... fieldNameStrings) {
        this.intern.internNameStrings = fieldNameStrings;
        return this;
    }

    @Override
    public final ResultQuery<R> intern(Name ... fieldNames) {
        this.intern.internNames = fieldNames;
        return this;
    }

    @Override
    protected final void prepare(ExecuteContext ctx) throws SQLException {
        if (this.resultSetConcurrency != 0 || this.resultSetType != 0 || this.resultSetHoldability != 0) {
            int concurrency;
            int type = this.resultSetType != 0 ? this.resultSetType : 1003;
            int n = concurrency = this.resultSetConcurrency != 0 ? this.resultSetConcurrency : 1007;
            if (this.resultSetHoldability == 0) {
                ctx.statement(ctx.connection().prepareStatement(ctx.sql(), type, concurrency));
            } else {
                ctx.statement(ctx.connection().prepareStatement(ctx.sql(), type, concurrency, this.resultSetHoldability));
            }
        } else if (this.isForUpdate() && Arrays.asList(SQLDialect.CUBRID).contains((Object)ctx.configuration().dialect().family())) {
            ctx.data((Object)Utils.DataKey.DATA_LOCK_ROWS_FOR_UPDATE, true);
            ctx.statement(ctx.connection().prepareStatement(ctx.sql(), 1005, 1008));
        } else {
            ctx.statement(ctx.connection().prepareStatement(ctx.sql()));
        }
        if (this.fetchSize != 0) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Setting fetch size", this.fetchSize);
            }
            ctx.statement().setFetchSize(this.fetchSize);
        }
        if (this.maxRows != 0) {
            ctx.statement().setMaxRows(this.maxRows);
        }
    }

    @Override
    protected final int execute(ExecuteContext ctx, ExecuteListener listener) throws SQLException {
        listener.executeStart(ctx);
        if (ctx.family() == SQLDialect.POSTGRES && this.fetchSize != 0 && ctx.connection().getAutoCommit()) {
            log.info((Object)"Fetch Size", "A fetch size of " + this.fetchSize + " was set on a auto-commit PostgreSQL connection, which is not recommended. See http://jdbc.postgresql.org/documentation/head/query.html#query-with-cursor");
        }
        if (ctx.statement().execute()) {
            ctx.resultSet(ctx.statement().getResultSet());
        }
        listener.executeEnd(ctx);
        if (!this.many) {
            if (ctx.resultSet() != null) {
                Field<?>[] fields = this.getFields(ctx.resultSet().getMetaData());
                this.cursor = new CursorImpl<R>(ctx, listener, fields, this.intern.internIndexes(fields), this.keepStatement(), this.keepResultSet(), this.getRecordType(), this.maxRows);
                if (!this.lazy) {
                    this.result = this.cursor.fetch();
                    this.cursor = null;
                }
            } else {
                this.result = new ResultImpl(ctx.configuration(), new Field[0]);
            }
        } else {
            this.results = new ResultsImpl(ctx.configuration());
            Utils.consumeResultSets(ctx, listener, this.results, this.intern);
        }
        return this.result != null ? this.result.size() : 0;
    }

    @Override
    protected final boolean keepResultSet() {
        return this.lazy;
    }

    abstract boolean isForUpdate();

    @Override
    public final Result<R> fetch() {
        this.execute();
        return this.result;
    }

    @Override
    public final ResultSet fetchResultSet() {
        return this.fetchLazy().resultSet();
    }

    @Override
    public final Iterator<R> iterator() {
        return this.fetch().iterator();
    }

    @Override
    public final Stream<R> stream() throws DataAccessException {
        return this.fetchLazy().stream();
    }

    @Override
    public final Cursor<R> fetchLazy() {
        return this.fetchLazy(this.fetchSize);
    }

    @Override
    @Deprecated
    public final Cursor<R> fetchLazy(int size) {
        int previousFetchSize = this.fetchSize;
        this.lazy = true;
        this.fetchSize = size;
        try {
            this.execute();
        }
        finally {
            this.lazy = false;
            this.fetchSize = previousFetchSize;
        }
        return this.cursor;
    }

    @Override
    public final Results fetchMany() {
        this.many = true;
        try {
            this.execute();
        }
        finally {
            this.many = false;
        }
        return this.results;
    }

    @Override
    public final <T> List<T> fetch(Field<T> field) {
        return this.fetch().getValues(field);
    }

    @Override
    public final <T> List<T> fetch(Field<?> field, Class<? extends T> type) {
        return this.fetch().getValues(field, type);
    }

    @Override
    public final <T, U> List<U> fetch(Field<T> field, Converter<? super T, U> converter) {
        return this.fetch().getValues(field, converter);
    }

    @Override
    public final List<?> fetch(int fieldIndex) {
        return this.fetch().getValues(fieldIndex);
    }

    @Override
    public final <T> List<T> fetch(int fieldIndex, Class<? extends T> type) {
        return this.fetch().getValues(fieldIndex, type);
    }

    @Override
    public final <U> List<U> fetch(int fieldIndex, Converter<?, U> converter) {
        return this.fetch().getValues(fieldIndex, converter);
    }

    @Override
    public final List<?> fetch(String fieldName) {
        return this.fetch().getValues(fieldName);
    }

    @Override
    public final <T> List<T> fetch(String fieldName, Class<? extends T> type) {
        return this.fetch().getValues(fieldName, type);
    }

    @Override
    public final <U> List<U> fetch(String fieldName, Converter<?, U> converter) {
        return this.fetch().getValues(fieldName, converter);
    }

    @Override
    public final List<?> fetch(Name fieldName) {
        return this.fetch().getValues(fieldName);
    }

    @Override
    public final <T> List<T> fetch(Name fieldName, Class<? extends T> type) {
        return this.fetch().getValues(fieldName, type);
    }

    @Override
    public final <U> List<U> fetch(Name fieldName, Converter<?, U> converter) {
        return this.fetch().getValues(fieldName, converter);
    }

    @Override
    public final <T> T fetchOne(Field<T> field) {
        R record = this.fetchOne();
        return record == null ? null : (T)record.getValue(field);
    }

    @Override
    public final <T> T fetchOne(Field<?> field, Class<? extends T> type) {
        return Convert.convert(this.fetchOne(field), type);
    }

    @Override
    public final <T, U> U fetchOne(Field<T> field, Converter<? super T, U> converter) {
        return Convert.convert(this.fetchOne(field), converter);
    }

    @Override
    public final Object fetchOne(int fieldIndex) {
        R record = this.fetchOne();
        return record == null ? null : record.getValue(fieldIndex);
    }

    @Override
    public final <T> T fetchOne(int fieldIndex, Class<? extends T> type) {
        return Convert.convert(this.fetchOne(fieldIndex), type);
    }

    @Override
    public final <U> U fetchOne(int fieldIndex, Converter<?, U> converter) {
        return Convert.convert(this.fetchOne(fieldIndex), converter);
    }

    @Override
    public final Object fetchOne(String fieldName) {
        R record = this.fetchOne();
        return record == null ? null : record.getValue(fieldName);
    }

    @Override
    public final <T> T fetchOne(String fieldName, Class<? extends T> type) {
        return Convert.convert(this.fetchOne(fieldName), type);
    }

    @Override
    public final <U> U fetchOne(String fieldName, Converter<?, U> converter) {
        return Convert.convert(this.fetchOne(fieldName), converter);
    }

    @Override
    public final Object fetchOne(Name fieldName) {
        R record = this.fetchOne();
        return record == null ? null : record.getValue(fieldName);
    }

    @Override
    public final <T> T fetchOne(Name fieldName, Class<? extends T> type) {
        return Convert.convert(this.fetchOne(fieldName), type);
    }

    @Override
    public final <U> U fetchOne(Name fieldName, Converter<?, U> converter) {
        return Convert.convert(this.fetchOne(fieldName), converter);
    }

    @Override
    public final R fetchOne() {
        return Utils.fetchOne(this.fetchLazy());
    }

    @Override
    public final <E> E fetchOne(RecordMapper<? super R, E> mapper) {
        R record = this.fetchOne();
        return record == null ? null : (E)mapper.map((R)record);
    }

    @Override
    public final Map<String, Object> fetchOneMap() {
        R record = this.fetchOne();
        return record == null ? null : record.intoMap();
    }

    @Override
    public final Object[] fetchOneArray() {
        R record = this.fetchOne();
        return record == null ? null : record.intoArray();
    }

    @Override
    public final <E> E fetchOneInto(Class<? extends E> type) {
        R record = this.fetchOne();
        return (E)(record == null ? null : record.into(type));
    }

    @Override
    public final <Z extends Record> Z fetchOneInto(Table<Z> table) {
        R record = this.fetchOne();
        return record == null ? null : (Z)record.into(table);
    }

    @Override
    public final <T> Optional<T> fetchOptional(Field<T> field) {
        return Optional.ofNullable(this.fetchOne(field));
    }

    @Override
    public final <T> Optional<T> fetchOptional(Field<?> field, Class<? extends T> type) {
        return Optional.ofNullable(this.fetchOne(field, type));
    }

    @Override
    public final <T, U> Optional<U> fetchOptional(Field<T> field, Converter<? super T, U> converter) {
        return Optional.ofNullable(this.fetchOne(field, converter));
    }

    @Override
    public final Optional<?> fetchOptional(int fieldIndex) {
        return Optional.ofNullable(this.fetchOne(fieldIndex));
    }

    @Override
    public final <T> Optional<T> fetchOptional(int fieldIndex, Class<? extends T> type) {
        return Optional.ofNullable(this.fetchOne(fieldIndex, type));
    }

    @Override
    public final <U> Optional<U> fetchOptional(int fieldIndex, Converter<?, U> converter) {
        return Optional.ofNullable(this.fetchOne(fieldIndex, converter));
    }

    @Override
    public final Optional<?> fetchOptional(String fieldName) {
        return Optional.ofNullable(this.fetchOne(fieldName));
    }

    @Override
    public final <T> Optional<T> fetchOptional(String fieldName, Class<? extends T> type) {
        return Optional.ofNullable(this.fetchOne(fieldName, type));
    }

    @Override
    public final <U> Optional<U> fetchOptional(String fieldName, Converter<?, U> converter) {
        return Optional.ofNullable(this.fetchOne(fieldName, converter));
    }

    @Override
    public final Optional<?> fetchOptional(Name fieldName) {
        return Optional.ofNullable(this.fetchOne(fieldName));
    }

    @Override
    public final <T> Optional<T> fetchOptional(Name fieldName, Class<? extends T> type) {
        return Optional.ofNullable(this.fetchOne(fieldName, type));
    }

    @Override
    public final <U> Optional<U> fetchOptional(Name fieldName, Converter<?, U> converter) {
        return Optional.ofNullable(this.fetchOne(fieldName, converter));
    }

    @Override
    public final Optional<R> fetchOptional() {
        return Optional.ofNullable(this.fetchOne());
    }

    @Override
    public final <E> Optional<E> fetchOptional(RecordMapper<? super R, E> mapper) {
        return Optional.ofNullable(this.fetchOne(mapper));
    }

    @Override
    public final Optional<Map<String, Object>> fetchOptionalMap() {
        return Optional.ofNullable(this.fetchOneMap());
    }

    @Override
    public final Optional<Object[]> fetchOptionalArray() {
        return Optional.ofNullable(this.fetchOneArray());
    }

    @Override
    public final <E> Optional<E> fetchOptionalInto(Class<? extends E> type) {
        return Optional.ofNullable(this.fetchOneInto(type));
    }

    @Override
    public final <Z extends Record> Optional<Z> fetchOptionalInto(Table<Z> table) {
        return Optional.ofNullable(this.fetchOneInto(table));
    }

    @Override
    public final <T> T fetchAny(Field<T> field) {
        R record = this.fetchAny();
        return record == null ? null : (T)record.getValue(field);
    }

    @Override
    public final <T> T fetchAny(Field<?> field, Class<? extends T> type) {
        return Convert.convert(this.fetchAny(field), type);
    }

    @Override
    public final <T, U> U fetchAny(Field<T> field, Converter<? super T, U> converter) {
        return Convert.convert(this.fetchAny(field), converter);
    }

    @Override
    public final Object fetchAny(int fieldIndex) {
        R record = this.fetchAny();
        return record == null ? null : record.getValue(fieldIndex);
    }

    @Override
    public final <T> T fetchAny(int fieldIndex, Class<? extends T> type) {
        return Convert.convert(this.fetchAny(fieldIndex), type);
    }

    @Override
    public final <U> U fetchAny(int fieldIndex, Converter<?, U> converter) {
        return Convert.convert(this.fetchAny(fieldIndex), converter);
    }

    @Override
    public final Object fetchAny(String fieldName) {
        R record = this.fetchAny();
        return record == null ? null : record.getValue(fieldName);
    }

    @Override
    public final <T> T fetchAny(String fieldName, Class<? extends T> type) {
        return Convert.convert(this.fetchAny(fieldName), type);
    }

    @Override
    public final <U> U fetchAny(String fieldName, Converter<?, U> converter) {
        return Convert.convert(this.fetchAny(fieldName), converter);
    }

    @Override
    public final Object fetchAny(Name fieldName) {
        R record = this.fetchAny();
        return record == null ? null : record.getValue(fieldName);
    }

    @Override
    public final <T> T fetchAny(Name fieldName, Class<? extends T> type) {
        return Convert.convert(this.fetchAny(fieldName), type);
    }

    @Override
    public final <U> U fetchAny(Name fieldName, Converter<?, U> converter) {
        return Convert.convert(this.fetchAny(fieldName), converter);
    }

    @Override
    public final R fetchAny() {
        try (Cursor<R> c = this.fetchLazy();){
            R r = c.fetchOne();
            return r;
        }
    }

    @Override
    public final <E> E fetchAny(RecordMapper<? super R, E> mapper) {
        R record = this.fetchAny();
        return record == null ? null : (E)mapper.map((R)record);
    }

    @Override
    public final Map<String, Object> fetchAnyMap() {
        R record = this.fetchAny();
        return record == null ? null : record.intoMap();
    }

    @Override
    public final Object[] fetchAnyArray() {
        R record = this.fetchAny();
        return record == null ? null : record.intoArray();
    }

    @Override
    public final <E> E fetchAnyInto(Class<? extends E> type) {
        R record = this.fetchAny();
        return (E)(record == null ? null : record.into(type));
    }

    @Override
    public final <Z extends Record> Z fetchAnyInto(Table<Z> table) {
        R record = this.fetchAny();
        return record == null ? null : (Z)record.into(table);
    }

    @Override
    public final <K> Map<K, R> fetchMap(Field<K> key) {
        return this.fetch().intoMap(key);
    }

    @Override
    public final Map<?, R> fetchMap(int keyFieldIndex) {
        return this.fetch().intoMap(keyFieldIndex);
    }

    @Override
    public final Map<?, R> fetchMap(String keyFieldName) {
        return this.fetch().intoMap(keyFieldName);
    }

    @Override
    public final Map<?, R> fetchMap(Name keyFieldName) {
        return this.fetch().intoMap(keyFieldName);
    }

    @Override
    public final <K, V> Map<K, V> fetchMap(Field<K> key, Field<V> value) {
        return this.fetch().intoMap(key, value);
    }

    @Override
    public final Map<?, ?> fetchMap(int keyFieldIndex, int valueFieldIndex) {
        return this.fetch().intoMap(keyFieldIndex, valueFieldIndex);
    }

    @Override
    public final Map<?, ?> fetchMap(String keyFieldName, String valueFieldName) {
        return this.fetch().intoMap(keyFieldName, valueFieldName);
    }

    @Override
    public final Map<?, ?> fetchMap(Name keyFieldName, Name valueFieldName) {
        return this.fetch().intoMap(keyFieldName, valueFieldName);
    }

    @Override
    public final <K, E> Map<K, E> fetchMap(Field<K> key, Class<? extends E> type) {
        return this.fetch().intoMap(key, type);
    }

    @Override
    public final <E> Map<?, E> fetchMap(int keyFieldIndex, Class<? extends E> type) {
        return this.fetch().intoMap(keyFieldIndex, type);
    }

    @Override
    public final <E> Map<?, E> fetchMap(String keyFieldName, Class<? extends E> type) {
        return this.fetch().intoMap(keyFieldName, type);
    }

    @Override
    public final <E> Map<?, E> fetchMap(Name keyFieldName, Class<? extends E> type) {
        return this.fetch().intoMap(keyFieldName, type);
    }

    @Override
    public final <K, E> Map<K, E> fetchMap(Field<K> key, RecordMapper<? super R, E> mapper) {
        return this.fetch().intoMap(key, mapper);
    }

    @Override
    public final <E> Map<?, E> fetchMap(int keyFieldIndex, RecordMapper<? super R, E> mapper) {
        return this.fetch().intoMap(keyFieldIndex, mapper);
    }

    @Override
    public final <E> Map<?, E> fetchMap(String keyFieldName, RecordMapper<? super R, E> mapper) {
        return this.fetch().intoMap(keyFieldName, mapper);
    }

    @Override
    public final <E> Map<?, E> fetchMap(Name keyFieldName, RecordMapper<? super R, E> mapper) {
        return this.fetch().intoMap(keyFieldName, mapper);
    }

    @Override
    public final Map<Record, R> fetchMap(Field<?>[] keys) {
        return this.fetch().intoMap(keys);
    }

    @Override
    public final Map<Record, R> fetchMap(int[] keyFieldIndexes) {
        return this.fetch().intoMap(keyFieldIndexes);
    }

    @Override
    public final Map<Record, R> fetchMap(String[] keyFieldNames) {
        return this.fetch().intoMap(keyFieldNames);
    }

    @Override
    public final Map<Record, R> fetchMap(Name[] keyFieldNames) {
        return this.fetch().intoMap(keyFieldNames);
    }

    @Override
    public final <E> Map<List<?>, E> fetchMap(Field<?>[] keys, Class<? extends E> type) {
        return this.fetch().intoMap(keys, type);
    }

    @Override
    public final <E> Map<List<?>, E> fetchMap(int[] keyFieldIndexes, Class<? extends E> type) {
        return this.fetch().intoMap(keyFieldIndexes, type);
    }

    @Override
    public final <E> Map<List<?>, E> fetchMap(String[] keyFieldNames, Class<? extends E> type) {
        return this.fetch().intoMap(keyFieldNames, type);
    }

    @Override
    public final <E> Map<List<?>, E> fetchMap(Name[] keyFieldNames, Class<? extends E> type) {
        return this.fetch().intoMap(keyFieldNames, type);
    }

    @Override
    public final <E> Map<List<?>, E> fetchMap(Field<?>[] keys, RecordMapper<? super R, E> mapper) {
        return this.fetch().intoMap(keys, mapper);
    }

    @Override
    public final <E> Map<List<?>, E> fetchMap(int[] keyFieldIndexes, RecordMapper<? super R, E> mapper) {
        return this.fetch().intoMap(keyFieldIndexes, mapper);
    }

    @Override
    public final <E> Map<List<?>, E> fetchMap(String[] keyFieldNames, RecordMapper<? super R, E> mapper) {
        return this.fetch().intoMap(keyFieldNames, mapper);
    }

    @Override
    public final <E> Map<List<?>, E> fetchMap(Name[] keyFieldNames, RecordMapper<? super R, E> mapper) {
        return this.fetch().intoMap(keyFieldNames, mapper);
    }

    @Override
    public final <K> Map<K, R> fetchMap(Class<? extends K> keyType) {
        return this.fetch().intoMap(keyType);
    }

    @Override
    public final <K, V> Map<K, V> fetchMap(Class<? extends K> keyType, Class<? extends V> valueType) {
        return this.fetch().intoMap(keyType, valueType);
    }

    @Override
    public final <K, V> Map<K, V> fetchMap(Class<? extends K> keyType, RecordMapper<? super R, V> valueMapper) {
        return this.fetch().intoMap(keyType, valueMapper);
    }

    @Override
    public final <K> Map<K, R> fetchMap(RecordMapper<? super R, K> keyMapper) {
        return this.fetch().intoMap(keyMapper);
    }

    @Override
    public final <K, V> Map<K, V> fetchMap(RecordMapper<? super R, K> keyMapper, Class<V> valueType) {
        return this.fetch().intoMap(keyMapper, valueType);
    }

    @Override
    public final <K, V> Map<K, V> fetchMap(RecordMapper<? super R, K> keyMapper, RecordMapper<? super R, V> valueMapper) {
        return this.fetch().intoMap(keyMapper, valueMapper);
    }

    @Override
    public final <S extends Record> Map<S, R> fetchMap(Table<S> table) {
        return this.fetch().intoMap(table);
    }

    @Override
    public final <E, S extends Record> Map<S, E> fetchMap(Table<S> table, Class<? extends E> type) {
        return this.fetch().intoMap(table, type);
    }

    @Override
    public final <E, S extends Record> Map<S, E> fetchMap(Table<S> table, RecordMapper<? super R, E> mapper) {
        return this.fetch().intoMap(table, mapper);
    }

    @Override
    public final List<Map<String, Object>> fetchMaps() {
        return this.fetch().intoMaps();
    }

    @Override
    public final <K> Map<K, Result<R>> fetchGroups(Field<K> key) {
        return this.fetch().intoGroups(key);
    }

    @Override
    public final Map<?, Result<R>> fetchGroups(int keyFieldIndex) {
        return this.fetch().intoGroups(keyFieldIndex);
    }

    @Override
    public final Map<?, Result<R>> fetchGroups(String keyFieldName) {
        return this.fetch().intoGroups(keyFieldName);
    }

    @Override
    public final Map<?, Result<R>> fetchGroups(Name keyFieldName) {
        return this.fetch().intoGroups(keyFieldName);
    }

    @Override
    public final <K, V> Map<K, List<V>> fetchGroups(Field<K> key, Field<V> value) {
        return this.fetch().intoGroups(key, value);
    }

    @Override
    public final Map<?, List<?>> fetchGroups(int keyFieldIndex, int valueFieldIndex) {
        return this.fetch().intoGroups(keyFieldIndex, valueFieldIndex);
    }

    @Override
    public final Map<?, List<?>> fetchGroups(String keyFieldName, String valueFieldName) {
        return this.fetch().intoGroups(keyFieldName, valueFieldName);
    }

    @Override
    public final Map<?, List<?>> fetchGroups(Name keyFieldName, Name valueFieldName) {
        return this.fetch().intoGroups(keyFieldName, valueFieldName);
    }

    @Override
    public final <K, E> Map<K, List<E>> fetchGroups(Field<K> key, Class<? extends E> type) {
        return this.fetch().intoGroups(key, type);
    }

    @Override
    public final <E> Map<?, List<E>> fetchGroups(int keyFieldIndex, Class<? extends E> type) {
        return this.fetch().intoGroups(keyFieldIndex, type);
    }

    @Override
    public final <E> Map<?, List<E>> fetchGroups(String keyFieldName, Class<? extends E> type) {
        return this.fetch().intoGroups(keyFieldName, type);
    }

    @Override
    public final <E> Map<?, List<E>> fetchGroups(Name keyFieldName, Class<? extends E> type) {
        return this.fetch().intoGroups(keyFieldName, type);
    }

    @Override
    public final <K, E> Map<K, List<E>> fetchGroups(Field<K> key, RecordMapper<? super R, E> mapper) {
        return this.fetch().intoGroups(key, mapper);
    }

    @Override
    public final <E> Map<?, List<E>> fetchGroups(int keyFieldIndex, RecordMapper<? super R, E> mapper) {
        return this.fetch().intoGroups(keyFieldIndex, mapper);
    }

    @Override
    public final <E> Map<?, List<E>> fetchGroups(String keyFieldName, RecordMapper<? super R, E> mapper) {
        return this.fetch().intoGroups(keyFieldName, mapper);
    }

    @Override
    public final <E> Map<?, List<E>> fetchGroups(Name keyFieldName, RecordMapper<? super R, E> mapper) {
        return this.fetch().intoGroups(keyFieldName, mapper);
    }

    @Override
    public final Map<Record, Result<R>> fetchGroups(Field<?>[] keys) {
        return this.fetch().intoGroups(keys);
    }

    @Override
    public final Map<Record, Result<R>> fetchGroups(int[] keyFieldIndexes) {
        return this.fetch().intoGroups(keyFieldIndexes);
    }

    @Override
    public final Map<Record, Result<R>> fetchGroups(String[] keyFieldNames) {
        return this.fetch().intoGroups(keyFieldNames);
    }

    @Override
    public final Map<Record, Result<R>> fetchGroups(Name[] keyFieldNames) {
        return this.fetch().intoGroups(keyFieldNames);
    }

    @Override
    public final <E> Map<Record, List<E>> fetchGroups(Field<?>[] keys, Class<? extends E> type) {
        return this.fetch().intoGroups(keys, type);
    }

    @Override
    public final <E> Map<Record, List<E>> fetchGroups(int[] keyFieldIndexes, Class<? extends E> type) {
        return this.fetch().intoGroups(keyFieldIndexes, type);
    }

    @Override
    public final <E> Map<Record, List<E>> fetchGroups(String[] keyFieldNames, Class<? extends E> type) {
        return this.fetch().intoGroups(keyFieldNames, type);
    }

    @Override
    public final <E> Map<Record, List<E>> fetchGroups(Name[] keyFieldNames, Class<? extends E> type) {
        return this.fetch().intoGroups(keyFieldNames, type);
    }

    @Override
    public final <E> Map<Record, List<E>> fetchGroups(int[] keyFieldIndexes, RecordMapper<? super R, E> mapper) {
        return this.fetch().intoGroups(keyFieldIndexes, mapper);
    }

    @Override
    public final <E> Map<Record, List<E>> fetchGroups(String[] keyFieldNames, RecordMapper<? super R, E> mapper) {
        return this.fetch().intoGroups(keyFieldNames, mapper);
    }

    @Override
    public final <E> Map<Record, List<E>> fetchGroups(Name[] keyFieldNames, RecordMapper<? super R, E> mapper) {
        return this.fetch().intoGroups(keyFieldNames, mapper);
    }

    @Override
    public final <E> Map<Record, List<E>> fetchGroups(Field<?>[] keys, RecordMapper<? super R, E> mapper) {
        return this.fetch().intoGroups(keys, mapper);
    }

    @Override
    public final <K> Map<K, Result<R>> fetchGroups(Class<? extends K> keyType) {
        return this.fetch().intoGroups(keyType);
    }

    @Override
    public final <K, V> Map<K, List<V>> fetchGroups(Class<? extends K> keyType, Class<? extends V> valueType) {
        return this.fetch().intoGroups(keyType, valueType);
    }

    @Override
    public final <K, V> Map<K, List<V>> fetchGroups(Class<? extends K> keyType, RecordMapper<? super R, V> valueMapper) {
        return this.fetch().intoGroups(keyType, valueMapper);
    }

    @Override
    public final <K> Map<K, Result<R>> fetchGroups(RecordMapper<? super R, K> keyMapper) {
        return this.fetch().intoGroups(keyMapper);
    }

    @Override
    public final <K, V> Map<K, List<V>> fetchGroups(RecordMapper<? super R, K> keyMapper, Class<V> valueType) {
        return this.fetch().intoGroups(keyMapper, valueType);
    }

    @Override
    public final <K, V> Map<K, List<V>> fetchGroups(RecordMapper<? super R, K> keyMapper, RecordMapper<? super R, V> valueMapper) {
        return this.fetch().intoGroups(keyMapper, valueMapper);
    }

    @Override
    public final <S extends Record> Map<S, Result<R>> fetchGroups(Table<S> table) {
        return this.fetch().intoGroups(table);
    }

    @Override
    public final <E, S extends Record> Map<S, List<E>> fetchGroups(Table<S> table, Class<? extends E> type) {
        return this.fetch().intoGroups(table, type);
    }

    @Override
    public final <E, S extends Record> Map<S, List<E>> fetchGroups(Table<S> table, RecordMapper<? super R, E> mapper) {
        return this.fetch().intoGroups(table, mapper);
    }

    @Override
    public final Object[][] fetchArrays() {
        return this.fetch().intoArrays();
    }

    @Override
    public final R[] fetchArray() {
        Result<R> r = this.fetch();
        return r.toArray((Record[])Array.newInstance(this.getRecordType(), r.size()));
    }

    @Override
    public final Object[] fetchArray(int fieldIndex) {
        return this.fetch().intoArray(fieldIndex);
    }

    @Override
    public final <T> T[] fetchArray(int fieldIndex, Class<? extends T> type) {
        return this.fetch().intoArray(fieldIndex, type);
    }

    @Override
    public final <U> U[] fetchArray(int fieldIndex, Converter<?, U> converter) {
        return this.fetch().intoArray(fieldIndex, converter);
    }

    @Override
    public final Object[] fetchArray(String fieldName) {
        return this.fetch().intoArray(fieldName);
    }

    @Override
    public final <T> T[] fetchArray(String fieldName, Class<? extends T> type) {
        return this.fetch().intoArray(fieldName, type);
    }

    @Override
    public final <U> U[] fetchArray(String fieldName, Converter<?, U> converter) {
        return this.fetch().intoArray(fieldName, converter);
    }

    @Override
    public final Object[] fetchArray(Name fieldName) {
        return this.fetch().intoArray(fieldName);
    }

    @Override
    public final <T> T[] fetchArray(Name fieldName, Class<? extends T> type) {
        return this.fetch().intoArray(fieldName, type);
    }

    @Override
    public final <U> U[] fetchArray(Name fieldName, Converter<?, U> converter) {
        return this.fetch().intoArray(fieldName, converter);
    }

    @Override
    public final <T> T[] fetchArray(Field<T> field) {
        return this.fetch().intoArray(field);
    }

    @Override
    public final <T> T[] fetchArray(Field<?> field, Class<? extends T> type) {
        return this.fetch().intoArray(field, type);
    }

    @Override
    public final <T, U> U[] fetchArray(Field<T> field, Converter<? super T, U> converter) {
        return this.fetch().intoArray(field, converter);
    }

    @Override
    public final Set<?> fetchSet(int fieldIndex) {
        return this.fetch().intoSet(fieldIndex);
    }

    @Override
    public final <T> Set<T> fetchSet(int fieldIndex, Class<? extends T> type) {
        return this.fetch().intoSet(fieldIndex, type);
    }

    @Override
    public final <U> Set<U> fetchSet(int fieldIndex, Converter<?, U> converter) {
        return this.fetch().intoSet(fieldIndex, converter);
    }

    @Override
    public final Set<?> fetchSet(String fieldName) {
        return this.fetch().intoSet(fieldName);
    }

    @Override
    public final <T> Set<T> fetchSet(String fieldName, Class<? extends T> type) {
        return this.fetch().intoSet(fieldName, type);
    }

    @Override
    public final <U> Set<U> fetchSet(String fieldName, Converter<?, U> converter) {
        return this.fetch().intoSet(fieldName, converter);
    }

    @Override
    public final Set<?> fetchSet(Name fieldName) {
        return this.fetch().intoSet(fieldName);
    }

    @Override
    public final <T> Set<T> fetchSet(Name fieldName, Class<? extends T> type) {
        return this.fetch().intoSet(fieldName, type);
    }

    @Override
    public final <U> Set<U> fetchSet(Name fieldName, Converter<?, U> converter) {
        return this.fetch().intoSet(fieldName, converter);
    }

    @Override
    public final <T> Set<T> fetchSet(Field<T> field) {
        return this.fetch().intoSet(field);
    }

    @Override
    public final <T> Set<T> fetchSet(Field<?> field, Class<? extends T> type) {
        return this.fetch().intoSet(field, type);
    }

    @Override
    public final <T, U> Set<U> fetchSet(Field<T> field, Converter<? super T, U> converter) {
        return this.fetch().intoSet(field, converter);
    }

    @Override
    public Class<? extends R> getRecordType() {
        return null;
    }

    @Override
    public final <T> List<T> fetchInto(Class<? extends T> type) {
        return this.fetch().into(type);
    }

    @Override
    public final <Z extends Record> Result<Z> fetchInto(Table<Z> table) {
        return this.fetch().into(table);
    }

    @Override
    public final <H extends RecordHandler<? super R>> H fetchInto(H handler) {
        return this.fetch().into(handler);
    }

    @Override
    public final <E> List<E> fetch(RecordMapper<? super R, E> mapper) {
        return this.fetch().map(mapper);
    }

    @Override
    @Deprecated
    public final FutureResult<R> fetchLater() {
        ExecutorService executor = Executors.newSingleThreadExecutor();
        Future future = executor.submit(new ResultQueryCallable());
        return new FutureResultImpl(future, executor);
    }

    @Override
    @Deprecated
    public final FutureResult<R> fetchLater(ExecutorService executor) {
        Future future = executor.submit(new ResultQueryCallable());
        return new FutureResultImpl(future);
    }

    @Override
    public final Result<R> getResult() {
        return this.result;
    }

    private final class ResultQueryCallable
    implements Callable<Result<R>> {
        private ResultQueryCallable() {
        }

        @Override
        public final Result<R> call() throws Exception {
            return AbstractResultQuery.this.fetch();
        }
    }
}

