/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spi.impl.executionservice.impl;

import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.impl.AbstractCompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

class BasicCompletableFuture<V>
extends AbstractCompletableFuture<V> {
    final Future<V> future;

    BasicCompletableFuture(Future<V> future, NodeEngine nodeEngine) {
        super(nodeEngine, nodeEngine.getLogger(BasicCompletableFuture.class));
        this.future = future;
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return this.future.cancel(mayInterruptIfRunning);
    }

    @Override
    public boolean isCancelled() {
        return this.future.isCancelled();
    }

    @Override
    public boolean isDone() {
        boolean done = this.future.isDone();
        if (done && !super.isDone()) {
            this.forceSetResult();
            return true;
        }
        return done || super.isDone();
    }

    @Override
    public V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        V result = this.future.get(timeout, unit);
        if (!super.isDone()) {
            this.setResult(result);
        }
        return result;
    }

    private void forceSetResult() {
        Object result;
        try {
            result = this.future.get();
        }
        catch (Throwable t) {
            result = t;
        }
        this.setResult(result);
    }
}

